/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Copy
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -8543707493627441566L;
    protected Range m_CopyCols = new Range();
    protected int[] m_SelectedAttributes;

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecify list of columns to copy. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tInvert matching sense (i.e. copy all non-specified columns)", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String copyList = Utils.getOption('R', options);
        if (copyList.length() != 0) {
            this.setAttributeIndices(copyList);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[3];
        int current = 0;
        if (this.getInvertSelection()) {
            options[current++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            options[current++] = "-R";
            options[current++] = this.getAttributeIndices();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        int i;
        super.setInputFormat(instanceInfo);
        this.m_CopyCols.setUpper(instanceInfo.numAttributes() - 1);
        Instances outputFormat = new Instances(instanceInfo, 0);
        this.m_SelectedAttributes = this.m_CopyCols.getSelection();
        for (int i2 = 0; i2 < this.m_SelectedAttributes.length; ++i2) {
            int current = this.m_SelectedAttributes[i2];
            Attribute origAttribute = instanceInfo.attribute(current);
            outputFormat.insertAttributeAt((Attribute)origAttribute.copy(), outputFormat.numAttributes());
            outputFormat.renameAttribute(outputFormat.numAttributes() - 1, "Copy of " + origAttribute.name());
        }
        int[] newIndices = new int[instanceInfo.numAttributes() + this.m_SelectedAttributes.length];
        for (i = 0; i < instanceInfo.numAttributes(); ++i) {
            newIndices[i] = i;
        }
        for (i = 0; i < this.m_SelectedAttributes.length; ++i) {
            newIndices[instanceInfo.numAttributes() + i] = this.m_SelectedAttributes[i];
        }
        this.initInputLocators(instanceInfo, newIndices);
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            vals[i] = instance.value(i);
        }
        int j = this.getInputFormat().numAttributes();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int current = this.m_SelectedAttributes[i];
            vals[i + j] = instance.value(current);
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
        return true;
    }

    public String globalInfo() {
        return "An instance filter that copies a range of attributes in the dataset. This is used in conjunction with other filters that overwrite attribute values during the course of their operation -- this filter allows the original attributes to be kept as well as the new attributes.";
    }

    public String invertSelectionTipText() {
        return "Sets copy selected vs unselected action. If set to false, only the specified attributes will be copied; If set to true, non-specified attributes will be copied.";
    }

    public boolean getInvertSelection() {
        return this.m_CopyCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_CopyCols.setInvert(invert);
    }

    public String getAttributeIndices() {
        return this.m_CopyCols.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String rangeList) throws Exception {
        this.m_CopyCols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        Copy.runFilter(new Copy(), argv);
    }
}

