/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import weka.core.Utils;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ExperimenterDefaults
implements Serializable {
    static final long serialVersionUID = -2835933184632147981L;
    public static final String PROPERTY_FILE = "weka/gui/experiment/Experimenter.props";
    protected static Properties PROPERTIES;

    public static String get(String property, String defaultValue) {
        return PROPERTIES.getProperty(property, defaultValue);
    }

    public static final Properties getProperties() {
        return PROPERTIES;
    }

    public static final String getExtension() {
        return ExperimenterDefaults.get("Extension", ".exp");
    }

    public static final String getDestination() {
        return ExperimenterDefaults.get("Destination", "ARFF file");
    }

    public static final String getExperimentType() {
        return ExperimenterDefaults.get("ExperimentType", "Cross-validation");
    }

    public static final boolean getUseClassification() {
        return Boolean.valueOf(ExperimenterDefaults.get("UseClassification", "true"));
    }

    public static final int getFolds() {
        return Integer.parseInt(ExperimenterDefaults.get("Folds", "10"));
    }

    public static final double getTrainPercentage() {
        return Integer.parseInt(ExperimenterDefaults.get("TrainPercentage", "66"));
    }

    public static final int getRepetitions() {
        return Integer.parseInt(ExperimenterDefaults.get("Repetitions", "10"));
    }

    public static final boolean getDatasetsFirst() {
        return Boolean.valueOf(ExperimenterDefaults.get("DatasetsFirst", "true"));
    }

    public static final File getInitialDatasetsDirectory() {
        String dir = ExperimenterDefaults.get("InitialDatasetsDirectory", "");
        if (dir.equals("")) {
            dir = System.getProperty("user.dir");
        }
        return new File(dir);
    }

    public static final boolean getUseRelativePaths() {
        return Boolean.valueOf(ExperimenterDefaults.get("UseRelativePaths", "false"));
    }

    public static final String getTester() {
        return ExperimenterDefaults.get("Tester", new PairedCorrectedTTester().getDisplayName());
    }

    public static final String getRow() {
        return ExperimenterDefaults.get("Row", "Key_Dataset");
    }

    public static final String getColumn() {
        return ExperimenterDefaults.get("Column", "Key_Scheme,Key_Scheme_options,Key_Scheme_version_ID");
    }

    public static final String getComparisonField() {
        return ExperimenterDefaults.get("ComparisonField", "percent_correct");
    }

    public static final double getSignificance() {
        return Double.parseDouble(ExperimenterDefaults.get("Significance", "0.05"));
    }

    public static final String getSorting() {
        return ExperimenterDefaults.get("Sorting", "");
    }

    public static final boolean getShowStdDevs() {
        return Boolean.valueOf(ExperimenterDefaults.get("ShowStdDev", "false"));
    }

    public static final boolean getShowAverage() {
        return Boolean.valueOf(ExperimenterDefaults.get("ShowAverage", "false"));
    }

    public static final int getMeanPrecision() {
        return Integer.parseInt(ExperimenterDefaults.get("MeanPrecision", "2"));
    }

    public static final int getStdDevPrecision() {
        return Integer.parseInt(ExperimenterDefaults.get("StdDevPrecision", "2"));
    }

    public static final ResultMatrix getOutputFormat() {
        ResultMatrix result;
        try {
            String[] options = Utils.splitOptions(ExperimenterDefaults.get("OutputFormat", ResultMatrix.class.getName() + " -col-name-width 0 -row-name-width 25 -mean-width 0 -stddev-width 0 -sig-width 0 -count-width 5 -print-col-names -print-row-names -enum-col-names"));
            String classname = options[0];
            options[0] = "";
            result = (ResultMatrix)Utils.forName(ResultMatrix.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ResultMatrixPlainText();
        }
        result.setMeanPrec(ExperimenterDefaults.getMeanPrecision());
        result.setStdDevPrec(ExperimenterDefaults.getStdDevPrecision());
        result.setShowAverage(ExperimenterDefaults.getShowAverage());
        result.setShowStdDev(ExperimenterDefaults.getShowStdDevs());
        result.setRemoveFilterName(ExperimenterDefaults.getRemoveFilterClassnames());
        return result;
    }

    public static final boolean getRemoveFilterClassnames() {
        return Boolean.valueOf(ExperimenterDefaults.get("RemoveFilterClassnames", "false"));
    }

    public static void main(String[] args) {
        System.out.println("\nExperimenter defaults:");
        Enumeration<Object> names = PROPERTIES.propertyNames();
        Vector<String> sorted = new Vector<String>();
        while (names.hasMoreElements()) {
            sorted.add(names.nextElement().toString());
        }
        Collections.sort(sorted);
        names = sorted.elements();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            System.out.println("- " + name + ": " + PROPERTIES.getProperty(name, ""));
        }
        System.out.println();
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties. Fix before continuing.");
            e.printStackTrace();
            PROPERTIES = new Properties();
        }
    }
}

