/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.logging.Logger;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.PropertySheetPanel;
import weka.gui.boundaryvisualizer.BoundaryPanel;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.gui.visualize.ClassPanel;

public class BoundaryVisualizer
extends JPanel
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 3933877580074013208L;
    protected static int m_WindowCount = 0;
    protected static boolean m_ExitIfNoWindowsOpen = true;
    private Instances m_trainingInstances;
    private Classifier m_classifier;
    protected int m_plotAreaWidth = 384;
    protected int m_plotAreaHeight = 384;
    protected BoundaryPanel m_boundaryPanel;
    protected JComboBox m_classAttBox = new JComboBox();
    protected JComboBox m_xAttBox = new JComboBox();
    protected JComboBox m_yAttBox = new JComboBox();
    protected Dimension COMBO_SIZE;
    protected JButton m_startBut;
    protected JCheckBox m_plotTrainingData;
    protected JPanel m_controlPanel;
    protected ClassPanel m_classPanel;
    private AxisPanel m_xAxisPanel;
    private AxisPanel m_yAxisPanel;
    private double m_maxX;
    private double m_maxY;
    private double m_minX;
    private double m_minY;
    private int m_xIndex;
    private int m_yIndex;
    private KDDataGenerator m_dataGenerator;
    private int m_numberOfSamplesFromEachRegion;
    private int m_generatorSamplesBase;
    private int m_kernelBandwidth;
    private final JTextField m_regionSamplesText;
    private final JTextField m_generatorSamplesText;
    private final JTextField m_kernelBandwidthText;
    protected GenericObjectEditor m_classifierEditor;
    protected PropertyPanel m_ClassifierPanel;
    protected JFileChooser m_FileChooser;
    protected ExtensionFileFilter m_arffFileFilter;
    protected JLabel dataFileLabel;
    protected JPanel m_addRemovePointsPanel;
    protected JComboBox m_classValueSelector;
    protected JRadioButton m_addPointsButton;
    protected JRadioButton m_removePointsButton;
    protected ButtonGroup m_addRemovePointsButtonGroup;
    protected JButton removeAllButton;
    protected JButton chooseButton;

    public String globalInfo() {
        return "Class for visualizing class probability estimates.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Mark Hall");
        result.setValue(TechnicalInformation.Field.TITLE, "Visualizing class probability estimators");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "European Conference on Principles and Practice of Knowledge Discovery in Databases");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PAGES, "168-169");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer-Verlag");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Cavtat-Dubrovnik");
        return result;
    }

    public BoundaryVisualizer() {
        this.COMBO_SIZE = new Dimension((int)((double)this.m_plotAreaWidth * 0.75), this.m_classAttBox.getPreferredSize().height);
        this.m_startBut = new JButton("Start");
        this.m_plotTrainingData = new JCheckBox("Plot training data");
        this.m_classPanel = new ClassPanel();
        this.m_regionSamplesText = new JTextField("0");
        this.m_generatorSamplesText = new JTextField("0");
        this.m_kernelBandwidthText = new JTextField("3  ");
        this.m_classifierEditor = new GenericObjectEditor();
        this.m_ClassifierPanel = new PropertyPanel(this.m_classifierEditor);
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_arffFileFilter = new ExtensionFileFilter(".arff", "Arff data files");
        this.dataFileLabel = new JLabel();
        this.m_addRemovePointsPanel = new JPanel();
        this.m_classValueSelector = new JComboBox();
        this.m_addPointsButton = new JRadioButton();
        this.m_removePointsButton = new JRadioButton();
        this.m_addRemovePointsButtonGroup = new ButtonGroup();
        this.removeAllButton = new JButton("Remove all");
        this.chooseButton = new JButton("Open File");
        this.setLayout(new BorderLayout());
        this.m_classAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_classAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_classAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classAttBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BoundaryVisualizer.this.m_classAttBox.getItemCount() != 0) {
                    try {
                        BoundaryVisualizer.this.m_classPanel.setCindex(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex());
                        BoundaryVisualizer.this.plotTrainingData();
                        System.err.println("Here in class att box listener");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    BoundaryVisualizer.this.setUpClassValueSelectorCB();
                }
            }
        });
        this.m_xAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_xAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_xAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_yAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_yAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_yAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classPanel.setMinimumSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_classPanel.setPreferredSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_controlPanel = new JPanel();
        this.m_controlPanel.setLayout(new BorderLayout());
        JPanel dataChooseHolder = new JPanel(new BorderLayout());
        dataChooseHolder.setBorder(BorderFactory.createTitledBorder("Dataset"));
        dataChooseHolder.add((Component)this.dataFileLabel, "West");
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BoundaryVisualizer.this.setInstancesFromFileQ();
                    int classIndex = BoundaryVisualizer.this.m_classAttBox.getSelectedIndex();
                    if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null && BoundaryVisualizer.this.m_trainingInstances.attribute(classIndex).isNominal()) {
                        BoundaryVisualizer.this.m_startBut.setEnabled(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    System.err.println("exception");
                }
            }
        });
        dataChooseHolder.add((Component)this.chooseButton, "East");
        JPanel classifierHolder = new JPanel();
        classifierHolder.setBorder(BorderFactory.createTitledBorder("Classifier"));
        classifierHolder.setLayout(new BorderLayout());
        this.m_classifierEditor.setClassType(Classifier.class);
        this.m_classifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BoundaryVisualizer.this.m_classifier = (Classifier)BoundaryVisualizer.this.m_classifierEditor.getValue();
                try {
                    int classIndex = BoundaryVisualizer.this.m_classAttBox.getSelectedIndex();
                    if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null && BoundaryVisualizer.this.m_trainingInstances.attribute(classIndex).isNominal()) {
                        BoundaryVisualizer.this.m_startBut.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        classifierHolder.add((Component)this.m_ClassifierPanel, "Center");
        JPanel cHolder = new JPanel();
        cHolder.setBorder(BorderFactory.createTitledBorder("Class Attribute"));
        cHolder.add(this.m_classAttBox);
        JPanel vAttHolder = new JPanel();
        vAttHolder.setLayout(new GridLayout(2, 1));
        vAttHolder.setBorder(BorderFactory.createTitledBorder("Visualization Attributes"));
        vAttHolder.add(this.m_xAttBox);
        vAttHolder.add(this.m_yAttBox);
        JPanel colOne = new JPanel();
        colOne.setLayout(new BorderLayout());
        colOne.add((Component)dataChooseHolder, "North");
        colOne.add((Component)cHolder, "Center");
        JPanel tempPanel = new JPanel();
        tempPanel.setBorder(BorderFactory.createTitledBorder("Sampling control"));
        tempPanel.setLayout(new GridLayout(3, 1));
        JPanel colTwo = new JPanel();
        colTwo.setLayout(new BorderLayout());
        JPanel gsP = new JPanel();
        gsP.setLayout(new BorderLayout());
        gsP.add((Component)new JLabel(" Base for sampling (r)"), "Center");
        gsP.add((Component)this.m_generatorSamplesText, "West");
        tempPanel.add(gsP);
        JPanel rsP = new JPanel();
        rsP.setLayout(new BorderLayout());
        rsP.add((Component)new JLabel(" Num. locations per pixel"), "Center");
        rsP.add((Component)this.m_regionSamplesText, "West");
        tempPanel.add(rsP);
        JPanel ksP = new JPanel();
        ksP.setLayout(new BorderLayout());
        ksP.add((Component)new JLabel(" Kernel bandwidth (k)"), "Center");
        ksP.add((Component)this.m_kernelBandwidthText, "West");
        tempPanel.add(ksP);
        colTwo.add((Component)classifierHolder, "North");
        colTwo.add((Component)vAttHolder, "Center");
        JPanel startPanel = new JPanel();
        startPanel.setBorder(BorderFactory.createTitledBorder("Plotting"));
        startPanel.setLayout(new BorderLayout());
        startPanel.add((Component)this.m_startBut, "Center");
        startPanel.add((Component)this.m_plotTrainingData, "West");
        this.m_controlPanel.add((Component)colOne, "West");
        this.m_controlPanel.add((Component)colTwo, "Center");
        JPanel classHolder = new JPanel();
        classHolder.setLayout(new BorderLayout());
        classHolder.setBorder(BorderFactory.createTitledBorder("Class color"));
        classHolder.add((Component)this.m_classPanel, "Center");
        this.m_controlPanel.add((Component)classHolder, "South");
        JPanel aboutAndControlP = new JPanel();
        aboutAndControlP.setLayout(new BorderLayout());
        aboutAndControlP.add((Component)this.m_controlPanel, "South");
        PropertySheetPanel psp = new PropertySheetPanel();
        psp.setTarget(this);
        JPanel aboutPanel = psp.getAboutPanel();
        aboutAndControlP.add((Component)aboutPanel, "North");
        this.add((Component)aboutAndControlP, "North");
        this.m_addRemovePointsPanel.setBorder(BorderFactory.createTitledBorder("Add / remove data points"));
        this.m_addRemovePointsPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        this.m_addRemovePointsPanel.add(this.m_addPointsButton);
        constraints.gridx = 1;
        this.m_addRemovePointsPanel.add((Component)new JLabel("Add points"), constraints);
        constraints.gridx = 2;
        this.m_addRemovePointsPanel.add(this.m_classValueSelector);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.m_addRemovePointsPanel.add((Component)this.m_removePointsButton, constraints);
        constraints.gridx = 1;
        this.m_addRemovePointsPanel.add((Component)new JLabel("Remove points"), constraints);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BoundaryVisualizer.this.m_trainingInstances != null) {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Stop")) {
                        return;
                    }
                    BoundaryVisualizer.this.m_boundaryPanel.removeAllInstances();
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.m_xAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_xAxisPanel.getWidth(), BoundaryVisualizer.this.m_xAxisPanel.getHeight());
                    BoundaryVisualizer.this.m_yAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_yAxisPanel.getWidth(), BoundaryVisualizer.this.m_yAxisPanel.getHeight());
                    try {
                        BoundaryVisualizer.this.m_boundaryPanel.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        constraints.gridx = 2;
        this.m_addRemovePointsPanel.add((Component)this.removeAllButton, constraints);
        this.m_addRemovePointsButtonGroup.add(this.m_addPointsButton);
        this.m_addRemovePointsButtonGroup.add(this.m_removePointsButton);
        this.m_addPointsButton.setSelected(true);
        this.m_boundaryPanel = new BoundaryPanel(this.m_plotAreaWidth, this.m_plotAreaHeight);
        this.m_numberOfSamplesFromEachRegion = this.m_boundaryPanel.getNumSamplesPerRegion();
        this.m_regionSamplesText.setText("" + this.m_numberOfSamplesFromEachRegion + "  ");
        this.m_generatorSamplesBase = (int)this.m_boundaryPanel.getGeneratorSamplesBase();
        this.m_generatorSamplesText.setText("" + this.m_generatorSamplesBase + "  ");
        this.m_dataGenerator = new KDDataGenerator();
        this.m_kernelBandwidth = this.m_dataGenerator.getKernelBandwidth();
        this.m_kernelBandwidthText.setText("" + this.m_kernelBandwidth + "  ");
        this.m_boundaryPanel.setDataGenerator(this.m_dataGenerator);
        JPanel gfxPanel = new JPanel();
        gfxPanel.setLayout(new BorderLayout());
        gfxPanel.setBorder(BorderFactory.createEtchedBorder());
        gfxPanel.add((Component)this.m_boundaryPanel, "Center");
        this.m_xAxisPanel = new AxisPanel(false);
        gfxPanel.add((Component)this.m_xAxisPanel, "South");
        this.m_yAxisPanel = new AxisPanel(true);
        gfxPanel.add((Component)this.m_yAxisPanel, "West");
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)gfxPanel, "Center");
        this.add((Component)containerPanel, "West");
        JPanel rightHandToolsPanel = new JPanel();
        rightHandToolsPanel.setLayout(new BoxLayout(rightHandToolsPanel, 3));
        rightHandToolsPanel.add(this.m_addRemovePointsPanel);
        JButton newWindowButton = new JButton("Open a new window");
        newWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Instances newTrainingData = null;
                    Classifier newClassifier = null;
                    if (BoundaryVisualizer.this.m_trainingInstances != null) {
                        newTrainingData = new Instances(BoundaryVisualizer.this.m_trainingInstances);
                    }
                    if (BoundaryVisualizer.this.m_classifier != null) {
                        newClassifier = AbstractClassifier.makeCopy(BoundaryVisualizer.this.m_classifier);
                    }
                    BoundaryVisualizer.createNewVisualizerWindow(newClassifier, newTrainingData);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel newWindowHolder = new JPanel();
        newWindowHolder.add(newWindowButton);
        rightHandToolsPanel.add(newWindowHolder);
        rightHandToolsPanel.add(tempPanel);
        rightHandToolsPanel.add(startPanel);
        containerPanel.add((Component)rightHandToolsPanel, "East");
        this.m_startBut.setEnabled(false);
        this.m_startBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block7: {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Start")) {
                        if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null) {
                            try {
                                int BPSuccessCode = BoundaryVisualizer.this.setUpBoundaryPanel();
                                if (BPSuccessCode == 1) {
                                    JOptionPane.showMessageDialog(null, "Error: Kernel Bandwidth can't be less than zero!");
                                    break block7;
                                }
                                if (BPSuccessCode == 2) {
                                    JOptionPane.showMessageDialog(null, "Error: Kernel Bandwidth must be less than the number of training instances!");
                                    break block7;
                                }
                                BoundaryVisualizer.this.m_boundaryPanel.start();
                                BoundaryVisualizer.this.m_startBut.setText("Stop");
                                BoundaryVisualizer.this.setControlEnabledStatus(false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        BoundaryVisualizer.this.m_boundaryPanel.stopPlotting();
                        BoundaryVisualizer.this.m_startBut.setText("Start");
                        BoundaryVisualizer.this.setControlEnabledStatus(true);
                    }
                }
            }
        });
        this.m_boundaryPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundaryVisualizer.this.m_startBut.setText("Start");
                BoundaryVisualizer.this.setControlEnabledStatus(true);
            }
        });
        this.m_classPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<Color> colors = BoundaryVisualizer.this.m_boundaryPanel.getColors();
                    FileOutputStream fos = new FileOutputStream("colors.ser");
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(colors);
                    oos.flush();
                    oos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BoundaryVisualizer.this.m_boundaryPanel.replot();
            }
        });
        this.m_boundaryPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BoundaryVisualizer.this.m_trainingInstances != null) {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Stop")) {
                        return;
                    }
                    if (BoundaryVisualizer.this.m_addPointsButton.isSelected()) {
                        double classVal = 0.0;
                        boolean validInput = true;
                        if (BoundaryVisualizer.this.m_trainingInstances.attribute(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex()).isNominal()) {
                            classVal = BoundaryVisualizer.this.m_classValueSelector.getSelectedIndex();
                        } else {
                            String indexStr = "";
                            try {
                                indexStr = (String)BoundaryVisualizer.this.m_classValueSelector.getSelectedItem();
                                classVal = Double.parseDouble(indexStr);
                            }
                            catch (Exception ex) {
                                if (indexStr == null) {
                                    indexStr = "";
                                }
                                JOptionPane.showMessageDialog(null, "Error adding a point: \"" + indexStr + "\"" + " is not a valid class value.");
                                validInput = false;
                            }
                        }
                        if (validInput) {
                            BoundaryVisualizer.this.m_boundaryPanel.addTrainingInstanceFromMouseLocation(e.getX(), e.getY(), BoundaryVisualizer.this.m_classAttBox.getSelectedIndex(), classVal);
                        }
                    } else {
                        BoundaryVisualizer.this.m_boundaryPanel.removeTrainingInstanceFromMouseLocation(e.getX(), e.getY());
                    }
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BoundaryVisualizer.this.m_xAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_xAxisPanel.getWidth(), BoundaryVisualizer.this.m_xAxisPanel.getHeight());
                    BoundaryVisualizer.this.m_yAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_yAxisPanel.getWidth(), BoundaryVisualizer.this.m_yAxisPanel.getHeight());
                }
            }
        });
    }

    private void setControlEnabledStatus(boolean status) {
        this.m_classAttBox.setEnabled(status);
        this.m_xAttBox.setEnabled(status);
        this.m_yAttBox.setEnabled(status);
        this.m_regionSamplesText.setEnabled(status);
        this.m_generatorSamplesText.setEnabled(status);
        this.m_kernelBandwidthText.setEnabled(status);
        this.m_plotTrainingData.setEnabled(status);
        this.removeAllButton.setEnabled(status);
        this.m_classValueSelector.setEnabled(status);
        this.m_addPointsButton.setEnabled(status);
        this.m_removePointsButton.setEnabled(status);
        this.m_FileChooser.setEnabled(status);
        this.chooseButton.setEnabled(status);
    }

    public void setClassifier(Classifier newClassifier) throws Exception {
        this.m_classifier = newClassifier;
        try {
            int classIndex = this.m_classAttBox.getSelectedIndex();
            if (this.m_classifier != null && this.m_trainingInstances != null && this.m_trainingInstances.attribute(classIndex).isNominal()) {
                this.m_startBut.setEnabled(true);
            } else {
                this.m_startBut.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void computeBounds() {
        this.m_boundaryPanel.computeMinMaxAtts();
        String xName = (String)this.m_xAttBox.getSelectedItem();
        if (xName == null) {
            return;
        }
        xName = Utils.removeSubstring(xName, "X: ");
        xName = Utils.removeSubstring(xName, " (Num)");
        String yName = (String)this.m_yAttBox.getSelectedItem();
        yName = Utils.removeSubstring(yName, "Y: ");
        yName = Utils.removeSubstring(yName, " (Num)");
        this.m_xIndex = -1;
        this.m_yIndex = -1;
        for (int i = 0; i < this.m_trainingInstances.numAttributes(); ++i) {
            if (this.m_trainingInstances.attribute(i).name().equals(xName)) {
                this.m_xIndex = i;
            }
            if (!this.m_trainingInstances.attribute(i).name().equals(yName)) continue;
            this.m_yIndex = i;
        }
        this.m_minX = this.m_boundaryPanel.getMinXBound();
        this.m_minY = this.m_boundaryPanel.getMinYBound();
        this.m_maxX = this.m_boundaryPanel.getMaxXBound();
        this.m_maxY = this.m_boundaryPanel.getMaxYBound();
        this.m_xAxisPanel.repaint(0L, 0, 0, this.m_xAxisPanel.getWidth(), this.m_xAxisPanel.getHeight());
        this.m_yAxisPanel.repaint(0L, 0, 0, this.m_yAxisPanel.getWidth(), this.m_yAxisPanel.getHeight());
    }

    public Instances getInstances() {
        return this.m_trainingInstances;
    }

    public void setInstances(Instances inst) throws Exception {
        if (inst == null) {
            this.m_trainingInstances = inst;
            this.m_classPanel.setInstances(this.m_trainingInstances);
            return;
        }
        int numCount = 0;
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (!inst.attribute(i).isNumeric()) continue;
            ++numCount;
        }
        if (numCount < 2) {
            JOptionPane.showMessageDialog(null, "We need at least two numeric attributes in order to visualize!");
            return;
        }
        this.m_trainingInstances = inst;
        this.m_classPanel.setInstances(this.m_trainingInstances);
        String[] classAttNames = new String[this.m_trainingInstances.numAttributes()];
        Vector<String> xAttNames = new Vector<String>();
        Vector<String> yAttNames = new Vector<String>();
        for (int i = 0; i < this.m_trainingInstances.numAttributes(); ++i) {
            classAttNames[i] = this.m_trainingInstances.attribute(i).name();
            String type = " (" + Attribute.typeToStringShort(this.m_trainingInstances.attribute(i)) + ")";
            int n = i;
            classAttNames[n] = classAttNames[n] + type;
            if (!this.m_trainingInstances.attribute(i).isNumeric()) continue;
            xAttNames.add("X: " + classAttNames[i]);
            yAttNames.add("Y: " + classAttNames[i]);
        }
        this.m_classAttBox.setModel(new DefaultComboBoxModel<String>(classAttNames));
        this.m_xAttBox.setModel(new DefaultComboBoxModel(xAttNames));
        this.m_yAttBox.setModel(new DefaultComboBoxModel(yAttNames));
        if (xAttNames.size() > 1) {
            this.m_yAttBox.setSelectedIndex(1);
        }
        this.m_classAttBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundaryVisualizer.this.configureForClassAttribute();
            }
        });
        this.m_xAttBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.m_yAttBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        if (classAttNames.length > 0) {
            this.m_classAttBox.setSelectedIndex(classAttNames.length - 1);
        }
        this.setUpClassValueSelectorCB();
        this.configureForClassAttribute();
        this.m_classPanel.setCindex(this.m_classAttBox.getSelectedIndex());
        this.plotTrainingData();
        this.computeBounds();
        this.revalidate();
        this.repaint();
        if (this.getTopLevelAncestor() instanceof Window) {
            ((Window)this.getTopLevelAncestor()).pack();
        }
    }

    private void setUpClassValueSelectorCB() {
        this.m_classValueSelector.removeAllItems();
        int classAttribute = this.m_classAttBox.getSelectedIndex();
        this.m_trainingInstances.setClassIndex(classAttribute);
        if (this.m_trainingInstances.attribute(classAttribute).isNominal()) {
            this.m_classValueSelector.setEditable(false);
            for (int i = 0; i < this.m_trainingInstances.numClasses(); ++i) {
                this.m_classValueSelector.insertItemAt(this.m_trainingInstances.attribute(classAttribute).value(i), i);
            }
            this.m_classValueSelector.setSelectedIndex(0);
        } else {
            this.m_classValueSelector.setEditable(true);
        }
    }

    private void configureForClassAttribute() {
        int classIndex = this.m_classAttBox.getSelectedIndex();
        if (classIndex >= 0) {
            if (!this.m_trainingInstances.attribute(classIndex).isNominal() || this.m_classifier == null) {
                this.m_startBut.setEnabled(false);
            } else {
                this.m_startBut.setEnabled(true);
            }
            ArrayList<Color> colors = new ArrayList<Color>();
            if (!this.m_trainingInstances.attribute(this.m_classAttBox.getSelectedIndex()).isNominal()) {
                for (Color element : BoundaryPanel.DEFAULT_COLORS) {
                    colors.add(element);
                }
            } else {
                for (int i = 0; i < this.m_trainingInstances.attribute(classIndex).numValues(); ++i) {
                    colors.add(BoundaryPanel.DEFAULT_COLORS[i % BoundaryPanel.DEFAULT_COLORS.length]);
                }
            }
            this.m_classPanel.setColours(colors);
            this.m_boundaryPanel.setColors(colors);
        }
    }

    public void setInstancesFromFileQ() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selected = this.m_FileChooser.getSelectedFile();
            try {
                String relationName;
                BufferedReader r = new BufferedReader(new FileReader(selected));
                Instances i = new Instances(r);
                this.setInstances(i);
                String truncatedN = relationName = i.relationName();
                if (relationName.length() > 25) {
                    truncatedN = relationName.substring(0, 25) + "...";
                }
                this.dataFileLabel.setText(truncatedN);
                this.dataFileLabel.setToolTipText(relationName);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
                e.printStackTrace();
            }
        }
    }

    public int setUpBoundaryPanel() throws Exception {
        int returner = 0;
        int tempSamples = this.m_numberOfSamplesFromEachRegion;
        try {
            tempSamples = Integer.parseInt(this.m_regionSamplesText.getText().trim());
        }
        catch (Exception ex) {
            this.m_regionSamplesText.setText("" + tempSamples);
        }
        this.m_numberOfSamplesFromEachRegion = tempSamples;
        this.m_boundaryPanel.setNumSamplesPerRegion(tempSamples);
        tempSamples = this.m_generatorSamplesBase;
        try {
            tempSamples = Integer.parseInt(this.m_generatorSamplesText.getText().trim());
        }
        catch (Exception ex) {
            this.m_generatorSamplesText.setText("" + tempSamples);
        }
        this.m_generatorSamplesBase = tempSamples;
        this.m_boundaryPanel.setGeneratorSamplesBase(tempSamples);
        tempSamples = this.m_kernelBandwidth;
        try {
            tempSamples = Integer.parseInt(this.m_kernelBandwidthText.getText().trim());
        }
        catch (Exception ex) {
            this.m_kernelBandwidthText.setText("" + tempSamples);
        }
        this.m_kernelBandwidth = tempSamples;
        this.m_dataGenerator.setKernelBandwidth(tempSamples);
        if (this.m_kernelBandwidth < 0) {
            returner = 1;
        }
        if (this.m_kernelBandwidth >= this.m_trainingInstances.numInstances()) {
            returner = 2;
        }
        this.m_trainingInstances.setClassIndex(this.m_classAttBox.getSelectedIndex());
        this.m_boundaryPanel.setClassifier(this.m_classifier);
        this.m_boundaryPanel.setTrainingData(this.m_trainingInstances);
        this.m_boundaryPanel.setXAttribute(this.m_xIndex);
        this.m_boundaryPanel.setYAttribute(this.m_yIndex);
        this.m_boundaryPanel.setPlotTrainingData(this.m_plotTrainingData.isSelected());
        return returner;
    }

    public void plotTrainingData() throws Exception {
        this.m_boundaryPanel.initialize();
        this.setUpBoundaryPanel();
        this.computeBounds();
        this.m_boundaryPanel.plotTrainingData();
    }

    public void stopPlotting() {
        this.m_boundaryPanel.stopPlotting();
    }

    public static void setExitIfNoWindowsOpen(boolean value) {
        m_ExitIfNoWindowsOpen = value;
    }

    public static boolean getExitIfNoWindowsOpen() {
        return m_ExitIfNoWindowsOpen;
    }

    public static void createNewVisualizerWindow(Classifier classifier, Instances instances) throws Exception {
        ++m_WindowCount;
        final JFrame jf = new JFrame("Weka classification boundary visualizer");
        jf.getContentPane().setLayout(new BorderLayout());
        final BoundaryVisualizer bv = new BoundaryVisualizer();
        jf.getContentPane().add((Component)bv, "Center");
        jf.setSize(bv.getMinimumSize());
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                bv.stopPlotting();
                jf.dispose();
                if (--m_WindowCount == 0 && m_ExitIfNoWindowsOpen) {
                    System.exit(0);
                }
            }
        });
        jf.pack();
        jf.setVisible(true);
        jf.setResizable(false);
        if (classifier == null) {
            bv.setClassifier(null);
        } else {
            bv.setClassifier(classifier);
            bv.m_classifierEditor.setValue(classifier);
        }
        if (instances == null) {
            bv.setInstances(null);
        } else {
            bv.setInstances(instances);
            try {
                bv.dataFileLabel.setText(instances.relationName());
                bv.plotTrainingData();
                bv.m_classPanel.setCindex(bv.m_classAttBox.getSelectedIndex());
                bv.repaint(0L, 0, 0, bv.getWidth(), bv.getHeight());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        try {
            if (args.length < 2) {
                BoundaryVisualizer.createNewVisualizerWindow(null, null);
            } else {
                String[] argsR = null;
                if (args.length > 2) {
                    argsR = new String[args.length - 2];
                    for (int j = 2; j < args.length; ++j) {
                        argsR[j - 2] = args[j];
                    }
                }
                Classifier c = AbstractClassifier.forName(args[1], argsR);
                System.err.println("Loading instances from : " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                BoundaryVisualizer.createNewVisualizerWindow(c, i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    private class AxisPanel
    extends JPanel {
        private static final long serialVersionUID = -7421022416674492712L;
        private static final int MAX_PRECISION = 10;
        private boolean m_vertical = false;
        private final int PAD = 5;
        private FontMetrics m_fontMetrics;
        private int m_fontHeight;

        public AxisPanel(boolean vertical) {
            this.m_vertical = vertical;
            this.setBackground(Color.black);
            String fontFamily = this.getFont().getFamily();
            Font newFont = new Font(fontFamily, 0, 10);
            this.setFont(newFont);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.m_fontMetrics == null) {
                Graphics g = this.getGraphics();
                this.m_fontMetrics = g.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            if (!this.m_vertical) {
                return new Dimension(this.getSize().width, 7 + this.m_fontHeight);
            }
            return new Dimension(50, this.getSize().height);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.setBackground(Color.black);
            if (this.m_fontMetrics == null) {
                this.m_fontMetrics = g.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            Dimension d = this.getSize();
            Dimension d2 = BoundaryVisualizer.this.m_boundaryPanel.getSize();
            g.setColor(Color.gray);
            int hf = this.m_fontMetrics.getAscent();
            if (!this.m_vertical) {
                g.drawLine(d.width, 5, d.width - d2.width, 5);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int precisionXmax = 1;
                    int precisionXmin = 1;
                    int whole = (int)Math.abs(BoundaryVisualizer.this.m_maxX);
                    double decimal = Math.abs(BoundaryVisualizer.this.m_maxX) - (double)whole;
                    int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                    int n = precisionXmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                    if (precisionXmax > 10) {
                        precisionXmax = 1;
                    }
                    String maxStringX = Utils.doubleToString(BoundaryVisualizer.this.m_maxX, nondecimal + 1 + precisionXmax, precisionXmax);
                    whole = (int)Math.abs(BoundaryVisualizer.this.m_minX);
                    decimal = Math.abs(BoundaryVisualizer.this.m_minX) - (double)whole;
                    nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                    int n2 = precisionXmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minX)) / Math.log(10.0)) + 2 : 1;
                    if (precisionXmin > 10) {
                        precisionXmin = 1;
                    }
                    String minStringX = Utils.doubleToString(BoundaryVisualizer.this.m_minX, nondecimal + 1 + precisionXmin, precisionXmin);
                    g.drawString(minStringX, d.width - d2.width, 5 + hf + 2);
                    int maxWidth = this.m_fontMetrics.stringWidth(maxStringX);
                    g.drawString(maxStringX, d.width - maxWidth, 5 + hf + 2);
                }
            } else {
                g.drawLine(d.width - 5, 0, d.width - 5, d2.height);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int precisionYmax = 1;
                    int precisionYmin = 1;
                    int whole = (int)Math.abs(BoundaryVisualizer.this.m_maxY);
                    double decimal = Math.abs(BoundaryVisualizer.this.m_maxY) - (double)whole;
                    int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                    int n = precisionYmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                    if (precisionYmax > 10) {
                        precisionYmax = 1;
                    }
                    String maxStringY = Utils.doubleToString(BoundaryVisualizer.this.m_maxY, nondecimal + 1 + precisionYmax, precisionYmax);
                    whole = (int)Math.abs(BoundaryVisualizer.this.m_minY);
                    decimal = Math.abs(BoundaryVisualizer.this.m_minY) - (double)whole;
                    nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                    int n3 = precisionYmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minY)) / Math.log(10.0)) + 2 : 1;
                    if (precisionYmin > 10) {
                        precisionYmin = 1;
                    }
                    String minStringY = Utils.doubleToString(BoundaryVisualizer.this.m_minY, nondecimal + 1 + precisionYmin, precisionYmin);
                    int maxWidth = this.m_fontMetrics.stringWidth(minStringY);
                    g.drawString(minStringY, d.width - 5 - maxWidth - 2, d2.height);
                    maxWidth = this.m_fontMetrics.stringWidth(maxStringY);
                    g.drawString(maxStringY, d.width - 5 - maxWidth - 2, hf);
                }
            }
        }
    }
}

