/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;

public class DatabaseSaver
extends AbstractSaver
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler,
EnvironmentHandler {
    static final long serialVersionUID = 863971733782624956L;
    protected DatabaseConnection m_DataBaseConnection;
    protected String m_tableName;
    protected String m_resolvedTableName;
    protected String m_inputFile;
    protected String m_createText;
    protected String m_createDouble;
    protected String m_createInt;
    protected String m_createDate;
    protected SimpleDateFormat m_DateFormat;
    protected String m_idColumn;
    protected int m_count;
    protected boolean m_id;
    protected boolean m_tabName;
    protected String m_URL;
    protected String m_Username;
    protected String m_Password;
    protected File m_CustomPropsFile = null;
    protected boolean m_truncate;
    protected transient Environment m_env;

    public DatabaseSaver() throws Exception {
        this.resetOptions();
    }

    private void checkEnv() {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
        try {
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(this.m_URL);
            this.setUser(this.m_Username);
            this.setPassword(this.m_Password);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected DatabaseConnection newDatabaseConnection() throws Exception {
        DatabaseConnection result;
        this.checkEnv();
        if (this.m_CustomPropsFile != null) {
            File pFile = new File(this.m_CustomPropsFile.getPath());
            String pPath = this.m_CustomPropsFile.getPath();
            try {
                pPath = this.m_env.substitute(pPath);
                pFile = new File(pPath);
            }
            catch (Exception ex) {
                // empty catch block
            }
            result = new DatabaseConnection(pFile);
        } else {
            result = new DatabaseConnection();
        }
        this.m_createText = result.getProperties().getProperty("CREATE_STRING");
        this.m_createDouble = result.getProperties().getProperty("CREATE_DOUBLE");
        this.m_createInt = result.getProperties().getProperty("CREATE_INT");
        this.m_createDate = result.getProperties().getProperty("CREATE_DATE", "DATETIME");
        this.m_DateFormat = new SimpleDateFormat(result.getProperties().getProperty("DateFormat", "yyyy-MM-dd HH:mm:ss"));
        this.m_idColumn = result.getProperties().getProperty("idColumn");
        return result;
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setRetrieval(0);
        try {
            if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            this.m_DataBaseConnection = this.newDatabaseConnection();
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        this.m_URL = this.m_DataBaseConnection.getDatabaseURL();
        this.m_tableName = "";
        this.m_Username = this.m_DataBaseConnection.getUsername();
        this.m_Password = this.m_DataBaseConnection.getPassword();
        this.m_count = 1;
        this.m_id = false;
        this.m_tabName = true;
    }

    @Override
    public void cancel() {
        if (this.getWriteMode() == 2) {
            try {
                this.m_DataBaseConnection.update("DROP TABLE " + this.m_resolvedTableName);
                if (this.m_DataBaseConnection.tableExists(this.m_resolvedTableName)) {
                    System.err.println("Table cannot be dropped.");
                }
            }
            catch (Exception ex) {
                this.printException(ex);
            }
            this.resetOptions();
        }
    }

    public String globalInfo() {
        return "Writes to a database (tested with MySQL, InstantDB, HSQLDB).";
    }

    public void setTableName(String tn) {
        this.m_tableName = tn;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String tableNameTipText() {
        return "Sets the name of the table.";
    }

    public void setTruncate(boolean t) {
        this.m_truncate = t;
    }

    public boolean getTruncate() {
        return this.m_truncate;
    }

    public String truncateTipText() {
        return "Truncate (i.e. drop and recreate) table if it already exists";
    }

    public void setAutoKeyGeneration(boolean flag) {
        this.m_id = flag;
    }

    public boolean getAutoKeyGeneration() {
        return this.m_id;
    }

    public String autoKeyGenerationTipText() {
        return "If set to true, a primary key column is generated automatically (containing the row number as INTEGER). The name of the key is read from DatabaseUtils (idColumn) This primary key can be used for incremental loading (requires an unique key). This primary key will not be loaded as an attribute.";
    }

    public void setRelationForTableName(boolean flag) {
        this.m_tabName = flag;
    }

    public boolean getRelationForTableName() {
        return this.m_tabName;
    }

    public String relationForTableNameTipText() {
        return "If set to true, the relation name will be used as name for the database table. Otherwise the user has to provide a table name.";
    }

    @Override
    public void setUrl(String url) {
        this.checkEnv();
        String uCopy = this.m_URL = url;
        try {
            uCopy = this.m_env.substitute(uCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setDatabaseURL(uCopy);
    }

    @Override
    public String getUrl() {
        return this.m_URL;
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    @Override
    public void setUser(String user) {
        this.checkEnv();
        this.m_Username = user;
        String userCopy = user;
        try {
            userCopy = this.m_env.substitute(userCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setUsername(userCopy);
    }

    @Override
    public String getUser() {
        return this.m_Username;
    }

    public String userTipText() {
        return "The user name for the database";
    }

    @Override
    public void setPassword(String password) {
        this.checkEnv();
        this.m_Password = password;
        String passCopy = password;
        try {
            passCopy = this.m_env.substitute(passCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DataBaseConnection.setPassword(password);
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The database password";
    }

    public void setCustomPropsFile(File value) {
        this.m_CustomPropsFile = value;
    }

    public File getCustomPropsFile() {
        return this.m_CustomPropsFile;
    }

    public String customPropsFileTipText() {
        return "The custom properties that the user can use to override the default ones.";
    }

    public void setDestination(String url, String userName, String password) {
        try {
            this.checkEnv();
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(url);
            this.setUser(userName);
            this.setPassword(password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setDestination(String url) {
        try {
            this.checkEnv();
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUrl(url);
            this.setUser(this.m_Username);
            this.setPassword(this.m_Password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setDestination() {
        try {
            this.checkEnv();
            this.m_DataBaseConnection = this.newDatabaseConnection();
            this.setUser(this.m_Username);
            this.setPassword(this.m_Password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void writeStructure() throws Exception {
        StringBuffer query = new StringBuffer();
        Instances structure = this.getInstances();
        query.append("CREATE TABLE ");
        this.m_resolvedTableName = this.m_env.substitute(this.m_tableName);
        if (this.m_tabName || this.m_resolvedTableName.equals("")) {
            this.m_resolvedTableName = this.m_DataBaseConnection.maskKeyword(structure.relationName());
        }
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_resolvedTableName = this.m_resolvedTableName.toUpperCase();
            this.m_createInt = this.m_createInt.toUpperCase();
            this.m_createDouble = this.m_createDouble.toUpperCase();
            this.m_createText = this.m_createText.toUpperCase();
            this.m_createDate = this.m_createDate.toUpperCase();
        }
        this.m_resolvedTableName = this.m_resolvedTableName.replaceAll("[^\\w]", "_");
        this.m_resolvedTableName = this.m_DataBaseConnection.maskKeyword(this.m_resolvedTableName);
        query.append(this.m_resolvedTableName);
        if (structure.numAttributes() == 0) {
            throw new Exception("Instances have no attribute.");
        }
        query.append(" ( ");
        if (this.m_DataBaseConnection.tableExists(this.m_resolvedTableName)) {
            if (!this.m_truncate) {
                System.err.println("[DatabaseSaver] Table '" + this.m_resolvedTableName + "' already exists - will append data...");
                if (this.getRetrieval() == 2 && this.m_id) {
                    String countS = "SELECT COUNT(*) FROM " + this.m_resolvedTableName;
                    this.m_DataBaseConnection.execute(countS);
                    ResultSet countRS = this.m_DataBaseConnection.getResultSet();
                    countRS.next();
                    this.m_count = countRS.getInt(1);
                    countRS.close();
                    ++this.m_count;
                }
                return;
            }
            String trunc = "DROP TABLE " + this.m_resolvedTableName;
            this.m_DataBaseConnection.execute(trunc);
        }
        if (this.m_id) {
            if (this.m_DataBaseConnection.getUpperCase()) {
                this.m_idColumn = this.m_idColumn.toUpperCase();
            }
            query.append(this.m_DataBaseConnection.maskKeyword(this.m_idColumn));
            query.append(" ");
            query.append(this.m_createInt);
            query.append(" PRIMARY KEY,");
        }
        for (int i = 0; i < structure.numAttributes(); ++i) {
            Attribute att = structure.attribute(i);
            String attName = att.name();
            attName = attName.replaceAll("[^\\w]", "_");
            attName = this.m_DataBaseConnection.maskKeyword(attName);
            if (this.m_DataBaseConnection.getUpperCase()) {
                query.append(attName.toUpperCase());
            } else {
                query.append(attName);
            }
            if (att.isDate()) {
                query.append(" " + this.m_createDate);
            } else if (att.isNumeric()) {
                query.append(" " + this.m_createDouble);
            } else {
                query.append(" " + this.m_createText);
            }
            if (i == structure.numAttributes() - 1) continue;
            query.append(", ");
        }
        query.append(" )");
        this.m_DataBaseConnection.update(query.toString());
        this.m_DataBaseConnection.close();
        if (!this.m_DataBaseConnection.tableExists(this.m_resolvedTableName)) {
            throw new IOException("Table cannot be built.");
        }
    }

    private void writeInstance(Instance inst) throws Exception {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO ");
        insert.append(this.m_resolvedTableName);
        insert.append(" VALUES ( ");
        if (this.m_id) {
            insert.append(this.m_count);
            insert.append(", ");
            ++this.m_count;
        }
        for (int j = 0; j < inst.numAttributes(); ++j) {
            if (inst.isMissing(j)) {
                insert.append("NULL");
            } else if (inst.attribute(j).isDate()) {
                insert.append("'" + this.m_DateFormat.format((long)inst.value(j)) + "'");
            } else if (inst.attribute(j).isNumeric()) {
                insert.append(inst.value(j));
            } else {
                String stringInsert = "'" + inst.stringValue(j) + "'";
                if (stringInsert.length() > 2) {
                    stringInsert = stringInsert.replaceAll("''", "'");
                }
                insert.append(stringInsert);
            }
            if (j == inst.numAttributes() - 1) continue;
            insert.append(", ");
        }
        insert.append(" )");
        if (this.m_DataBaseConnection.update(insert.toString()) < 1) {
            throw new IOException("Tuple cannot be inserted.");
        }
        this.m_DataBaseConnection.close();
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (writeMode == 1) {
                if (structure == null) {
                    this.setWriteMode(2);
                    if (inst != null) {
                        throw new Exception("Structure(Header Information) has to be set in advance");
                    }
                } else {
                    this.setWriteMode(3);
                }
                writeMode = this.getWriteMode();
            }
            if (writeMode == 2) {
                this.cancel();
            }
            if (writeMode == 3) {
                this.setWriteMode(0);
                this.writeStructure();
                writeMode = this.getWriteMode();
            }
            if (writeMode == 0) {
                if (structure == null) {
                    throw new IOException("No instances information available.");
                }
                if (inst != null) {
                    this.writeInstance(inst);
                } else {
                    this.m_DataBaseConnection.disconnectFromDatabase();
                    this.resetStructure();
                    this.m_count = 1;
                }
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    @Override
    public void writeBatch() throws IOException {
        Instances instances = this.getInstances();
        if (instances == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        this.setRetrieval(1);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            this.setWriteMode(0);
            this.writeStructure();
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.writeInstance(instances.instance(i));
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.setWriteMode(1);
            this.resetStructure();
            this.m_count = 1;
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void printException(Exception ex) {
        System.out.println("\n--- Exception caught ---\n");
        while (ex != null) {
            System.out.println("Message:   " + ex.getMessage());
            if (ex instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)ex).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)ex).getErrorCode());
                ex = ((SQLException)ex).getNextException();
            } else {
                ex = null;
            }
            System.out.println("");
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getUrl() != null && this.getUrl().length() != 0) {
            options.add("-url");
            options.add(this.getUrl());
        }
        if (this.getUser() != null && this.getUser().length() != 0) {
            options.add("-user");
            options.add(this.getUser());
        }
        if (this.getPassword() != null && this.getPassword().length() != 0) {
            options.add("-password");
            options.add(this.getPassword());
        }
        if (this.m_tableName != null && this.m_tableName.length() != 0) {
            options.add("-T");
            options.add(this.m_tableName);
        }
        if (this.m_truncate) {
            options.add("-truncate");
        }
        if (this.m_id) {
            options.add("-P");
        }
        if (this.m_inputFile != null && this.m_inputFile.length() != 0) {
            options.add("-i");
            options.add(this.m_inputFile);
        }
        if (this.m_CustomPropsFile != null && !this.m_CustomPropsFile.isDirectory()) {
            options.add("-custom-props");
            options.add(this.m_CustomPropsFile.toString());
        }
        return options.toArray(new String[options.size()]);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe JDBC URL to connect to.\n\t(default: from DatabaseUtils.props file)", "url", 1, "-url <JDBC URL>"));
        newVector.addElement(new Option("\tThe user to connect with to the database.\n\t(default: none)", "user", 1, "-user <name>"));
        newVector.addElement(new Option("\tThe password to connect with to the database.\n\t(default: none)", "password", 1, "-password <password>"));
        newVector.addElement(new Option("\tThe name of the table.\n\t(default: the relation name)", "T", 1, "-T <table name>"));
        newVector.addElement(new Option("\tTruncate (i.e. delete any data) in table before inserting", "truncate", 0, "-truncate"));
        newVector.addElement(new Option("\tAdd an ID column as primary key. The name is specified\n\tin the DatabaseUtils file ('idColumn'). The DatabaseLoader\n\twon't load this column.", "P", 0, "-P"));
        newVector.add(new Option("\tThe custom properties file to use instead of default ones,\n\tcontaining the database parameters.\n\t(default: none)", "custom-props", 1, "-custom-props <file>"));
        newVector.addElement(new Option("\tInput file in arff format that should be saved in database.", "i", 1, "-i <input file name>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String tmpStr = Utils.getOption("url", options);
        if (tmpStr.length() != 0) {
            this.setUrl(tmpStr);
        }
        if ((tmpStr = Utils.getOption("user", options)).length() != 0) {
            this.setUser(tmpStr);
        }
        if ((tmpStr = Utils.getOption("password", options)).length() != 0) {
            this.setPassword(tmpStr);
        }
        String tableString = Utils.getOption('T', options);
        this.m_truncate = Utils.getFlag("truncate", options);
        String inputString = Utils.getOption('i', options);
        if (tableString.length() != 0) {
            this.m_tableName = tableString;
            this.m_tabName = false;
        }
        this.m_id = Utils.getFlag('P', options);
        if (inputString.length() != 0) {
            try {
                this.m_inputFile = inputString;
                ArffLoader al = new ArffLoader();
                File inputFile = new File(inputString);
                al.setSource(inputFile);
                this.setInstances(al.getDataSet());
                if (tableString.length() == 0) {
                    this.m_tableName = this.getInstances().relationName();
                }
            }
            catch (Exception ex) {
                this.printException(ex);
                ex.printStackTrace();
            }
        }
        if ((tmpStr = Utils.getOption("custom-props", options)).length() == 0) {
            this.setCustomPropsFile(null);
        } else {
            this.setCustomPropsFile(new File(tmpStr));
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] options) {
        StringBuffer text = new StringBuffer();
        text.append("\n\nDatabaseSaver options:\n");
        try {
            DatabaseSaver asv = new DatabaseSaver();
            try {
                Enumeration<Option> enumi = asv.listOptions();
                while (enumi.hasMoreElements()) {
                    Option option = enumi.nextElement();
                    text.append(option.synopsis() + '\n');
                    text.append(option.description() + '\n');
                }
                asv.setOptions(options);
                asv.setDestination(asv.getUrl());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            asv.writeBatch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(text);
        }
    }
}

