/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.CheckScheme;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClassifier
extends CheckScheme {
    protected Classifier m_Classifier = new ZeroR();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addAll(Collections.list(super.listOptions()));
        result.add(new Option("\tFull name of the classifier analysed.\n\teg: weka.classifiers.bayes.NaiveBayes\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            result.add(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_Classifier)).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = ZeroR.class.getName();
        }
        this.setClassifier((Classifier)this.forName("weka.classifiers", Classifier.class, tmpStr, Utils.partitionOptions(options)));
    }

    @Override
    public String[] getOptions() {
        String[] options;
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        if (this.getClassifier() != null) {
            result.add("-W");
            result.add(this.getClassifier().getClass().getName());
        }
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler && (options = ((OptionHandler)((Object)this.m_Classifier)).getOptions()).length > 0) {
            result.add("--");
            Collections.addAll(result, options);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void doTests() {
        if (this.getClassifier() == null) {
            this.println("\n=== No classifier set ===");
            return;
        }
        this.println("\n=== Check on Classifier: " + this.getClassifier().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean updateableClassifier = this.updateableClassifier()[0];
        boolean weightedInstancesHandler = this.weightedInstancesHandler()[0];
        boolean multiInstanceHandler = this.multiInstanceHandler()[0];
        this.println("--> Classifier tests");
        this.declaresSerialVersionUID();
        this.testToString();
        this.testsPerClassType(1, updateableClassifier, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(0, updateableClassifier, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(3, updateableClassifier, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(2, updateableClassifier, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(4, updateableClassifier, weightedInstancesHandler, multiInstanceHandler);
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected void testsPerClassType(int classType, boolean updateable, boolean weighted, boolean multiInstance) {
        boolean PNom = this.canPredict(true, false, false, false, false, multiInstance, classType)[0];
        boolean PNum = this.canPredict(false, true, false, false, false, multiInstance, classType)[0];
        boolean PStr = this.canPredict(false, false, true, false, false, multiInstance, classType)[0];
        boolean PDat = this.canPredict(false, false, false, true, false, multiInstance, classType)[0];
        boolean PRel = !multiInstance ? this.canPredict(false, false, false, false, true, multiInstance, classType)[0] : false;
        if (PNom || PNum || PStr || PDat || PRel) {
            boolean handleMissingClass;
            if (weighted) {
                this.instanceWeights(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            }
            this.canHandleOnlyClass(PNom, PNum, PStr, PDat, PRel, classType);
            if (classType == 1) {
                this.canHandleNClasses(PNom, PNum, PStr, PDat, PRel, multiInstance, 4);
            }
            if (!multiInstance) {
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 0);
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 1);
            }
            this.canHandleZeroTraining(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            boolean handleMissingPredictors = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 20)[0];
            if (handleMissingPredictors) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 100);
            }
            if (handleMissingClass = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 20)[0]) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 100);
            }
            this.correctBuildInitialisation(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            this.datasetIntegrity(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, handleMissingPredictors, handleMissingClass);
            this.doesntUseTestClassVal(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            if (updateable) {
                this.updatingEquality(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            }
        }
    }

    protected boolean[] testToString() {
        boolean[] result;
        block2: {
            result = new boolean[2];
            this.print("toString...");
            try {
                Classifier copy = (Classifier)this.m_Classifier.getClass().newInstance();
                copy.toString();
                result[0] = true;
                this.println("yes");
            }
            catch (Exception e) {
                result[0] = false;
                this.println("no");
                if (!this.m_Debug) break block2;
                this.println("\n=== Full report ===");
                e.printStackTrace();
                this.println("\n");
            }
        }
        return result;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] result = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = result[0] = !SerializationHelper.needsUID(this.m_Classifier.getClass());
        if (result[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    protected boolean[] canTakeOptions() {
        boolean[] result = new boolean[2];
        this.print("options...");
        if (this.m_Classifier instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration<Option> enu = ((OptionHandler)((Object)this.m_Classifier)).listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] updateableClassifier() {
        boolean[] result = new boolean[2];
        this.print("updateable classifier...");
        if (this.m_Classifier instanceof UpdateableClassifier) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] result = new boolean[2];
        this.print("weighted instances classifier...");
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] result = new boolean[2];
        this.print("multi-instance classifier...");
        if (this.m_Classifier instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] canPredict(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("basic predict");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("unary");
        accepts.add("binary");
        accepts.add("nominal");
        accepts.add("numeric");
        accepts.add("string");
        accepts.add("date");
        accepts.add("relational");
        accepts.add("multi-instance");
        accepts.add("not in classpath");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] canHandleOnlyClass(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, int classType) {
        this.print("only class in data");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, false, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("class");
        accepts.add("zeror");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(false, false, false, false, false, false, classType, missingLevel, predictorMissing, classMissing, numTrain, numTest, 2, accepts);
    }

    protected boolean[] canHandleNClasses(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int numClasses) {
        this.print("more than two class problems");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("number");
        accepts.add("class");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] canHandleClassAsNthAttribute(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex) {
        if (classIndex == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (classIndex + 1) + ". attribute");
        }
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, classIndex, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] canHandleZeroTraining(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("handle zero training instances");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("train");
        accepts.add("value");
        int numTrain = 0;
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] correctBuildInitialisation(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block20: {
            result = new boolean[2];
            this.print("correct initialisation during buildClassifier");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            Instances train1 = null;
            Instances test1 = null;
            Instances train2 = null;
            Instances test2 = null;
            Classifier classifier = null;
            Evaluation evaluation1A = null;
            Evaluation evaluation1B = null;
            Evaluation evaluation2 = null;
            boolean built = false;
            int stage = 0;
            try {
                train1 = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                train2 = this.makeTestDataset(84, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                test1 = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                test2 = this.makeTestDataset(48, numTest, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train1, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test1, Math.min(missingLevel, 50), predictorMissing, classMissing);
                    this.addMissing(train2, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test2, Math.min(missingLevel, 50), predictorMissing, classMissing);
                }
                classifier = AbstractClassifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation1A = new Evaluation(train1);
                evaluation1B = new Evaluation(train1);
                evaluation2 = new Evaluation(train2);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                stage = 0;
                classifier.buildClassifier(train1);
                built = true;
                if (!this.testWRTZeroR(classifier, evaluation1A, train1, test1)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                stage = 1;
                built = false;
                classifier.buildClassifier(train2);
                built = true;
                if (!this.testWRTZeroR(classifier, evaluation2, train2, test2)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                stage = 2;
                built = false;
                classifier.buildClassifier(train1);
                built = true;
                if (!this.testWRTZeroR(classifier, evaluation1B, train1, test1)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                stage = 3;
                if (!evaluation1A.equals(evaluation1B)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n" + evaluation1A.toSummaryString("\nFirst buildClassifier()", true) + "\n\n");
                        this.println(evaluation1B.toSummaryString("\nSecond buildClassifier()", true) + "\n\n");
                    }
                    throw new Exception("Results differ between buildClassifier calls");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                String msg = ex.getMessage().toLowerCase();
                if (msg.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    result[0] = stage < 1;
                    result[1] = stage < 1;
                } else {
                    this.println("no");
                    result[0] = false;
                }
                if (!this.m_Debug) break block20;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (stage) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + train1.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + test1.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + train2.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + test2.toString() + "\n\n");
            }
        }
        return result;
    }

    protected boolean[] canHandleMissing(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing, int missingLevel) {
        if (missingLevel == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (predictorMissing) {
            this.print(" predictor");
            if (classMissing) {
                this.print(" and");
            }
        }
        if (classMissing) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("missing");
        accepts.add("value");
        accepts.add("train");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] updatingEquality(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        boolean[] result = new boolean[2];
        Instances train = null;
        Instances test = null;
        Classifier[] classifiers = null;
        Evaluation evaluationB = null;
        Evaluation evaluationI = null;
        boolean built = false;
        try {
            train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
            test = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
            if (missingLevel > 0) {
                this.addMissing(train, missingLevel, predictorMissing, classMissing);
                this.addMissing(test, Math.min(missingLevel, 50), predictorMissing, classMissing);
            }
            classifiers = AbstractClassifier.makeCopies(this.getClassifier(), 2);
            evaluationB = new Evaluation(train);
            evaluationI = new Evaluation(train);
            classifiers[0].buildClassifier(train);
            this.testWRTZeroR(classifiers[0], evaluationB, train, test);
        }
        catch (Exception ex) {
            throw new Error("Error setting up for tests: " + ex.getMessage());
        }
        try {
            classifiers[1].buildClassifier(new Instances(train, 0));
            for (int i = 0; i < train.numInstances(); ++i) {
                ((UpdateableClassifier)((Object)classifiers[1])).updateClassifier(train.instance(i));
            }
            built = true;
            this.testWRTZeroR(classifiers[1], evaluationI, train, test);
            if (!evaluationB.equals(evaluationI)) {
                this.println("no");
                result[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    this.println("Here are the results:\n");
                    this.println(evaluationB.toSummaryString("\nbatch built results\n", true));
                    this.println(evaluationI.toSummaryString("\nincrementally built results\n", true));
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                }
            } else {
                this.println("yes");
                result[0] = true;
            }
        }
        catch (Exception ex) {
            result[0] = false;
            this.print("Problem during");
            if (built) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + ex.getMessage() + "\n");
        }
        return result;
    }

    protected boolean[] doesntUseTestClassVal(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block11: {
            this.print("classifier ignores test instance class vals");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = 2 * this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            result = new boolean[2];
            Instances train = null;
            Instances test = null;
            Classifier[] classifiers = null;
            boolean evalFail = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                test = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test, Math.min(missingLevel, 50), predictorMissing, classMissing);
                }
                classifiers = AbstractClassifier.makeCopies(this.getClassifier(), 2);
                classifiers[0].buildClassifier(train);
                classifiers[1].buildClassifier(train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                for (int i = 0; i < test.numInstances(); ++i) {
                    Instance testInst = test.instance(i);
                    Instance classMissingInst = (Instance)testInst.copy();
                    classMissingInst.setDataset(test);
                    classMissingInst.setClassMissing();
                    double[] dist0 = classifiers[0].distributionForInstance(testInst);
                    double[] dist1 = classifiers[1].distributionForInstance(classMissingInst);
                    for (int j = 0; j < dist0.length; ++j) {
                        if (Double.isNaN(dist0[j]) && Double.isNaN(dist1[j])) {
                            if (!this.getDebug()) continue;
                            System.out.println("Both predictions are NaN!");
                            continue;
                        }
                        if (dist0[j] == dist1[j]) continue;
                        throw new Exception("Prediction different for instance " + (i + 1));
                    }
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results differ between non-missing and missing test class values.");
                } else {
                    this.print("Problem during testing");
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < train.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return result;
    }

    protected boolean[] instanceWeights(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block13: {
            this.print("classifier uses instance weights");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = 2 * this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            result = new boolean[2];
            Instances train = null;
            Instances test = null;
            Classifier[] classifiers = null;
            Evaluation evaluationB = null;
            Evaluation evaluationI = null;
            boolean built = false;
            boolean evalFail = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                test = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test, Math.min(missingLevel, 50), predictorMissing, classMissing);
                }
                classifiers = AbstractClassifier.makeCopies(this.getClassifier(), 2);
                evaluationB = new Evaluation(train);
                evaluationI = new Evaluation(train);
                classifiers[0].buildClassifier(train);
                this.testWRTZeroR(classifiers[0], evaluationB, train, test);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                for (int i = 0; i < train.numInstances(); ++i) {
                    train.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < train.numInstances() / 2; ++i) {
                    int inst = Math.abs(random.nextInt()) % train.numInstances();
                    int weight = Math.abs(random.nextInt()) % 10 + 1;
                    train.instance(inst).setWeight(weight);
                }
                classifiers[1].buildClassifier(train);
                built = true;
                this.testWRTZeroR(classifiers[1], evaluationI, train, test);
                if (evaluationB.equals(evaluationI)) {
                    evalFail = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(evaluationB.toSummaryString("\nboth methods\n", true));
                } else {
                    this.print("Problem during");
                    if (built) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < train.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return result;
    }

    protected boolean[] datasetIntegrity(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing) {
        boolean[] result;
        block7: {
            this.print("classifier doesn't alter original datasets");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 20;
            result = new boolean[2];
            Instances train = null;
            Instances test = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean built = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                test = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test, Math.min(missingLevel, 50), predictorMissing, classMissing);
                }
                classifier = AbstractClassifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                Instances trainCopy = new Instances(train);
                Instances testCopy = new Instances(test);
                classifier.buildClassifier(trainCopy);
                this.compareDatasets(train, trainCopy);
                built = true;
                this.testWRTZeroR(classifier, evaluation, trainCopy, testCopy);
                this.compareDatasets(test, testCopy);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block7;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
            }
        }
        return result;
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numTest, int numClasses, ArrayList<String> accepts) {
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, -1, missingLevel, predictorMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numTest, int numClasses, ArrayList<String> accepts) {
        boolean[] result;
        block15: {
            result = new boolean[2];
            Instances train = null;
            Instances test = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean built = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, classIndex, multiInstance);
                test = this.makeTestDataset(24, numTest, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, classIndex, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                    this.addMissing(test, Math.min(missingLevel, 50), predictorMissing, classMissing);
                }
                classifier = AbstractClassifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(train);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                classifier.buildClassifier(train);
                built = true;
                if (!this.testWRTZeroR(classifier, evaluation, train, test)[0]) {
                    result[0] = true;
                    result[1] = true;
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                int i;
                boolean acceptable = false;
                String msg = ex.getMessage() == null ? "" : ex.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                if (msg.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    result[0] = true;
                    result[1] = true;
                } else {
                    for (i = 0; i < accepts.size(); ++i) {
                        if (msg.indexOf(accepts.get(i)) < 0) continue;
                        acceptable = true;
                    }
                    this.println("no" + (acceptable ? " (OK error message)" : ""));
                    result[1] = acceptable;
                }
                if (!this.m_Debug) break block15;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + ex.getMessage() + "\n");
                if (acceptable) break block15;
                if (accepts.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (i = 0; i < accepts.size(); ++i) {
                        if (i != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + accepts.get(i) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
            }
        }
        return result;
    }

    protected boolean[] testWRTZeroR(Classifier classifier, Evaluation evaluation, Instances train, Instances test) throws Exception {
        boolean[] result = new boolean[2];
        evaluation.evaluateModel(classifier, test, new Object[0]);
        try {
            ZeroR zeroR = new ZeroR();
            zeroR.buildClassifier(train);
            Evaluation zeroREval = new Evaluation(train);
            zeroREval.evaluateModel(zeroR, test, new Object[0]);
            result[0] = Utils.grOrEq(zeroREval.errorRate(), evaluation.errorRate());
        }
        catch (Exception ex) {
            throw new Error("Problem determining ZeroR performance: " + ex.getMessage());
        }
        return result;
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, boolean multiInstance) throws Exception {
        return this.makeTestDataset(seed, numInstances, numNominal, numNumeric, numString, numDate, numRelational, numClasses, classType, -1, multiInstance);
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, int classIndex, boolean multiInstance) throws Exception {
        TestInstances dataset = new TestInstances();
        dataset.setSeed(seed);
        dataset.setNumInstances(numInstances);
        dataset.setNumNominal(numNominal);
        dataset.setNumNumeric(numNumeric);
        dataset.setNumString(numString);
        dataset.setNumDate(numDate);
        dataset.setNumRelational(numRelational);
        dataset.setNumClasses(numClasses);
        dataset.setClassType(classType);
        dataset.setClassIndex(classIndex);
        dataset.setNumClasses(numClasses);
        dataset.setMultiInstance(multiInstance);
        dataset.setWords(this.getWords());
        dataset.setWordSeparators(this.getWordSeparators());
        return this.process(dataset.generate());
    }

    protected void printAttributeSummary(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        String str = "";
        if (numericPredictor) {
            str = str + " numeric";
        }
        if (nominalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " nominal";
        }
        if (stringPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " string";
        }
        if (datePredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " date";
        }
        if (relationalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " relational";
        }
        str = str + " predictors)";
        switch (classType) {
            case 0: {
                str = " (numeric class," + str;
                break;
            }
            case 1: {
                str = " (nominal class," + str;
                break;
            }
            case 2: {
                str = " (string class," + str;
                break;
            }
            case 3: {
                str = " (date class," + str;
                break;
            }
            case 4: {
                str = " (relational class," + str;
            }
        }
        this.print(str);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }

    public static void main(String[] args) {
        CheckClassifier.runCheck(new CheckClassifier(), args);
    }
}

