/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class SwapValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 6155834679414275855L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private SingleIndex m_FirstIndex = new SingleIndex("first");
    private SingleIndex m_SecondIndex = new SingleIndex("last");

    public String globalInfo() {
        return "Swaps two values of a nominal attribute.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        this.m_FirstIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        this.m_SecondIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        Instance newInstance;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(newInstance = (Instance)instance.copy()).isMissing(this.m_AttIndex.getIndex())) {
            if ((int)newInstance.value(this.m_AttIndex.getIndex()) == this.m_SecondIndex.getIndex()) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)this.m_FirstIndex.getIndex());
            } else if ((int)newInstance.value(this.m_AttIndex.getIndex()) == this.m_FirstIndex.getIndex()) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)this.m_SecondIndex.getIndex());
            }
        }
        this.push(newInstance);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the first value's index (default first).", "F", 1, "-F <value index>"));
        newVector.addElement(new Option("\tSets the second value's index (default last).", "S", 1, "-S <value index>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String firstValIndex = Utils.getOption('F', options);
        if (firstValIndex.length() != 0) {
            this.setFirstValueIndex(firstValIndex);
        } else {
            this.setFirstValueIndex("first");
        }
        String secondValIndex = Utils.getOption('S', options);
        if (secondValIndex.length() != 0) {
            this.setSecondValueIndex(secondValIndex);
        } else {
            this.setSecondValueIndex("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        options[current++] = "-C";
        options[current++] = "" + this.getAttributeIndex();
        options[current++] = "-F";
        options[current++] = "" + this.getFirstValueIndex();
        options[current++] = "-S";
        options[current++] = "" + this.getSecondValueIndex();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String firstValueIndexTipText() {
        return "The index of the first value.(\"first\" and \"last\" are valid values)";
    }

    public String getFirstValueIndex() {
        return this.m_FirstIndex.getSingleIndex();
    }

    public void setFirstValueIndex(String firstIndex) {
        this.m_FirstIndex.setSingleIndex(firstIndex);
    }

    public String secondValueIndexTipText() {
        return "The index of the second value.(\"first\" and \"last\" are valid values)";
    }

    public String getSecondValueIndex() {
        return this.m_SecondIndex.getSingleIndex();
    }

    public void setSecondValueIndex(String secondIndex) {
        this.m_SecondIndex.setSingleIndex(secondIndex);
    }

    private void setOutputFormat() {
        FastVector<Attribute> newAtts = new FastVector<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            FastVector<String> newVals = new FastVector<String>(att.numValues());
            for (int i = 0; i < att.numValues(); ++i) {
                if (i == this.m_FirstIndex.getIndex()) {
                    newVals.addElement(att.value(this.m_SecondIndex.getIndex()));
                    continue;
                }
                if (i == this.m_SecondIndex.getIndex()) {
                    newVals.addElement(att.value(this.m_FirstIndex.getIndex()));
                    continue;
                }
                newVals.addElement(att.value(i));
            }
            newAtts.addElement(new Attribute(att.name(), newVals));
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        SwapValues.runFilter(new SwapValues(), argv);
    }
}

