/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import weka.classifiers.misc.monotone.BitMatrix;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class BooleanBitMatrix
implements BitMatrix,
RevisionHandler {
    private boolean[][] m_bits;
    private int m_rows;
    private int m_columns;

    public BooleanBitMatrix(int rows, int columns) {
        this.m_bits = new boolean[rows][columns];
        this.m_rows = rows;
        this.m_columns = columns;
    }

    public BooleanBitMatrix(BooleanBitMatrix bm) {
        this(bm.m_rows, bm.m_columns);
        for (int i = 0; i < this.m_rows; ++i) {
            System.arraycopy(bm.m_bits[i], 0, this.m_bits[i], 0, this.m_columns);
        }
    }

    public boolean get(int row, int column) {
        return this.m_bits[row][column];
    }

    public boolean set(int row, int column, boolean bool) {
        this.m_bits[row][column] = bool;
        return bool;
    }

    public boolean set(int row, int column) {
        return !this.get(row, column) && this.set(row, column, true);
    }

    public boolean clear(int row, int column) {
        return this.get(row, column) && !this.set(row, column, false);
    }

    public int rows() {
        return this.m_rows;
    }

    public int columns() {
        return this.m_columns;
    }

    public int columnCount(int column) {
        int count = 0;
        for (int i = 0; i < this.m_rows; ++i) {
            count += this.m_bits[i][column] ? 1 : 0;
        }
        return count;
    }

    public int rowCount(int row) {
        int count = 0;
        for (int i = 0; i < this.m_columns; ++i) {
            count += this.m_bits[row][i] ? 1 : 0;
        }
        return count;
    }

    public BooleanBitMatrix transpose() {
        BooleanBitMatrix transposed = new BooleanBitMatrix(this.m_columns, this.m_rows);
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_columns; ++j) {
                transposed.set(j, i, this.get(i, j));
            }
        }
        return transposed;
    }

    public void transposeInPlace() throws IllegalArgumentException {
        if (this.m_rows != this.m_columns) {
            throw new IllegalArgumentException("The BooleanBitMatrix is not square");
        }
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = i + 1; j < this.m_columns; ++j) {
                this.swap(i, j, j, i);
            }
        }
    }

    private void swap(int r1, int c1, int r2, int c2) {
        boolean tmp = this.get(r1, c1);
        this.set(r1, c1, this.get(r2, c2));
        this.set(r2, c2, tmp);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_rows * (this.m_columns + 1));
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_columns; ++j) {
                sb.append(this.get(i, j) ? 1 : 0);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }
}

