/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.Serializable;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class HyperPipes
extends AbstractClassifier {
    static final long serialVersionUID = -7527596632268975274L;
    protected int m_ClassIndex;
    protected Instances m_Instances;
    protected HyperPipe[] m_HyperPipes;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class implementing a HyperPipe classifier. For each category a HyperPipe is constructed that contains all points of that category (essentially records the attribute bounds observed for each category). Test instances are classified according to the category that \"most contains the instance\".\nDoes not handle numeric class, or missing values in test cases. Extremely simple algorithm, but has the advantage of being extremely fast, and works quite well when you have \"smegloads\" of attributes.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int i;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_ClassIndex = instances.classIndex();
        this.m_Instances = new Instances(instances, 0);
        this.m_HyperPipes = new HyperPipe[instances.numClasses()];
        for (i = 0; i < this.m_HyperPipes.length; ++i) {
            this.m_HyperPipes[i] = new HyperPipe(new Instances(instances, 0));
        }
        for (i = 0; i < instances.numInstances(); ++i) {
            this.updateClassifier(instances.instance(i));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        this.m_HyperPipes[(int)instance.classValue()].addInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dist = new double[this.m_HyperPipes.length];
        for (int j = 0; j < this.m_HyperPipes.length; ++j) {
            dist[j] = this.m_HyperPipes[j].partialContains(instance);
        }
        double sum = Utils.sum(dist);
        if (sum <= 0.0) {
            for (int j = 0; j < dist.length; ++j) {
                dist[j] = 1.0 / (double)dist.length;
            }
            return dist;
        }
        Utils.normalize(dist, sum);
        return dist;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_HyperPipes == null) {
            return "HyperPipes classifier";
        }
        StringBuffer text = new StringBuffer("HyperPipes classifier\n");
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        HyperPipes.runClassifier(new HyperPipes(), argv);
    }

    class HyperPipe
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 3972254260367902025L;
        protected double[][] m_NumericBounds;
        protected boolean[][] m_NominalBounds;

        public HyperPipe(Instances instances) throws Exception {
            int i;
            this.m_NumericBounds = new double[instances.numAttributes()][];
            this.m_NominalBounds = new boolean[instances.numAttributes()][];
            block4: for (i = 0; i < instances.numAttributes(); ++i) {
                switch (instances.attribute(i).type()) {
                    case 0: {
                        this.m_NumericBounds[i] = new double[2];
                        this.m_NumericBounds[i][0] = Double.POSITIVE_INFINITY;
                        this.m_NumericBounds[i][1] = Double.NEGATIVE_INFINITY;
                        continue block4;
                    }
                    case 1: {
                        this.m_NominalBounds[i] = new boolean[instances.attribute(i).numValues()];
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeTypeException("Cannot process string attributes!");
                    }
                }
            }
            for (i = 0; i < instances.numInstances(); ++i) {
                this.addInstance(instances.instance(i));
            }
        }

        public void addInstance(Instance instance) throws Exception {
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (j == HyperPipes.this.m_ClassIndex || instance.isMissing(j)) continue;
                double current = instance.value(j);
                if (this.m_NumericBounds[j] != null) {
                    if (current < this.m_NumericBounds[j][0]) {
                        this.m_NumericBounds[j][0] = current;
                    }
                    if (!(current > this.m_NumericBounds[j][1])) continue;
                    this.m_NumericBounds[j][1] = current;
                    continue;
                }
                this.m_NominalBounds[j][(int)current] = true;
            }
        }

        public double partialContains(Instance instance) throws Exception {
            int count = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == HyperPipes.this.m_ClassIndex || instance.isMissing(i)) continue;
                double current = instance.value(i);
                if (this.m_NumericBounds[i] != null) {
                    if (!(current >= this.m_NumericBounds[i][0]) || !(current <= this.m_NumericBounds[i][1])) continue;
                    ++count;
                    continue;
                }
                if (!this.m_NominalBounds[i][(int)current]) continue;
                ++count;
            }
            return (double)count / (double)(instance.numAttributes() - 1);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }
}

