/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabuSearch
extends ASSearch
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8812132617585120414L;
    private int m_numAttribs;
    private int m_classIndex;
    private Random m_random;
    private int m_seed;
    private double m_diversificationProb;
    private int m_numIterations;
    private int m_totalEvals;
    protected Subset m_Sbest;
    private int m_numNeighborhood;
    private long m_processinTime;
    private int m_initialSize;
    private Subset m_initialSolution;
    private List<Subset> m_rankedAttribs;
    private List<BitSet> m_vectorTabu;
    private SubsetEvaluator ASEvaluator = null;

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        this.m_totalEvals = 0;
        this.m_processinTime = System.currentTimeMillis();
        this.m_numAttribs = data.numAttributes();
        this.m_classIndex = data.classIndex();
        this.ASEvaluator = (SubsetEvaluator)((Object)ASEval);
        this.m_random = new Random(this.m_seed);
        int numN = this.m_numNeighborhood;
        int n = numN = this.m_numNeighborhood <= 0 ? 3 * this.m_numAttribs / 4 : this.m_numNeighborhood;
        if (this.m_numAttribs <= 14) {
            this.m_numIterations = this.m_numAttribs;
        } else if (this.m_numAttribs > 14) {
            this.m_numIterations = this.m_numAttribs / 3;
        }
        this.m_rankedAttribs = this.RankEachAttribute();
        if (this.m_initialSize < 0) {
            this.m_initialSize = this.m_numAttribs;
        }
        this.m_initialSolution = this.GenerateInitialSolution(new Subset(new BitSet(this.m_numAttribs), 0.0), this.m_initialSize);
        this.m_vectorTabu = new ArrayList<BitSet>();
        BitSet tabu1 = new BitSet(this.m_numAttribs);
        BitSet tabu2 = new BitSet(this.m_numAttribs);
        tabu2.set(0, this.m_numAttribs - 1);
        if (this.m_classIndex >= 0) {
            tabu2.set(this.m_classIndex, false);
        }
        this.m_vectorTabu.add(tabu1);
        this.m_vectorTabu.add(tabu2);
        int iterationCounter = 0;
        int numGenerationNeighborForDiv = this.m_numAttribs / this.m_numIterations >= 2 ? this.m_numAttribs / this.m_numIterations : 3;
        int numTotalWImp = 0;
        int numTotalWImpForFinishing = this.m_numIterations / 2;
        BitSet S = this.m_initialSolution.subset;
        this.m_Sbest = this.m_initialSolution;
        ArrayList<Subset> RedSet = new ArrayList<Subset>();
        RedSet.add(this.m_Sbest.clone());
        while (iterationCounter < this.m_numIterations && numTotalWImp < numTotalWImpForFinishing) {
            ++iterationCounter;
            List<Subset> neighborhood = null;
            int counterGenerationNeighborWImp = 0;
            while (counterGenerationNeighborWImp < numGenerationNeighborForDiv && (neighborhood = this.generateNeighborhood(S, numN)) != null) {
                S = neighborhood.get((int)0).subset;
                double Smerit = this.ASEvaluator.evaluateSubset(S);
                ++this.m_totalEvals;
                RedSet.add(new Subset((BitSet)S.clone(), Smerit));
                this.m_vectorTabu.add((BitSet)S.clone());
                if (Smerit > this.m_Sbest.merit) {
                    this.m_Sbest = new Subset((BitSet)S.clone(), Smerit);
                    Subset aux = this.shake();
                    if (aux == null) continue;
                    this.m_Sbest = aux.clone();
                    continue;
                }
                ++counterGenerationNeighborWImp;
                ++numTotalWImp;
            }
            S = this.diversify(neighborhood);
        }
        Subset elite = this.eliteReducts(RedSet, RedSet.size());
        if (elite.merit >= this.m_Sbest.merit) {
            return this.attributeList(elite.subset);
        }
        this.m_processinTime = System.currentTimeMillis() - this.m_processinTime;
        return this.attributeList(this.m_Sbest.subset);
    }

    private List<Subset> generateNeighborhood(BitSet S, int numNeighborhood) throws Exception {
        int numAttribs;
        int counter = 0;
        ArrayList<Subset> neighborhood = new ArrayList<Subset>();
        int n = numAttribs = this.m_classIndex == -1 ? this.m_numAttribs : this.m_numAttribs - 1;
        if (numNeighborhood >= numAttribs) {
            for (int i = 0; i < this.m_numAttribs; ++i) {
                if (i == this.m_classIndex) continue;
                BitSet aux = (BitSet)S.clone();
                aux.flip(i);
                if (this.m_vectorTabu.contains(aux)) continue;
                neighborhood.add(new Subset((BitSet)aux.clone(), this.ASEvaluator.evaluateSubset(aux)));
                ++this.m_totalEvals;
            }
        } else {
            while (counter < numNeighborhood) {
                BitSet aux = (BitSet)S.clone();
                int randomNumber = this.m_random.nextInt(this.m_numAttribs);
                if (randomNumber == this.m_classIndex) continue;
                aux.flip(randomNumber);
                if (this.m_vectorTabu.contains(aux)) continue;
                neighborhood.add(new Subset((BitSet)aux.clone(), this.ASEvaluator.evaluateSubset(aux)));
                ++this.m_totalEvals;
                ++counter;
            }
        }
        if (neighborhood.isEmpty()) {
            return null;
        }
        return this.bubbleSubsetSort(neighborhood);
    }

    public BitSet diversify(List<Subset> neighborhood) {
        int i;
        if (neighborhood == null) {
            return this.m_Sbest.subset;
        }
        BitSet result = new BitSet(this.m_numAttribs);
        double[] counts = new double[this.m_numAttribs];
        int numNeighborhood = neighborhood.size();
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            int counter = 0;
            for (int j = 0; j < numNeighborhood; ++j) {
                if (!neighborhood.get((int)j).subset.get(i)) continue;
                ++counter;
            }
            counts[i] = (double)counter / (double)numNeighborhood;
        }
        for (i = 0; i < this.m_numAttribs; ++i) {
            double ocurrenceAndRank;
            double randomNumber = this.m_random.nextDouble();
            if (!(randomNumber > (ocurrenceAndRank = counts[i] * this.m_diversificationProb + this.doubleRank(i) * (1.0 - this.m_diversificationProb)))) continue;
            result.set(i);
        }
        return result;
    }

    private Subset shake() throws Exception {
        Subset bestCopy = this.m_Sbest.clone();
        boolean anyImprovement = false;
        for (int i = this.m_rankedAttribs.size() - 1; i >= 0; --i) {
            Subset ranking = this.m_rankedAttribs.get(i);
            int attributeIndex = ranking.subset.nextSetBit(0);
            BitSet aux = (BitSet)bestCopy.subset.clone();
            if (!aux.get(attributeIndex)) continue;
            aux.set(attributeIndex, false);
            if (this.m_vectorTabu.contains(aux)) continue;
            double tempMerit = this.ASEvaluator.evaluateSubset(aux);
            ++this.m_totalEvals;
            if (!(tempMerit >= bestCopy.merit)) continue;
            bestCopy = new Subset((BitSet)aux.clone(), tempMerit);
            anyImprovement = true;
        }
        if (anyImprovement) {
            return bestCopy;
        }
        return null;
    }

    public Subset eliteReducts(List<Subset> RedSet, int numSubset) throws Exception {
        if (numSubset <= 0) {
            return null;
        }
        List<Subset> orderedRedSet = this.bubbleSubsetSort(RedSet);
        int numAttribsOfBest = this.m_Sbest.cardinality();
        BitSet result = new BitSet(this.m_numAttribs);
        result.set(0, this.m_numAttribs - 1, true);
        for (int i = 0; i < numSubset; ++i) {
            BitSet aux = orderedRedSet.get((int)i).subset;
            result.and(aux);
        }
        int diff = numAttribsOfBest - result.cardinality();
        Subset resultSet = this.GenerateInitialSolution(new Subset(result, this.ASEvaluator.evaluateSubset(result)), result.cardinality() + diff - 1);
        ++this.m_totalEvals;
        if (resultSet == null) {
            return null;
        }
        return resultSet;
    }

    public Subset GenerateInitialSolution(Subset initial, int size) throws Exception {
        ArrayList<Subset> rankedAttribsCopy = new ArrayList<Subset>();
        for (int i = 0; i < this.m_rankedAttribs.size(); ++i) {
            rankedAttribsCopy.add(this.m_rankedAttribs.get(i));
        }
        Subset solution = initial.clone();
        while (solution.cardinality() < size) {
            Subset tempSubset = new Subset();
            double bestMerit = solution.merit;
            int bestIndex = -1;
            for (int i = 0; i < rankedAttribsCopy.size(); ++i) {
                Subset candidate = ((Subset)rankedAttribsCopy.get(i)).clone();
                if (solution.subset.get(candidate.subset.nextSetBit(0))) continue;
                tempSubset = this.joinSubsets(solution, (Subset)rankedAttribsCopy.get(i));
                if (!(tempSubset.merit > bestMerit)) continue;
                bestMerit = tempSubset.merit;
                bestIndex = i;
            }
            if (bestIndex == -1) break;
            solution = this.joinSubsets(solution, (Subset)rankedAttribsCopy.get(bestIndex));
            rankedAttribsCopy.remove(bestIndex);
        }
        return solution;
    }

    private double doubleRank(int idAttrib) {
        int rankSize = this.m_rankedAttribs.size();
        int rankAttribute = -1;
        if (idAttrib == this.m_classIndex) {
            return -1.0;
        }
        for (int i = 0; i < rankSize; ++i) {
            if (this.m_rankedAttribs.get((int)i).subset.nextSetBit(0) != idAttrib) continue;
            rankAttribute = i;
            break;
        }
        return (double)rankAttribute / (double)rankSize;
    }

    private List<Subset> RankEachAttribute() throws Exception {
        ArrayList<Subset> result = new ArrayList<Subset>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            BitSet an_Attribute = new BitSet(this.m_numAttribs);
            an_Attribute.set(i);
            double merit = this.ASEvaluator.evaluateSubset(an_Attribute);
            ++this.m_totalEvals;
            result.add(new Subset(an_Attribute, merit));
        }
        return this.bubbleSubsetSort(result);
    }

    public List<Subset> bubbleSubsetSort(List<Subset> subsetList) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < subsetList.size() - 1; ++i) {
            Subset subset1 = subsetList.get(i);
            double merit1 = subset1.merit;
            for (int j = i + 1; j < subsetList.size(); ++j) {
                Subset subset2 = subsetList.get(j);
                double merit2 = subset2.merit;
                if (!(merit2 > merit1)) continue;
                Subset temp = subset1;
                subsetList.set(i, subset2);
                subsetList.set(j, temp);
                subset1 = subset2;
                merit1 = subset1.merit;
            }
        }
        return subsetList;
    }

    public Subset joinSubsets(Subset subset1, Subset subset2) throws Exception {
        BitSet b1 = (BitSet)subset1.subset.clone();
        BitSet b2 = (BitSet)subset2.subset.clone();
        b1.or(b2);
        double newMerit = this.ASEvaluator.evaluateSubset(b1);
        ++this.m_totalEvals;
        return new Subset(b1, newMerit);
    }

    public int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    public String printSubset(Subset subset) {
        StringBuffer bufferString = new StringBuffer();
        if (subset == null) {
            return "";
        }
        BitSet bits = subset.subset;
        double merit = subset.merit;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bits.get(i)) continue;
            indexes.add(i + 1);
        }
        bufferString.append(Utils.doubleToString(merit, 8, 5) + "\t " + ((Object)indexes).toString() + "\n");
        return bufferString.toString();
    }

    public String globalInfo() {
        return "Tabu Search :\n\nPerforms a search  through the space of attribute subsets. Evading local maximums by accepting bad and diverse solutions and make further search in the best soluions. Stops when there's not more improvement in n iterations\n;For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Abdel-Rahman Hedar, Jue Wangy, and Masao Fukushima");
        result.setValue(TechnicalInformation.Field.MONTH, "July");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.TITLE, "Tabu Search for Attribute Reduction in Rough Set Theory");
        result.setValue(TechnicalInformation.Field.LANGUAGE, "English");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4976 $");
    }

    public TabuSearch() {
        this.resetOptions();
    }

    public String seedTipText() {
        return "Set the random seed.";
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String diversificationProbTipText() {
        return "Set the probability of diversification. This is the probability of change of search subspace in an abrupt way";
    }

    public void setDiversificationProb(double p) {
        this.m_diversificationProb = p;
    }

    public double getDiversificationProb() {
        return this.m_diversificationProb;
    }

    public String numNeighborhoodTipText() {
        return "Set the number of current solution's neighborhood to generate for looking for a better solution";
    }

    public void setNumNeighborhood(int n) {
        this.m_numNeighborhood = n;
    }

    public int getNumNeighborhood() {
        return this.m_numNeighborhood;
    }

    public String initialSizeTipText() {
        return "Set the number of attributes that are going to be in the initial Solution";
    }

    public void setInitialSize(int n) {
        this.m_initialSize = n;
    }

    public int getInitialSize() {
        return this.m_initialSize;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify the number of attributes \n\tin the initial Solution..", "Z", 1, "-Z <numInitialSolution>"));
        newVector.addElement(new Option("\tSpecify the diversification probabilities,\n\tif this value is near to 0 then the best attributes\n\t will have more probabilities of keeping in the new diverse solution", "P", 1, "-P <diversificationProb>"));
        newVector.addElement(new Option("\tSet the random number seed.\n\t(default = 1)", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tSet the number of neighbors to generate.", "N", 1, "-N <number of neighbors>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('Z', options);
        if (optionString.length() != 0) {
            this.setInitialSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('P', options)).length() != 0) {
            this.setDiversificationProb(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('S', options)).length() != 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumNeighborhood(Integer.parseInt(optionString));
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[8];
        int current = 0;
        options[current++] = "-Z";
        options[current++] = "" + this.getInitialSize();
        options[current++] = "-P";
        options[current++] = "" + this.getDiversificationProb();
        options[current++] = "-S";
        options[current++] = "" + this.getSeed();
        options[current++] = "-N";
        options[current++] = "" + this.getNumNeighborhood();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer FString = new StringBuffer();
        FString.append("\nTabu Search \n\tInitial Size: " + this.getInitialSize());
        if (this.getInitialSize() > 0) {
            FString.append("\n\tInitial Solution (Generated by SFS):");
            FString.append("\n\tmerit:\t\t subset");
            FString.append("\n\t" + this.printSubset(this.m_initialSolution));
        }
        FString.append("\tdiversificationProb: " + Utils.doubleToString(Math.abs(this.getDiversificationProb()), 8, 3) + "\n");
        FString.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        FString.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_Sbest.merit), 8, 3) + "\n");
        return FString.toString();
    }

    protected void resetOptions() {
        this.m_initialSize = -1;
        this.m_numNeighborhood = -1;
        this.m_seed = 1;
        this.m_diversificationProb = 1.0;
        this.m_totalEvals = 0;
        this.m_processinTime = 0L;
    }

    public class Subset
    implements Serializable {
        double merit;
        BitSet subset;

        public Subset(BitSet subset, double merit) {
            this.subset = (BitSet)subset.clone();
            this.merit = merit;
        }

        public Subset() {
            this.subset = null;
            this.merit = -1.0;
        }

        public boolean isEqual(Subset otherSubset) {
            return this.subset.equals(otherSubset.subset);
        }

        public Subset clone() {
            return new Subset((BitSet)this.subset.clone(), this.merit);
        }

        public int cardinality() {
            if (this.subset == null) {
                return 0;
            }
            return this.subset.cardinality();
        }

        public void flip(int index) throws Exception {
            this.subset.flip(index);
            this.merit = TabuSearch.this.ASEvaluator.evaluateSubset(this.subset);
            TabuSearch.this.m_totalEvals++;
        }

        public boolean contains(int indexAttribute) {
            return this.subset.get(indexAttribute);
        }
    }
}

