/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.HostListPanel;

public class DistributeExperimentPanel
extends JPanel {
    private static final long serialVersionUID = 5206721431754800278L;
    RemoteExperiment m_Exp = null;
    protected JCheckBox m_enableDistributedExperiment = new JCheckBox();
    protected JButton m_configureHostNames = new JButton("Hosts");
    protected HostListPanel m_hostList = new HostListPanel();
    protected JRadioButton m_splitByDataSet = new JRadioButton("By data set");
    protected JRadioButton m_splitByRun = new JRadioButton("By run");
    ActionListener m_radioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            DistributeExperimentPanel.this.updateRadioLinks();
        }
    };

    public DistributeExperimentPanel() {
        this.m_enableDistributedExperiment.setSelected(false);
        this.m_enableDistributedExperiment.setToolTipText("Allow this experiment to be distributed to remote hosts");
        this.m_enableDistributedExperiment.setEnabled(false);
        this.m_configureHostNames.setEnabled(false);
        this.m_configureHostNames.setToolTipText("Edit the list of remote hosts");
        this.m_enableDistributedExperiment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistributeExperimentPanel.this.m_configureHostNames.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByDataSet.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByRun.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
            }
        });
        this.m_configureHostNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DistributeExperimentPanel.this.popupHostPanel();
            }
        });
        this.m_splitByDataSet.setToolTipText("Distribute experiment by data set");
        this.m_splitByRun.setToolTipText("Distribute experiment by run number");
        this.m_splitByDataSet.setSelected(true);
        this.m_splitByDataSet.setEnabled(false);
        this.m_splitByRun.setEnabled(false);
        this.m_splitByDataSet.addActionListener(this.m_radioListener);
        this.m_splitByRun.addActionListener(this.m_radioListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_splitByDataSet);
        buttonGroup.add(this.m_splitByRun);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.m_splitByDataSet);
        jPanel.add(this.m_splitByRun);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Distribute experiment"));
        this.add((Component)this.m_enableDistributedExperiment, "West");
        this.add((Component)this.m_configureHostNames, "Center");
        this.add((Component)jPanel, "South");
    }

    public DistributeExperimentPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public void setExperiment(Experiment experiment) {
        this.m_enableDistributedExperiment.setEnabled(true);
        this.m_Exp = null;
        if (experiment instanceof RemoteExperiment) {
            this.m_Exp = (RemoteExperiment)experiment;
            this.m_enableDistributedExperiment.setSelected(true);
            this.m_configureHostNames.setEnabled(true);
            this.m_hostList.setExperiment(this.m_Exp);
            this.m_splitByDataSet.setEnabled(true);
            this.m_splitByRun.setEnabled(true);
            this.m_splitByDataSet.setSelected(this.m_Exp.getSplitByDataSet());
            this.m_splitByRun.setSelected(!this.m_Exp.getSplitByDataSet());
        }
    }

    private void popupHostPanel() {
        try {
            final JFrame jFrame = new JFrame("Edit host names");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)this.m_hostList, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public boolean distributedExperimentSelected() {
        return this.m_enableDistributedExperiment.isSelected();
    }

    public void addCheckBoxActionListener(ActionListener actionListener) {
        this.m_enableDistributedExperiment.addActionListener(actionListener);
    }

    private void updateRadioLinks() {
        if (this.m_Exp != null) {
            this.m_Exp.setSplitByDataSet(this.m_splitByDataSet.isSelected());
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("DistributeExperiment");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)new DistributeExperimentPanel(new Experiment()), "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

