/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.Utils;
import weka.gui.visualize.VisualizeUtils;

public class MemoryUsagePanel
extends JPanel {
    private static final long serialVersionUID = -4812319791687471721L;
    protected static String PROPERTY_FILE = "weka/gui/MemoryUsage.props";
    protected static Properties PROPERTIES;
    protected Vector<Double> m_History;
    protected Memory m_Memory = new Memory();
    protected MemoryMonitor m_Monitor;
    protected JButton m_ButtonGC;
    protected Vector<Double> m_Percentages;
    protected Hashtable<Double, Color> m_Colors;
    protected Color m_DefaultColor;
    protected Color m_BackgroundColor;
    protected Point m_FrameLocation;

    public MemoryUsagePanel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.m_History = new Vector();
        this.m_Percentages = new Vector();
        this.m_Colors = new Hashtable();
        this.m_BackgroundColor = this.parseColor("BackgroundColor", Color.WHITE);
        this.m_DefaultColor = this.parseColor("DefaultColor", Color.GREEN);
        String[] stringArray = PROPERTIES.getProperty("Percentages", "70,80,90").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (PROPERTIES.getProperty(stringArray[i]) != null) {
                double d;
                try {
                    d = Double.parseDouble(stringArray[i]);
                }
                catch (Exception exception) {
                    System.err.println("MemoryUsagePanel: cannot parse percentage '" + stringArray[i] + "' - ignored!");
                    continue;
                }
                Color color = this.parseColor(stringArray[i], null);
                if (color == null) continue;
                this.m_Percentages.add(d);
                this.m_Colors.put(d, color);
                continue;
            }
            System.err.println("MemoryUsagePanel: cannot find color for percentage '" + stringArray[i] + "' - ignored!");
        }
        Collections.sort(this.m_Percentages);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        this.m_ButtonGC = new JButton("GC");
        this.m_ButtonGC.setToolTipText("Runs the garbage collector.");
        this.m_ButtonGC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.gc();
            }
        });
        jPanel.add((Component)this.m_ButtonGC, "North");
        try {
            n5 = Integer.parseInt(PROPERTIES.getProperty("Height", "" + (int)this.m_ButtonGC.getPreferredSize().getHeight()));
            n4 = Integer.parseInt(PROPERTIES.getProperty("Width", "400"));
        }
        catch (Exception exception) {
            System.err.println("MemoryUsagePanel: Problem parsing the dimensions - " + exception);
            n5 = (int)this.m_ButtonGC.getPreferredSize().getHeight();
            n4 = 400;
        }
        this.setPreferredSize(new Dimension(n4, n5));
        try {
            n3 = Integer.parseInt(PROPERTIES.getProperty("Top", "0"));
            n2 = Integer.parseInt(PROPERTIES.getProperty("Left", "0"));
        }
        catch (Exception exception) {
            System.err.println("MemoryUsagePanel: Problem parsing the position - " + exception);
            n3 = 0;
            n2 = 0;
        }
        this.m_FrameLocation = new Point(n2, n3);
        try {
            n = Integer.parseInt(PROPERTIES.getProperty("Interval", "1000"));
        }
        catch (Exception exception) {
            System.err.println("MemoryUsagePanel: Problem parsing the refresh interval - " + exception);
            n = 1000;
        }
        this.m_Monitor = new MemoryMonitor();
        this.m_Monitor.setInterval(n);
        this.m_Monitor.setPriority(10);
        this.m_Monitor.start();
    }

    protected Color parseColor(String string, Color color) {
        Color color2 = color;
        try {
            String string2 = PROPERTIES.getProperty(string);
            Color color3 = VisualizeUtils.processColour(string2, color2);
            if (color3 == null) {
                throw new Exception(string2);
            }
            color2 = color3;
        }
        catch (Exception exception) {
            System.err.println("MemoryUsagePanel: cannot parse color '" + exception.getMessage() + "' - ignored!");
        }
        return color2;
    }

    public boolean isMonitoring() {
        return this.m_Monitor.isMonitoring();
    }

    public void stopMonitoring() {
        this.m_Monitor.stopMonitoring();
    }

    public Point getFrameLocation() {
        return this.m_FrameLocation;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.m_BackgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        double d = (double)this.getHeight() / 100.0;
        for (int i = 0; i < this.m_History.size(); ++i) {
            double d2 = this.m_History.get(i);
            Color color = this.m_DefaultColor;
            for (int j = this.m_Percentages.size() - 1; j >= 0; --j) {
                if (!(d2 >= this.m_Percentages.get(j))) continue;
                color = this.m_Colors.get(this.m_Percentages.get(j));
                break;
            }
            graphics.setColor(color);
            int n = (int)Math.round(d2 * d);
            graphics.drawLine(i, this.getHeight() - 1, i, this.getHeight() - n);
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> enumeration = PROPERTIES.propertyNames();
            if (!enumeration.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the memory usage panel");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the memory usage\npanel. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "MemoryUsagePanel", 0);
        }
    }

    protected class MemoryMonitor
    extends Thread {
        protected int m_Interval;
        protected boolean m_Monitoring;

        public MemoryMonitor() {
            this.setInterval(1000);
        }

        public int getInterval() {
            return this.m_Interval;
        }

        public void setInterval(int n) {
            this.m_Interval = n;
        }

        public boolean isMonitoring() {
            return this.m_Monitoring;
        }

        public void stopMonitoring() {
            this.m_Monitoring = false;
        }

        public void run() {
            this.m_Monitoring = true;
            while (this.m_Monitoring) {
                try {
                    Thread.sleep(this.m_Interval);
                    if (!this.m_Monitoring) continue;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            MemoryMonitor.this.update();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        protected void update() {
            double d = (double)MemoryUsagePanel.this.m_Memory.getCurrent() / (double)MemoryUsagePanel.this.m_Memory.getMax();
            d = Math.round(d * 1000.0) / 10L;
            MemoryUsagePanel.this.setToolTipText("" + d + "% used");
            MemoryUsagePanel.this.m_History.insertElementAt(d, 0);
            Dimension dimension = MemoryUsagePanel.this.getSize();
            while ((double)MemoryUsagePanel.this.m_History.size() > dimension.getWidth()) {
                MemoryUsagePanel.this.m_History.remove(MemoryUsagePanel.this.m_History.size() - 1);
            }
            MemoryUsagePanel.this.repaint();
        }
    }
}

