/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.util.HashMap;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.stemmers.Stemmer;
import weka.core.stemmers.Stemming;

public class LovinsStemmer
implements Stemmer,
TechnicalInformationHandler {
    static final long serialVersionUID = -6113024782588197L;
    private static boolean m_CompMode = false;
    private static HashMap m_l11 = null;
    private static HashMap m_l10 = null;
    private static HashMap m_l9 = null;
    private static HashMap m_l8 = null;
    private static HashMap m_l7 = null;
    private static HashMap m_l6 = null;
    private static HashMap m_l5 = null;
    private static HashMap m_l4 = null;
    private static HashMap m_l3 = null;
    private static HashMap m_l2 = null;
    private static HashMap m_l1 = null;

    public String globalInfo() {
        return "A stemmer based on the Lovins stemmer, described here:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Julie Beth Lovins");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1968");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Development of a stemming algorithm");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Mechanical Translation and Computational Linguistics");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "11");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "22-31");
        return technicalInformation;
    }

    private String removeEnding(String string) {
        int n = string.length();
        block44: for (int i = 11; i > 0; --i) {
            if (n - i <= 1) continue;
            String string2 = string.substring(n - i);
            String string3 = null;
            switch (i) {
                case 11: {
                    string3 = (String)m_l11.get(string2);
                    break;
                }
                case 10: {
                    string3 = (String)m_l10.get(string2);
                    break;
                }
                case 9: {
                    string3 = (String)m_l9.get(string2);
                    break;
                }
                case 8: {
                    string3 = (String)m_l8.get(string2);
                    break;
                }
                case 7: {
                    string3 = (String)m_l7.get(string2);
                    break;
                }
                case 6: {
                    string3 = (String)m_l6.get(string2);
                    break;
                }
                case 5: {
                    string3 = (String)m_l5.get(string2);
                    break;
                }
                case 4: {
                    string3 = (String)m_l4.get(string2);
                    break;
                }
                case 3: {
                    string3 = (String)m_l3.get(string2);
                    break;
                }
                case 2: {
                    string3 = (String)m_l2.get(string2);
                    break;
                }
                case 1: {
                    string3 = (String)m_l1.get(string2);
                    break;
                }
            }
            if (string3 == null) continue;
            switch (string3.charAt(0)) {
                case 'A': {
                    return string.substring(0, n - i);
                }
                case 'B': {
                    if (n - i <= 2) continue block44;
                    return string.substring(0, n - i);
                }
                case 'C': {
                    if (n - i <= 3) continue block44;
                    return string.substring(0, n - i);
                }
                case 'D': {
                    if (n - i <= 4) continue block44;
                    return string.substring(0, n - i);
                }
                case 'E': {
                    if (string.charAt(n - i - 1) == 'e') continue block44;
                    return string.substring(0, n - i);
                }
                case 'F': {
                    if (n - i <= 2 || string.charAt(n - i - 1) == 'e') continue block44;
                    return string.substring(0, n - i);
                }
                case 'G': {
                    if (n - i <= 2 || string.charAt(n - i - 1) != 'f') continue block44;
                    return string.substring(0, n - i);
                }
                case 'H': {
                    if (string.charAt(n - i - 1) != 't' && (string.charAt(n - i - 1) != 'l' || string.charAt(n - i - 2) != 'l')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'I': {
                    if (string.charAt(n - i - 1) == 'o' || string.charAt(n - i - 1) == 'e') continue block44;
                    return string.substring(0, n - i);
                }
                case 'J': {
                    if (string.charAt(n - i - 1) == 'a' || string.charAt(n - i - 1) == 'e') continue block44;
                    return string.substring(0, n - i);
                }
                case 'K': {
                    if (n - i <= 2 || string.charAt(n - i - 1) != 'l' && string.charAt(n - i - 1) != 'i' && (string.charAt(n - i - 1) != 'e' || string.charAt(n - i - 3) != 'u')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'L': {
                    if (string.charAt(n - i - 1) == 'u' || string.charAt(n - i - 1) == 'x' || string.charAt(n - i - 1) == 's' && string.charAt(n - i - 2) != 'o') continue block44;
                    return string.substring(0, n - i);
                }
                case 'M': {
                    if (string.charAt(n - i - 1) == 'a' || string.charAt(n - i - 1) == 'c' || string.charAt(n - i - 1) == 'e' || string.charAt(n - i - 1) == 'm') continue block44;
                    return string.substring(0, n - i);
                }
                case 'N': {
                    if (n - i <= 3 && (n - i != 3 || string.charAt(n - i - 3) == 's')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'O': {
                    if (string.charAt(n - i - 1) != 'l' && string.charAt(n - i - 1) != 'i') continue block44;
                    return string.substring(0, n - i);
                }
                case 'P': {
                    if (string.charAt(n - i - 1) == 'c') continue block44;
                    return string.substring(0, n - i);
                }
                case 'Q': {
                    if (n - i <= 2 || string.charAt(n - i - 1) == 'l' || string.charAt(n - i - 1) == 'n') continue block44;
                    return string.substring(0, n - i);
                }
                case 'R': {
                    if (string.charAt(n - i - 1) != 'n' && string.charAt(n - i - 1) != 'r') continue block44;
                    return string.substring(0, n - i);
                }
                case 'S': {
                    if ((string.charAt(n - i - 1) != 'r' || string.charAt(n - i - 2) != 'd') && (string.charAt(n - i - 1) != 't' || string.charAt(n - i - 2) == 't')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'T': {
                    if (string.charAt(n - i - 1) != 's' && (string.charAt(n - i - 1) != 't' || string.charAt(n - i - 2) == 'o')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'U': {
                    if (string.charAt(n - i - 1) != 'l' && string.charAt(n - i - 1) != 'm' && string.charAt(n - i - 1) != 'n' && string.charAt(n - i - 1) != 'r') continue block44;
                    return string.substring(0, n - i);
                }
                case 'V': {
                    if (string.charAt(n - i - 1) != 'c') continue block44;
                    return string.substring(0, n - i);
                }
                case 'W': {
                    if (string.charAt(n - i - 1) == 's' || string.charAt(n - i - 1) == 'u') continue block44;
                    return string.substring(0, n - i);
                }
                case 'X': {
                    if (string.charAt(n - i - 1) != 'l' && string.charAt(n - i - 1) != 'i' && (n - i <= 2 || string.charAt(n - i - 1) != 'e' || string.charAt(n - i - 3) != 'u')) continue block44;
                    return string.substring(0, n - i);
                }
                case 'Y': {
                    if (string.charAt(n - i - 1) != 'n' || string.charAt(n - i - 2) != 'i') continue block44;
                    return string.substring(0, n - i);
                }
                case 'Z': {
                    if (string.charAt(n - i - 1) == 'f') continue block44;
                    return string.substring(0, n - i);
                }
                case 'a': {
                    if (!(string.charAt(n - i - 1) == 'd' || string.charAt(n - i - 1) == 'f' || string.charAt(n - i - 1) == 'h' && string.charAt(n - i - 2) == 'p' || string.charAt(n - i - 1) == 'h' && string.charAt(n - i - 2) == 't' || string.charAt(n - i - 1) == 'l' || string.charAt(n - i - 1) == 'r' && string.charAt(n - i - 2) == 'e' || string.charAt(n - i - 1) == 'r' && string.charAt(n - i - 2) == 'o' || string.charAt(n - i - 1) == 's' && string.charAt(n - i - 2) == 'e') && string.charAt(n - i - 1) != 't') continue block44;
                    return string.substring(0, n - i);
                }
                case 'b': {
                    if (!(m_CompMode ? n - i == 3 && (string.charAt(n - i - 1) != 't' || string.charAt(n - i - 2) != 'e' || string.charAt(n - i - 3) != 'm') || n - i > 3 && (string.charAt(n - i - 1) != 't' || string.charAt(n - i - 2) != 's' || string.charAt(n - i - 3) != 'y' || string.charAt(n - i - 4) != 'r') : !(n - i <= 2 || string.charAt(n - i - 1) == 't' && string.charAt(n - i - 2) == 'e' && string.charAt(n - i - 3) == 'm' || n - i >= 4 && string.charAt(n - i - 1) == 't' && string.charAt(n - i - 2) == 's' && string.charAt(n - i - 3) == 'y' && string.charAt(n - i - 4) == 'r'))) continue block44;
                    return string.substring(0, n - i);
                }
                case 'c': {
                    if (string.charAt(n - i - 1) != 'l') continue block44;
                    return string.substring(0, n - i);
                }
                default: {
                    throw new IllegalArgumentException("Fatal error.");
                }
            }
        }
        return string;
    }

    private String recodeEnding(String string) {
        int n = string.length() - 1;
        if (string.endsWith("bb") || string.endsWith("dd") || string.endsWith("gg") || string.endsWith("ll") || string.endsWith("mm") || string.endsWith("nn") || string.endsWith("pp") || string.endsWith("rr") || string.endsWith("ss") || string.endsWith("tt")) {
            string = string.substring(0, n);
            --n;
        }
        if (string.endsWith("iev")) {
            string = string.substring(0, n - 2).concat("ief");
        }
        if (string.endsWith("uct")) {
            string = string.substring(0, n - 2).concat("uc");
            --n;
        }
        if (string.endsWith("umpt")) {
            string = string.substring(0, n - 3).concat("um");
            n -= 2;
        }
        if (string.endsWith("rpt")) {
            string = string.substring(0, n - 2).concat("rb");
            --n;
        }
        if (string.endsWith("urs")) {
            string = string.substring(0, n - 2).concat("ur");
            --n;
        }
        if (string.endsWith("istr")) {
            string = string.substring(0, n - 3).concat("ister");
            ++n;
        }
        if (string.endsWith("metr")) {
            string = string.substring(0, n - 3).concat("meter");
            ++n;
        }
        if (string.endsWith("olv")) {
            string = string.substring(0, n - 2).concat("olut");
            ++n;
        }
        if (string.endsWith("ul") && (n - 2 < 0 || string.charAt(n - 2) != 'a' && string.charAt(n - 2) != 'i' && string.charAt(n - 2) != 'o')) {
            string = string.substring(0, n - 1).concat("l");
            --n;
        }
        if (string.endsWith("bex")) {
            string = string.substring(0, n - 2).concat("bic");
        }
        if (string.endsWith("dex")) {
            string = string.substring(0, n - 2).concat("dic");
        }
        if (string.endsWith("pex")) {
            string = string.substring(0, n - 2).concat("pic");
        }
        if (string.endsWith("tex")) {
            string = string.substring(0, n - 2).concat("tic");
        }
        if (string.endsWith("ax")) {
            string = string.substring(0, n - 1).concat("ac");
        }
        if (string.endsWith("ex")) {
            string = string.substring(0, n - 1).concat("ec");
        }
        if (string.endsWith("ix")) {
            string = string.substring(0, n - 1).concat("ic");
        }
        if (string.endsWith("lux")) {
            string = string.substring(0, n - 2).concat("luc");
        }
        if (string.endsWith("uad")) {
            string = string.substring(0, n - 2).concat("uas");
        }
        if (string.endsWith("vad")) {
            string = string.substring(0, n - 2).concat("vas");
        }
        if (string.endsWith("cid")) {
            string = string.substring(0, n - 2).concat("cis");
        }
        if (string.endsWith("lid")) {
            string = string.substring(0, n - 2).concat("lis");
        }
        if (string.endsWith("erid")) {
            string = string.substring(0, n - 3).concat("eris");
        }
        if (string.endsWith("pand")) {
            string = string.substring(0, n - 3).concat("pans");
        }
        if (string.endsWith("end") && (n - 3 < 0 || string.charAt(n - 3) != 's')) {
            string = string.substring(0, n - 2).concat("ens");
        }
        if (string.endsWith("ond")) {
            string = string.substring(0, n - 2).concat("ons");
        }
        if (string.endsWith("lud")) {
            string = string.substring(0, n - 2).concat("lus");
        }
        if (string.endsWith("rud")) {
            string = string.substring(0, n - 2).concat("rus");
        }
        if (string.endsWith("her") && (n - 3 < 0 || string.charAt(n - 3) != 'p' && string.charAt(n - 3) != 't')) {
            string = string.substring(0, n - 2).concat("hes");
        }
        if (string.endsWith("mit")) {
            string = string.substring(0, n - 2).concat("mis");
        }
        if (string.endsWith("end") && (n - 3 < 0 || string.charAt(n - 3) != 'm')) {
            string = string.substring(0, n - 2).concat("ens");
        }
        if (string.endsWith("ert")) {
            string = string.substring(0, n - 2).concat("ers");
        }
        if (string.endsWith("et") && (n - 2 < 0 || string.charAt(n - 2) != 'n')) {
            string = string.substring(0, n - 1).concat("es");
        }
        if (string.endsWith("yt")) {
            string = string.substring(0, n - 1).concat("ys");
        }
        if (string.endsWith("yz")) {
            string = string.substring(0, n - 1).concat("ys");
        }
        return string;
    }

    public String stem(String string) {
        if (string.length() > 2) {
            return this.recodeEnding(this.removeEnding(string.toLowerCase()));
        }
        return string.toLowerCase();
    }

    public String stemString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (n != -1) continue;
                n = i;
                continue;
            }
            if (c == '\'') {
                if (n != -1) continue;
                stringBuffer.append(c);
                continue;
            }
            if (n != -1) {
                stringBuffer.append(this.stem(string.substring(n, i)));
                n = -1;
            }
            stringBuffer.append(c);
        }
        if (n != -1) {
            stringBuffer.append(this.stem(string.substring(n, string.length())));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }

    public static void main(String[] stringArray) {
        try {
            Stemming.useStemmer(new LovinsStemmer(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        m_l11 = new HashMap();
        m_l11.put("alistically", "B");
        m_l11.put("arizability", "A");
        m_l11.put("izationally", "B");
        m_l10 = new HashMap();
        m_l10.put("antialness", "A");
        m_l10.put("arisations", "A");
        m_l10.put("arizations", "A");
        m_l10.put("entialness", "A");
        m_l9 = new HashMap();
        m_l9.put("allically", "C");
        m_l9.put("antaneous", "A");
        m_l9.put("antiality", "A");
        m_l9.put("arisation", "A");
        m_l9.put("arization", "A");
        m_l9.put("ationally", "B");
        m_l9.put("ativeness", "A");
        m_l9.put("eableness", "E");
        m_l9.put("entations", "A");
        m_l9.put("entiality", "A");
        m_l9.put("entialize", "A");
        m_l9.put("entiation", "A");
        m_l9.put("ionalness", "A");
        m_l9.put("istically", "A");
        m_l9.put("itousness", "A");
        m_l9.put("izability", "A");
        m_l9.put("izational", "A");
        m_l8 = new HashMap();
        m_l8.put("ableness", "A");
        m_l8.put("arizable", "A");
        m_l8.put("entation", "A");
        m_l8.put("entially", "A");
        m_l8.put("eousness", "A");
        m_l8.put("ibleness", "A");
        m_l8.put("icalness", "A");
        m_l8.put("ionalism", "A");
        m_l8.put("ionality", "A");
        m_l8.put("ionalize", "A");
        m_l8.put("iousness", "A");
        m_l8.put("izations", "A");
        m_l8.put("lessness", "A");
        m_l7 = new HashMap();
        m_l7.put("ability", "A");
        m_l7.put("aically", "A");
        m_l7.put("alistic", "B");
        m_l7.put("alities", "A");
        m_l7.put("ariness", "E");
        m_l7.put("aristic", "A");
        m_l7.put("arizing", "A");
        m_l7.put("ateness", "A");
        m_l7.put("atingly", "A");
        m_l7.put("ational", "B");
        m_l7.put("atively", "A");
        m_l7.put("ativism", "A");
        m_l7.put("elihood", "E");
        m_l7.put("encible", "A");
        m_l7.put("entally", "A");
        m_l7.put("entials", "A");
        m_l7.put("entiate", "A");
        m_l7.put("entness", "A");
        m_l7.put("fulness", "A");
        m_l7.put("ibility", "A");
        m_l7.put("icalism", "A");
        m_l7.put("icalist", "A");
        m_l7.put("icality", "A");
        m_l7.put("icalize", "A");
        m_l7.put("ication", "G");
        m_l7.put("icianry", "A");
        m_l7.put("ination", "A");
        m_l7.put("ingness", "A");
        m_l7.put("ionally", "A");
        m_l7.put("isation", "A");
        m_l7.put("ishness", "A");
        m_l7.put("istical", "A");
        m_l7.put("iteness", "A");
        m_l7.put("iveness", "A");
        m_l7.put("ivistic", "A");
        m_l7.put("ivities", "A");
        m_l7.put("ization", "F");
        m_l7.put("izement", "A");
        m_l7.put("oidally", "A");
        m_l7.put("ousness", "A");
        m_l6 = new HashMap();
        m_l6.put("aceous", "A");
        m_l6.put("acious", "B");
        m_l6.put("action", "G");
        m_l6.put("alness", "A");
        m_l6.put("ancial", "A");
        m_l6.put("ancies", "A");
        m_l6.put("ancing", "B");
        m_l6.put("ariser", "A");
        m_l6.put("arized", "A");
        m_l6.put("arizer", "A");
        m_l6.put("atable", "A");
        m_l6.put("ations", "B");
        m_l6.put("atives", "A");
        m_l6.put("eature", "Z");
        m_l6.put("efully", "A");
        m_l6.put("encies", "A");
        m_l6.put("encing", "A");
        m_l6.put("ential", "A");
        m_l6.put("enting", "C");
        m_l6.put("entist", "A");
        m_l6.put("eously", "A");
        m_l6.put("ialist", "A");
        m_l6.put("iality", "A");
        m_l6.put("ialize", "A");
        m_l6.put("ically", "A");
        m_l6.put("icance", "A");
        m_l6.put("icians", "A");
        m_l6.put("icists", "A");
        m_l6.put("ifully", "A");
        m_l6.put("ionals", "A");
        m_l6.put("ionate", "D");
        m_l6.put("ioning", "A");
        m_l6.put("ionist", "A");
        m_l6.put("iously", "A");
        m_l6.put("istics", "A");
        m_l6.put("izable", "E");
        m_l6.put("lessly", "A");
        m_l6.put("nesses", "A");
        m_l6.put("oidism", "A");
        m_l5 = new HashMap();
        m_l5.put("acies", "A");
        m_l5.put("acity", "A");
        m_l5.put("aging", "B");
        m_l5.put("aical", "A");
        if (!m_CompMode) {
            m_l5.put("alist", "A");
        }
        m_l5.put("alism", "B");
        m_l5.put("ality", "A");
        m_l5.put("alize", "A");
        m_l5.put("allic", "b");
        m_l5.put("anced", "B");
        m_l5.put("ances", "B");
        m_l5.put("antic", "C");
        m_l5.put("arial", "A");
        m_l5.put("aries", "A");
        m_l5.put("arily", "A");
        m_l5.put("arity", "B");
        m_l5.put("arize", "A");
        m_l5.put("aroid", "A");
        m_l5.put("ately", "A");
        m_l5.put("ating", "I");
        m_l5.put("ation", "B");
        m_l5.put("ative", "A");
        m_l5.put("ators", "A");
        m_l5.put("atory", "A");
        m_l5.put("ature", "E");
        m_l5.put("early", "Y");
        m_l5.put("ehood", "A");
        m_l5.put("eless", "A");
        if (!m_CompMode) {
            m_l5.put("elily", "A");
        } else {
            m_l5.put("elity", "A");
        }
        m_l5.put("ement", "A");
        m_l5.put("enced", "A");
        m_l5.put("ences", "A");
        m_l5.put("eness", "E");
        m_l5.put("ening", "E");
        m_l5.put("ental", "A");
        m_l5.put("ented", "C");
        m_l5.put("ently", "A");
        m_l5.put("fully", "A");
        m_l5.put("ially", "A");
        m_l5.put("icant", "A");
        m_l5.put("ician", "A");
        m_l5.put("icide", "A");
        m_l5.put("icism", "A");
        m_l5.put("icist", "A");
        m_l5.put("icity", "A");
        m_l5.put("idine", "I");
        m_l5.put("iedly", "A");
        m_l5.put("ihood", "A");
        m_l5.put("inate", "A");
        m_l5.put("iness", "A");
        m_l5.put("ingly", "B");
        m_l5.put("inism", "J");
        m_l5.put("inity", "c");
        m_l5.put("ional", "A");
        m_l5.put("ioned", "A");
        m_l5.put("ished", "A");
        m_l5.put("istic", "A");
        m_l5.put("ities", "A");
        m_l5.put("itous", "A");
        m_l5.put("ively", "A");
        m_l5.put("ivity", "A");
        m_l5.put("izers", "F");
        m_l5.put("izing", "F");
        m_l5.put("oidal", "A");
        m_l5.put("oides", "A");
        m_l5.put("otide", "A");
        m_l5.put("ously", "A");
        m_l4 = new HashMap();
        m_l4.put("able", "A");
        m_l4.put("ably", "A");
        m_l4.put("ages", "B");
        m_l4.put("ally", "B");
        m_l4.put("ance", "B");
        m_l4.put("ancy", "B");
        m_l4.put("ants", "B");
        m_l4.put("aric", "A");
        m_l4.put("arly", "K");
        m_l4.put("ated", "I");
        m_l4.put("ates", "A");
        m_l4.put("atic", "B");
        m_l4.put("ator", "A");
        m_l4.put("ealy", "Y");
        m_l4.put("edly", "E");
        m_l4.put("eful", "A");
        m_l4.put("eity", "A");
        m_l4.put("ence", "A");
        m_l4.put("ency", "A");
        m_l4.put("ened", "E");
        m_l4.put("enly", "E");
        m_l4.put("eous", "A");
        m_l4.put("hood", "A");
        m_l4.put("ials", "A");
        m_l4.put("ians", "A");
        m_l4.put("ible", "A");
        m_l4.put("ibly", "A");
        m_l4.put("ical", "A");
        m_l4.put("ides", "L");
        m_l4.put("iers", "A");
        m_l4.put("iful", "A");
        m_l4.put("ines", "M");
        m_l4.put("ings", "N");
        m_l4.put("ions", "B");
        m_l4.put("ious", "A");
        m_l4.put("isms", "B");
        m_l4.put("ists", "A");
        m_l4.put("itic", "H");
        m_l4.put("ized", "F");
        m_l4.put("izer", "F");
        m_l4.put("less", "A");
        m_l4.put("lily", "A");
        m_l4.put("ness", "A");
        m_l4.put("ogen", "A");
        m_l4.put("ward", "A");
        m_l4.put("wise", "A");
        m_l4.put("ying", "B");
        m_l4.put("yish", "A");
        m_l3 = new HashMap();
        m_l3.put("acy", "A");
        m_l3.put("age", "B");
        m_l3.put("aic", "A");
        m_l3.put("als", "b");
        m_l3.put("ant", "B");
        m_l3.put("ars", "O");
        m_l3.put("ary", "F");
        m_l3.put("ata", "A");
        m_l3.put("ate", "A");
        m_l3.put("eal", "Y");
        m_l3.put("ear", "Y");
        m_l3.put("ely", "E");
        m_l3.put("ene", "E");
        m_l3.put("ent", "C");
        m_l3.put("ery", "E");
        m_l3.put("ese", "A");
        m_l3.put("ful", "A");
        m_l3.put("ial", "A");
        m_l3.put("ian", "A");
        m_l3.put("ics", "A");
        m_l3.put("ide", "L");
        m_l3.put("ied", "A");
        m_l3.put("ier", "A");
        m_l3.put("ies", "P");
        m_l3.put("ily", "A");
        m_l3.put("ine", "M");
        m_l3.put("ing", "N");
        m_l3.put("ion", "Q");
        m_l3.put("ish", "C");
        m_l3.put("ism", "B");
        m_l3.put("ist", "A");
        m_l3.put("ite", "a");
        m_l3.put("ity", "A");
        m_l3.put("ium", "A");
        m_l3.put("ive", "A");
        m_l3.put("ize", "F");
        m_l3.put("oid", "A");
        m_l3.put("one", "R");
        m_l3.put("ous", "A");
        m_l2 = new HashMap();
        m_l2.put("ae", "A");
        m_l2.put("al", "b");
        m_l2.put("ar", "X");
        m_l2.put("as", "B");
        m_l2.put("ed", "E");
        m_l2.put("en", "F");
        m_l2.put("es", "E");
        m_l2.put("ia", "A");
        m_l2.put("ic", "A");
        m_l2.put("is", "A");
        m_l2.put("ly", "B");
        m_l2.put("on", "S");
        m_l2.put("or", "T");
        m_l2.put("um", "U");
        m_l2.put("us", "V");
        m_l2.put("yl", "R");
        m_l2.put("s'", "A");
        m_l2.put("'s", "A");
        m_l1 = new HashMap();
        m_l1.put("a", "A");
        m_l1.put("e", "A");
        m_l1.put("i", "A");
        m_l1.put("o", "A");
        m_l1.put("s", "W");
        m_l1.put("y", "B");
    }
}

