/*
 * Decompiled with CFR 0.152.
 */
package weka.core.logging;

import java.io.PrintStream;
import java.util.Date;
import weka.core.RevisionUtils;
import weka.core.Tee;
import weka.core.logging.FileLogger;
import weka.core.logging.Logger;

public class OutputLogger
extends FileLogger {
    protected OutputPrintStream m_StreamOut;
    protected OutputPrintStream m_StreamErr;
    protected Tee m_StdOut;
    protected Tee m_StdErr;

    protected void initialize() {
        super.initialize();
        try {
            this.m_StdOut = new Tee(System.out);
            System.setOut(this.m_StdOut);
            this.m_StreamOut = new OutputPrintStream(this, this.m_StdOut.getDefault());
            this.m_StdOut.add(this.m_StreamOut);
            this.m_StdErr = new Tee(System.err);
            System.setErr(this.m_StdErr);
            this.m_StreamErr = new OutputPrintStream(this, this.m_StdErr.getDefault());
            this.m_StdErr.add(this.m_StreamErr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doLog(Logger.Level level, String string, String string2, String string3, int n) {
        this.append(m_DateFormat.format(new Date()) + " " + string2 + " " + string3 + this.m_LineFeed + (Object)((Object)level) + ": " + string + this.m_LineFeed);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4716 $");
    }

    public static class OutputPrintStream
    extends PrintStream {
        protected OutputLogger m_Owner;
        protected String m_LineFeed;

        public OutputPrintStream(OutputLogger outputLogger, PrintStream printStream) throws Exception {
            super(printStream);
            this.m_Owner = outputLogger;
            this.m_LineFeed = System.getProperty("line.separator");
        }

        public void flush() {
        }

        public void print(int n) {
            this.m_Owner.append("" + n);
        }

        public void print(boolean bl) {
            this.m_Owner.append("" + bl);
        }

        public void print(String string) {
            this.m_Owner.append("" + string);
        }

        public void print(Object object) {
            this.m_Owner.append("" + object);
        }

        public void println() {
            this.m_Owner.append(this.m_LineFeed);
        }

        public void println(int n) {
            this.m_Owner.append(n + this.m_LineFeed);
        }

        public void println(boolean bl) {
            this.m_Owner.append(bl + this.m_LineFeed);
        }

        public void println(String string) {
            this.m_Owner.append(string + this.m_LineFeed);
        }

        public void println(Object object) {
            this.m_Owner.append(object + this.m_LineFeed);
        }
    }
}

