/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class MedianOfWidestDimension
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1383443320160540663L;

    public String globalInfo() {
        return "The class that splits a KDTree node based on the median value of a dimension in which the node's points have the widest spread.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Jerome H. Friedman and Jon Luis Bentley and Raphael Ari Finkel");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1977");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "An Algorithm for Finding Best Matches in Logarithmic Expected Time");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "ACM Transactions on Mathematics Software");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "209-226");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "September");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "3");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "3");
        return technicalInformation;
    }

    public void splitNode(KDTreeNode kDTreeNode, int n, double[][] dArray, double[][] dArray2) throws Exception {
        this.correctlyInitialized();
        int n2 = this.widestDim(dArray, dArray2);
        int n3 = kDTreeNode.m_Start + (kDTreeNode.m_End - kDTreeNode.m_Start) / 2;
        int n4 = this.select(n2, this.m_InstList, kDTreeNode.m_Start, kDTreeNode.m_End, (kDTreeNode.m_End - kDTreeNode.m_Start) / 2 + 1);
        kDTreeNode.m_SplitDim = n2;
        kDTreeNode.m_SplitValue = this.m_Instances.instance(this.m_InstList[n4]).value(n2);
        kDTreeNode.m_Left = new KDTreeNode(n + 1, kDTreeNode.m_Start, n3, this.m_EuclideanDistance.initializeRanges(this.m_InstList, kDTreeNode.m_Start, n3));
        kDTreeNode.m_Right = new KDTreeNode(n + 2, n3 + 1, kDTreeNode.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, n3 + 1, kDTreeNode.m_End));
    }

    protected int partition(int n, int[] nArray, int n2, int n3) {
        double d = this.m_Instances.instance(nArray[(n2 + n3) / 2]).value(n);
        while (n2 < n3) {
            while (this.m_Instances.instance(nArray[n2]).value(n) < d && n2 < n3) {
                ++n2;
            }
            while (this.m_Instances.instance(nArray[n3]).value(n) > d && n2 < n3) {
                --n3;
            }
            if (n2 >= n3) continue;
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            --n3;
        }
        if (n2 == n3 && this.m_Instances.instance(nArray[n3]).value(n) > d) {
            --n3;
        }
        return n3;
    }

    public int select(int n, int[] nArray, int n2, int n3, int n4) {
        if (n2 == n3) {
            return n2;
        }
        int n5 = this.partition(n, nArray, n2, n3);
        if (n5 - n2 + 1 >= n4) {
            return this.select(n, nArray, n2, n5, n4);
        }
        return this.select(n, nArray, n5 + 1, n3, n4 - (n5 - n2 + 1));
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

