/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultProducer;

public class DatabaseUtils
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -8252351994547116729L;
    public static final String EXP_INDEX_TABLE = "Experiment_index";
    public static final String EXP_TYPE_COL = "Experiment_type";
    public static final String EXP_SETUP_COL = "Experiment_setup";
    public static final String EXP_RESULT_COL = "Result_table";
    public static final String EXP_RESULT_PREFIX = "Results";
    public static final String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected Vector DRIVERS = new Vector();
    protected static Vector DRIVERS_ERRORS;
    protected Properties PROPERTIES;
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int DOUBLE = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DATE = 8;
    public static final int TEXT = 9;
    public static final int TIME = 10;
    protected String m_DatabaseURL;
    protected transient PreparedStatement m_PreparedStatement;
    protected transient Connection m_Connection;
    protected boolean m_Debug = false;
    protected String m_userName = "";
    protected String m_password = "";
    protected String m_stringType = "LONGVARCHAR";
    protected String m_intType = "INT";
    protected String m_doubleType = "DOUBLE";
    protected boolean m_checkForUpperCaseNames = false;
    protected boolean m_checkForLowerCaseNames = false;
    protected boolean m_setAutoCommit = true;
    protected boolean m_createIndex = false;
    protected HashSet<String> m_Keywords = new HashSet();
    protected String m_KeywordsMaskChar = "_";

    public DatabaseUtils() throws Exception {
        if (DRIVERS_ERRORS == null) {
            DRIVERS_ERRORS = new Vector();
        }
        try {
            this.PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            String string = this.PROPERTIES.getProperty("jdbcDriver", "jdbc.idbDriver");
            if (string == null) {
                throw new Exception("No database drivers (JDBC) specified");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                String string2 = stringTokenizer.nextToken();
                try {
                    Class.forName(string2);
                    this.DRIVERS.addElement(string2);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (this.m_Debug || !bl && !DRIVERS_ERRORS.contains(string2)) {
                    System.err.println("Trying to add database driver (JDBC): " + string2 + " - " + (bl ? "Success!" : "Error, not in CLASSPATH?"));
                }
                if (bl) continue;
                DRIVERS_ERRORS.add(string2);
            }
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(exception);
        }
        this.m_DatabaseURL = this.PROPERTIES.getProperty("jdbcURL", "jdbc:idb=experiments.prp");
        this.m_stringType = this.PROPERTIES.getProperty("CREATE_STRING", "LONGVARCHAR");
        this.m_intType = this.PROPERTIES.getProperty("CREATE_INT", "INT");
        this.m_doubleType = this.PROPERTIES.getProperty("CREATE_DOUBLE", "DOUBLE");
        this.m_checkForUpperCaseNames = this.PROPERTIES.getProperty("checkUpperCaseNames", "false").equals("true");
        this.m_checkForLowerCaseNames = this.PROPERTIES.getProperty("checkLowerCaseNames", "false").equals("true");
        this.m_setAutoCommit = this.PROPERTIES.getProperty("setAutoCommit", "false").equals("true");
        this.m_createIndex = this.PROPERTIES.getProperty("createIndex", "false").equals("true");
        this.setKeywords(this.PROPERTIES.getProperty("Keywords", "AND,ASC,BY,DESC,FROM,GROUP,INSERT,ORDER,SELECT,UPDATE,WHERE"));
        this.setKeywordsMaskChar(this.PROPERTIES.getProperty("KeywordsMaskChar", "_"));
    }

    protected String attributeCaseFix(String string) {
        if (this.m_checkForUpperCaseNames) {
            String string2 = string.toUpperCase();
            if (string2.equals(EXP_TYPE_COL.toUpperCase())) {
                return EXP_TYPE_COL;
            }
            if (string2.equals(EXP_SETUP_COL.toUpperCase())) {
                return EXP_SETUP_COL;
            }
            if (string2.equals(EXP_RESULT_COL.toUpperCase())) {
                return EXP_RESULT_COL;
            }
            return string;
        }
        if (this.m_checkForLowerCaseNames) {
            String string3 = string.toLowerCase();
            if (string3.equals(EXP_TYPE_COL.toLowerCase())) {
                return EXP_TYPE_COL;
            }
            if (string3.equals(EXP_SETUP_COL.toLowerCase())) {
                return EXP_SETUP_COL;
            }
            if (string3.equals(EXP_RESULT_COL.toLowerCase())) {
                return EXP_RESULT_COL;
            }
            return string;
        }
        return string;
    }

    public int translateDBColumnType(String string) {
        try {
            String string2 = this.PROPERTIES.getProperty(string);
            String string3 = string.replaceAll(" ", "_");
            if (string2 == null) {
                string2 = this.PROPERTIES.getProperty(string3);
            }
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Unknown data type: " + string + ". " + "Add entry in " + PROPERTY_FILE + ".\n" + "If the type contains blanks, either escape them with a backslash " + "or use underscores instead of blanks.");
        }
    }

    public static String arrayToString(Object[] objectArray) {
        String string = "";
        if (objectArray == null) {
            string = "<null>";
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                string = objectArray[i] == null ? string + " ?" : string + " " + objectArray[i];
            }
        }
        return string;
    }

    public static String typeName(int n) {
        switch (n) {
            case -5: {
                return "BIGINT ";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown";
    }

    public String databaseURLTipText() {
        return "Set the URL to the database.";
    }

    public String getDatabaseURL() {
        return this.m_DatabaseURL;
    }

    public void setDatabaseURL(String string) {
        this.m_DatabaseURL = string;
    }

    public String debugTipText() {
        return "Whether debug information is printed.";
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String usernameTipText() {
        return "The user to use for connecting to the database.";
    }

    public void setUsername(String string) {
        this.m_userName = string;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public String passwordTipText() {
        return "The password to use for connecting to the database.";
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void connectToDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println("Connecting to " + this.m_DatabaseURL);
        }
        if (this.m_Connection == null) {
            if (this.m_userName.equals("")) {
                try {
                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL);
                }
                catch (SQLException sQLException) {
                    for (int i = 0; i < this.DRIVERS.size(); ++i) {
                        try {
                            Class.forName((String)this.DRIVERS.elementAt(i));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL);
                }
            } else {
                try {
                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
                }
                catch (SQLException sQLException) {
                    for (int i = 0; i < this.DRIVERS.size(); ++i) {
                        try {
                            Class.forName((String)this.DRIVERS.elementAt(i));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
                }
            }
        }
        this.m_Connection.setAutoCommit(this.m_setAutoCommit);
    }

    public void disconnectFromDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println("Disconnecting from " + this.m_DatabaseURL);
        }
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
    }

    public boolean isConnected() {
        return this.m_Connection != null;
    }

    public boolean isCursorScrollSensitive() {
        boolean bl = false;
        try {
            if (this.isConnected()) {
                bl = this.m_Connection.getMetaData().supportsResultSetConcurrency(1005, 1007);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isCursorScrollable() {
        return this.getSupportedCursorScrollType() != -1;
    }

    public int getSupportedCursorScrollType() {
        int n = -1;
        try {
            if (this.isConnected()) {
                if (this.m_Connection.getMetaData().supportsResultSetConcurrency(1005, 1007)) {
                    n = 1005;
                }
                if (n == -1 && this.m_Connection.getMetaData().supportsResultSetConcurrency(1004, 1007)) {
                    n = 1004;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public boolean execute(String string) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        this.m_PreparedStatement = !this.isCursorScrollable() ? this.m_Connection.prepareStatement(string, 1003, 1007) : this.m_Connection.prepareStatement(string, this.getSupportedCursorScrollType(), 1007);
        return this.m_PreparedStatement.execute();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_PreparedStatement != null) {
            return this.m_PreparedStatement.getResultSet();
        }
        return null;
    }

    public int update(String string) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        Statement statement = !this.isCursorScrollable() ? this.m_Connection.createStatement(1003, 1007) : this.m_Connection.createStatement(this.getSupportedCursorScrollType(), 1007);
        int n = statement.executeUpdate(string);
        statement.close();
        return n;
    }

    public ResultSet select(String string) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        Statement statement = !this.isCursorScrollable() ? this.m_Connection.createStatement(1003, 1007) : this.m_Connection.createStatement(this.getSupportedCursorScrollType(), 1007);
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet;
    }

    public void close(ResultSet resultSet) {
        try {
            Statement statement = resultSet.getStatement();
            resultSet.close();
            statement.close();
            statement = null;
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.m_PreparedStatement != null) {
            try {
                this.m_PreparedStatement.close();
                this.m_PreparedStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean tableExists(String string) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        if (this.m_Debug) {
            System.err.println("Checking if table " + string + " exists...");
        }
        DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
        ResultSet resultSet = this.m_checkForUpperCaseNames ? databaseMetaData.getTables(null, null, string.toUpperCase(), null) : (this.m_checkForLowerCaseNames ? databaseMetaData.getTables(null, null, string.toLowerCase(), null) : databaseMetaData.getTables(null, null, string, null));
        boolean bl = resultSet.next();
        if (resultSet.next()) {
            throw new Exception("This table seems to exist more than once!");
        }
        resultSet.close();
        if (this.m_Debug) {
            if (bl) {
                System.err.println("... " + string + " exists");
            } else {
                System.err.println("... " + string + " does not exist");
            }
        }
        return bl;
    }

    public static String processKeyString(String string) {
        return string.replaceAll("\\\\", "/").replaceAll("'", "''");
    }

    protected boolean isKeyInTable(String string, ResultProducer resultProducer, Object[] objectArray) throws Exception {
        int n;
        String string2 = "SELECT Key_Run FROM " + string;
        String[] stringArray = resultProducer.getKeyNames();
        if (stringArray.length != objectArray.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        boolean bl = true;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            if (bl) {
                string2 = string2 + " WHERE ";
                bl = false;
            } else {
                string2 = string2 + " AND ";
            }
            string2 = string2 + "Key_" + stringArray[n] + '=';
            string2 = objectArray[n] instanceof String ? string2 + "'" + DatabaseUtils.processKeyString(objectArray[n].toString()) + "'" : string2 + objectArray[n].toString();
        }
        n = 0;
        ResultSet resultSet = this.select(string2);
        if (resultSet.next()) {
            n = 1;
            if (resultSet.next()) {
                throw new Exception("More than one result entry for result key: " + string2);
            }
        }
        this.close(resultSet);
        return n != 0;
    }

    public Object[] getResultFromTable(String string, ResultProducer resultProducer, Object[] objectArray) throws Exception {
        String string2 = "SELECT ";
        String[] stringArray = resultProducer.getResultNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[i];
        }
        string2 = string2 + " FROM " + string;
        String[] stringArray2 = resultProducer.getKeyNames();
        if (stringArray2.length != objectArray.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (bl) {
                string2 = string2 + " WHERE ";
                bl = false;
            } else {
                string2 = string2 + " AND ";
            }
            string2 = string2 + "Key_" + stringArray2[i] + '=';
            string2 = objectArray[i] instanceof String ? string2 + "'" + DatabaseUtils.processKeyString(objectArray[i].toString()) + "'" : string2 + objectArray[i].toString();
        }
        ResultSet resultSet = this.select(string2);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        if (!resultSet.next()) {
            throw new Exception("No result for query: " + string2);
        }
        Object[] objectArray2 = new Object[n];
        block6: for (int i = 1; i <= n; ++i) {
            switch (this.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                case 0: {
                    objectArray2[i - 1] = resultSet.getString(i);
                    if (!resultSet.wasNull()) continue block6;
                    objectArray2[i - 1] = null;
                    continue block6;
                }
                case 2: 
                case 7: {
                    objectArray2[i - 1] = new Double(resultSet.getDouble(i));
                    if (!resultSet.wasNull()) continue block6;
                    objectArray2[i - 1] = null;
                    continue block6;
                }
                default: {
                    throw new Exception("Unhandled SQL result type (field " + (i + 1) + "): " + DatabaseUtils.typeName(resultSetMetaData.getColumnType(i)));
                }
            }
        }
        if (resultSet.next()) {
            throw new Exception("More than one result entry for result key: " + string2);
        }
        this.close(resultSet);
        return objectArray2;
    }

    public void putResultInTable(String string, ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        int n;
        String string2 = "INSERT INTO " + string + " VALUES ( ";
        for (n = 0; n < objectArray.length; ++n) {
            if (n != 0) {
                string2 = string2 + ',';
            }
            if (objectArray[n] != null) {
                if (objectArray[n] instanceof String) {
                    string2 = string2 + "'" + DatabaseUtils.processKeyString(objectArray[n].toString()) + "'";
                    continue;
                }
                if (objectArray[n] instanceof Double) {
                    string2 = string2 + this.safeDoubleToString((Double)objectArray[n]);
                    continue;
                }
                string2 = string2 + objectArray[n].toString();
                continue;
            }
            string2 = string2 + "NULL";
        }
        for (n = 0; n < objectArray2.length; ++n) {
            string2 = string2 + ',';
            if (objectArray2[n] != null) {
                if (objectArray2[n] instanceof String) {
                    string2 = string2 + "'" + objectArray2[n].toString() + "'";
                    continue;
                }
                if (objectArray2[n] instanceof Double) {
                    string2 = string2 + this.safeDoubleToString((Double)objectArray2[n]);
                    continue;
                }
                string2 = string2 + objectArray2[n].toString();
                continue;
            }
            string2 = string2 + "NULL";
        }
        string2 = string2 + ')';
        if (this.m_Debug) {
            System.err.println("Submitting result: " + string2);
        }
        this.update(string2);
        this.close();
    }

    private String safeDoubleToString(Double d) {
        if (d.isNaN()) {
            return "NULL";
        }
        String string = d.toString();
        int n = string.indexOf(69);
        if (n == -1 || string.charAt(n + 1) == '-') {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(n + 1, '+');
        return new String(stringBuffer);
    }

    public boolean experimentIndexExists() throws Exception {
        return this.tableExists(EXP_INDEX_TABLE);
    }

    public void createExperimentIndex() throws Exception {
        if (this.m_Debug) {
            System.err.println("Creating experiment index table...");
        }
        String string = "CREATE TABLE Experiment_index ( Experiment_type " + this.m_stringType + "," + "  " + EXP_SETUP_COL + " " + this.m_stringType + "," + "  " + EXP_RESULT_COL + " " + this.m_intType + " )";
        this.update(string);
        this.close();
    }

    public String createExperimentIndexEntry(ResultProducer resultProducer) throws Exception {
        String string;
        if (this.m_Debug) {
            System.err.println("Creating experiment index entry...");
        }
        int n = 0;
        String string2 = "SELECT COUNT(*) FROM Experiment_index";
        ResultSet resultSet = this.select(string2);
        if (this.m_Debug) {
            System.err.println("...getting number of rows");
        }
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        this.close(resultSet);
        String string3 = resultProducer.getClass().getName();
        String string4 = resultProducer.getCompatibilityState();
        string2 = "INSERT INTO Experiment_index VALUES ('" + string3 + "', '" + string4 + "', " + n + " )";
        if (this.update(string2) > 0 && this.m_Debug) {
            System.err.println("...create returned resultset");
        }
        this.close();
        if (!this.m_setAutoCommit) {
            this.m_Connection.commit();
            this.m_Connection.setAutoCommit(true);
        }
        if ((string = this.getResultsTableName(resultProducer)) == null) {
            throw new Exception("Problem adding experiment index entry");
        }
        try {
            string2 = "DROP TABLE " + string;
            if (this.m_Debug) {
                System.err.println(string2);
            }
            this.update(string2);
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        return string;
    }

    public String getResultsTableName(ResultProducer resultProducer) throws Exception {
        if (this.m_Debug) {
            System.err.println("Getting results table name...");
        }
        String string = resultProducer.getClass().getName();
        String string2 = resultProducer.getCompatibilityState();
        String string3 = "SELECT Result_table FROM Experiment_index WHERE Experiment_type='" + string + "' AND " + EXP_SETUP_COL + "='" + string2 + "'";
        String string4 = null;
        ResultSet resultSet = this.select(string3);
        if (resultSet.next()) {
            string4 = resultSet.getString(1);
            if (resultSet.next()) {
                throw new Exception("More than one index entry for experiment config: " + string3);
            }
        }
        this.close(resultSet);
        if (this.m_Debug) {
            System.err.println("...results table = " + (string4 == null ? "<null>" : EXP_RESULT_PREFIX + string4));
        }
        return string4 == null ? string4 : EXP_RESULT_PREFIX + string4;
    }

    public String createResultsTable(ResultProducer resultProducer, String string) throws Exception {
        int n;
        Object[] objectArray;
        if (this.m_Debug) {
            System.err.println("Creating results table " + string + "...");
        }
        String string2 = "CREATE TABLE " + string + " ( ";
        String[] stringArray = resultProducer.getKeyNames();
        if (stringArray.length != (objectArray = resultProducer.getKeyTypes()).length) {
            throw new Exception("key names types differ in length");
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = string2 + "Key_" + stringArray[n] + " ";
            if (objectArray[n] instanceof Double) {
                string2 = string2 + this.m_doubleType;
            } else if (objectArray[n] instanceof String) {
                string2 = string2 + this.m_stringType + " ";
            } else {
                throw new Exception("Unknown/unsupported field type in key");
            }
            string2 = string2 + ", ";
        }
        stringArray = resultProducer.getResultNames();
        if (stringArray.length != (objectArray = resultProducer.getResultTypes()).length) {
            throw new Exception("result names and types differ in length");
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = string2 + stringArray[n] + " ";
            if (objectArray[n] instanceof Double) {
                string2 = string2 + this.m_doubleType;
            } else if (objectArray[n] instanceof String) {
                string2 = string2 + this.m_stringType + " ";
            } else {
                throw new Exception("Unknown/unsupported field type in key");
            }
            if (n >= stringArray.length - 1) continue;
            string2 = string2 + ", ";
        }
        string2 = string2 + " )";
        this.update(string2);
        if (this.m_Debug) {
            System.err.println("table created");
        }
        this.close();
        if (this.m_createIndex) {
            string2 = "CREATE UNIQUE INDEX Key_IDX ON " + string + " (";
            String[] stringArray2 = resultProducer.getKeyNames();
            boolean bl = true;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null) continue;
                if (bl) {
                    bl = false;
                    string2 = string2 + "Key_" + stringArray2[i];
                    continue;
                }
                string2 = string2 + ",Key_" + stringArray2[i];
            }
            string2 = string2 + ")";
            this.update(string2);
        }
        return string;
    }

    public void setKeywords(String string) {
        this.m_Keywords.clear();
        String[] stringArray = string.replaceAll(" ", "").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_Keywords.add(stringArray[i].toUpperCase());
        }
    }

    public String getKeywords() {
        Vector<String> vector = new Vector<String>(this.m_Keywords);
        Collections.sort(vector);
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + vector.get(i);
        }
        return string;
    }

    public void setKeywordsMaskChar(String string) {
        this.m_KeywordsMaskChar = string;
    }

    public String getKeywordsMaskChar() {
        return this.m_KeywordsMaskChar;
    }

    public boolean isKeyword(String string) {
        return this.m_Keywords.contains(string.toUpperCase());
    }

    public String maskKeyword(String string) {
        if (this.isKeyword(string)) {
            return string + this.m_KeywordsMaskChar;
        }
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5240 $");
    }
}

