/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GeneticSearch
extends GlobalScoreSearchAlgorithm {
    static final long serialVersionUID = 4236165533882462203L;
    int m_nRuns = 10;
    int m_nPopulationSize = 10;
    int m_nDescendantPopulationSize = 100;
    boolean m_bUseCrossOver = true;
    boolean m_bUseMutation = true;
    boolean m_bUseTournamentSelection = false;
    int m_nSeed = 1;
    Random m_random = null;
    static boolean[] g_bIsSquare;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        int n;
        if (this.getDescendantPopulationSize() < this.getPopulationSize()) {
            throw new Exception("Descendant PopulationSize should be at least Population Size");
        }
        if (!this.getUseCrossOver() && !this.getUseMutation()) {
            throw new Exception("At least one of mutation or cross-over should be used");
        }
        this.m_random = new Random(this.m_nSeed);
        double d = this.calcScore(bayesNet);
        BayesNet bayesNet2 = new BayesNet();
        bayesNet2.m_Instances = instances;
        bayesNet2.initStructure();
        this.copyParentSets(bayesNet2, bayesNet);
        BayesNetRepresentation[] bayesNetRepresentationArray = new BayesNetRepresentation[this.getPopulationSize()];
        for (n = 0; n < this.getPopulationSize(); ++n) {
            bayesNetRepresentationArray[n] = new BayesNetRepresentation(instances.numAttributes());
            bayesNetRepresentationArray[n].randomInit();
            if (!(bayesNetRepresentationArray[n].getScore() > d)) continue;
            this.copyParentSets(bayesNet2, bayesNet);
            d = bayesNetRepresentationArray[n].getScore();
        }
        for (n = 0; n < this.m_nRuns; ++n) {
            BayesNetRepresentation[] bayesNetRepresentationArray2 = new BayesNetRepresentation[this.getDescendantPopulationSize()];
            for (int i = 0; i < this.getDescendantPopulationSize(); ++i) {
                bayesNetRepresentationArray2[i] = bayesNetRepresentationArray[this.m_random.nextInt(this.getPopulationSize())].copy();
                if (this.getUseMutation()) {
                    if (this.getUseCrossOver() && this.m_random.nextBoolean()) {
                        bayesNetRepresentationArray2[i].crossOver(bayesNetRepresentationArray[this.m_random.nextInt(this.getPopulationSize())]);
                    } else {
                        bayesNetRepresentationArray2[i].mutate();
                    }
                } else {
                    bayesNetRepresentationArray2[i].crossOver(bayesNetRepresentationArray[this.m_random.nextInt(this.getPopulationSize())]);
                }
                if (!(bayesNetRepresentationArray2[i].getScore() > d)) continue;
                this.copyParentSets(bayesNet2, bayesNet);
                d = bayesNetRepresentationArray2[i].getScore();
            }
            boolean[] blArray = new boolean[this.getDescendantPopulationSize()];
            for (int i = 0; i < this.getPopulationSize(); ++i) {
                int n2 = 0;
                if (this.m_bUseTournamentSelection) {
                    n2 = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (blArray[n2]) {
                        n2 = (n2 + 1) % this.getDescendantPopulationSize();
                    }
                    int n3 = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (blArray[n3]) {
                        n3 = (n3 + 1) % this.getDescendantPopulationSize();
                    }
                    if (bayesNetRepresentationArray2[n3].getScore() > bayesNetRepresentationArray2[n2].getScore()) {
                        n2 = n3;
                    }
                } else {
                    while (blArray[n2]) {
                        ++n2;
                    }
                    double d2 = bayesNetRepresentationArray2[n2].getScore();
                    for (int j = 0; j < this.getDescendantPopulationSize(); ++j) {
                        if (blArray[j] || !(bayesNetRepresentationArray2[j].getScore() > d2)) continue;
                        d2 = bayesNetRepresentationArray2[j].getScore();
                        n2 = j;
                    }
                }
                bayesNetRepresentationArray[i] = bayesNetRepresentationArray2[n2];
                blArray[n2] = true;
            }
        }
        this.copyParentSets(bayesNet, bayesNet2);
        bayesNet2 = null;
    }

    void copyParentSets(BayesNet bayesNet, BayesNet bayesNet2) {
        int n = bayesNet2.getNrOfNodes();
        for (int i = 0; i < n; ++i) {
            bayesNet.getParentSet(i).copy(bayesNet2.getParentSet(i));
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int n) {
        this.m_nRuns = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tPopulation size", "L", 1, "-L <integer>"));
        vector.addElement(new Option("\tDescendant population size", "A", 1, "-A <integer>"));
        vector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        vector.addElement(new Option("\tUse mutation.\n\t(default true)", "M", 0, "-M"));
        vector.addElement(new Option("\tUse cross-over.\n\t(default true)", "C", 0, "-C"));
        vector.addElement(new Option("\tUse tournament selection (true) or maximum subpopulatin (false).\n\t(default false)", "O", 0, "-O"));
        vector.addElement(new Option("\tRandom number seed", "R", 1, "-R <seed>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3;
        String string4 = Utils.getOption('L', stringArray);
        if (string4.length() != 0) {
            this.setPopulationSize(Integer.parseInt(string4));
        }
        if ((string3 = Utils.getOption('A', stringArray)).length() != 0) {
            this.setDescendantPopulationSize(Integer.parseInt(string3));
        }
        if ((string2 = Utils.getOption('U', stringArray)).length() != 0) {
            this.setRuns(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        this.setUseMutation(Utils.getFlag('M', stringArray));
        this.setUseCrossOver(Utils.getFlag('C', stringArray));
        this.setUseTournamentSelection(Utils.getFlag('O', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[11 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getPopulationSize();
        stringArray2[n++] = "-A";
        stringArray2[n++] = "" + this.getDescendantPopulationSize();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRuns();
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.getSeed();
        if (this.getUseMutation()) {
            stringArray2[n++] = "-M";
        }
        if (this.getUseCrossOver()) {
            stringArray2[n++] = "-C";
        }
        if (this.getUseTournamentSelection()) {
            stringArray2[n++] = "-O";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public boolean getUseCrossOver() {
        return this.m_bUseCrossOver;
    }

    public boolean getUseMutation() {
        return this.m_bUseMutation;
    }

    public int getDescendantPopulationSize() {
        return this.m_nDescendantPopulationSize;
    }

    public int getPopulationSize() {
        return this.m_nPopulationSize;
    }

    public void setUseCrossOver(boolean bl) {
        this.m_bUseCrossOver = bl;
    }

    public void setUseMutation(boolean bl) {
        this.m_bUseMutation = bl;
    }

    public boolean getUseTournamentSelection() {
        return this.m_bUseTournamentSelection;
    }

    public void setUseTournamentSelection(boolean bl) {
        this.m_bUseTournamentSelection = bl;
    }

    public void setDescendantPopulationSize(int n) {
        this.m_nDescendantPopulationSize = n;
    }

    public void setPopulationSize(int n) {
        this.m_nPopulationSize = n;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int n) {
        this.m_nSeed = n;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses genetic search for finding a well scoring Bayes network structure. Genetic search works by having a population of Bayes network structures and allow them to mutate and apply cross over to get offspring. The best network structure found during the process is returned.";
    }

    public String runsTipText() {
        return "Sets the number of generations of Bayes network structure populations.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    public String populationSizeTipText() {
        return "Sets the size of the population of network structures that is selected each generation.";
    }

    public String descendantPopulationSizeTipText() {
        return "Sets the size of the population of descendants that is created each generation.";
    }

    public String useMutationTipText() {
        return "Determines whether mutation is allowed. Mutation flips a bit in the bit representation of the network structure. At least one of mutation or cross-over should be used.";
    }

    public String useCrossOverTipText() {
        return "Determines whether cross-over is allowed. Cross over combined the bit representations of network structure by taking a random first k bits of oneand adding the remainder of the other. At least one of mutation or cross-over should be used.";
    }

    public String useTournamentSelectionTipText() {
        return "Determines the method of selecting a population. When set to true, tournament selection is used (pick two at random and the highest is allowed to continue). When set to false, the top scoring network structures are selected.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    class BayesNetRepresentation
    implements RevisionHandler {
        int m_nNodes = 0;
        boolean[] m_bits;
        double m_fScore = 0.0;

        public double getScore() {
            return this.m_fScore;
        }

        BayesNetRepresentation(int n) {
            this.m_nNodes = n;
        }

        public void randomInit() {
            do {
                this.m_bits = new boolean[this.m_nNodes * this.m_nNodes];
                for (int i = 0; i < this.m_nNodes; ++i) {
                    int n;
                    while (this.isSquare(n = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    }
                    this.m_bits[n] = true;
                }
            } while (this.hasCycles());
            this.calcGlobalScore();
        }

        void calcGlobalScore() {
            ParentSet parentSet;
            int n;
            for (n = 0; n < this.m_nNodes; ++n) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(n);
                while (parentSet.getNrOfParents() > 0) {
                    parentSet.deleteLastParent(GeneticSearch.this.m_BayesNet.m_Instances);
                }
            }
            for (n = 0; n < this.m_nNodes; ++n) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(n);
                for (int i = 0; i < this.m_nNodes; ++i) {
                    if (!this.m_bits[i + n * this.m_nNodes]) continue;
                    parentSet.addParent(i, GeneticSearch.this.m_BayesNet.m_Instances);
                }
            }
            try {
                this.m_fScore = GeneticSearch.this.calcScore(GeneticSearch.this.m_BayesNet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean hasCycles() {
            boolean[] blArray = new boolean[this.m_nNodes];
            for (int i = 0; i < this.m_nNodes; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < this.m_nNodes; ++j) {
                    if (blArray[j]) continue;
                    boolean bl2 = true;
                    for (int k = 0; k < this.m_nNodes; ++k) {
                        if (!this.m_bits[k + j * this.m_nNodes] || blArray[k]) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    blArray[j] = true;
                    bl = true;
                }
                if (bl) continue;
                return true;
            }
            return false;
        }

        BayesNetRepresentation copy() {
            BayesNetRepresentation bayesNetRepresentation = new BayesNetRepresentation(this.m_nNodes);
            bayesNetRepresentation.m_bits = new boolean[this.m_bits.length];
            for (int i = 0; i < this.m_nNodes * this.m_nNodes; ++i) {
                bayesNetRepresentation.m_bits[i] = this.m_bits[i];
            }
            bayesNetRepresentation.m_fScore = this.m_fScore;
            return bayesNetRepresentation;
        }

        void mutate() {
            while (true) {
                int n;
                if (this.isSquare(n = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    continue;
                }
                boolean bl = this.m_bits[n] = !this.m_bits[n];
                if (!this.hasCycles()) break;
            }
            this.calcGlobalScore();
        }

        void crossOver(BayesNetRepresentation bayesNetRepresentation) {
            int n;
            boolean[] blArray = new boolean[this.m_bits.length];
            for (n = 0; n < this.m_bits.length; ++n) {
                blArray[n] = this.m_bits[n];
            }
            n = this.m_bits.length;
            do {
                int n2;
                for (n2 = n; n2 < this.m_bits.length; ++n2) {
                    this.m_bits[n2] = blArray[n2];
                }
                for (n2 = n = GeneticSearch.this.m_random.nextInt(this.m_bits.length); n2 < this.m_bits.length; ++n2) {
                    this.m_bits[n2] = bayesNetRepresentation.m_bits[n2];
                }
            } while (this.hasCycles());
            this.calcGlobalScore();
        }

        boolean isSquare(int n) {
            if (g_bIsSquare == null || g_bIsSquare.length < n) {
                g_bIsSquare = new boolean[this.m_nNodes * this.m_nNodes];
                for (int i = 0; i < this.m_nNodes; ++i) {
                    GeneticSearch.g_bIsSquare[i * this.m_nNodes + i] = true;
                }
            }
            return g_bIsSquare[n];
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.5 $");
        }
    }
}

