/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.nestedDichotomies;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class ND
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6355893369855683820L;
    protected NDTree m_ndtree = null;
    protected Hashtable m_classifiers = null;
    protected boolean m_hashtablegiven = false;

    public ND() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Lin Dong and Eibe Frank and Stefan Kramer");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Ensembles of Balanced Nested Dichotomies for Multi-class Problems");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "PKDD");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "84-95");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Stefan Kramer");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Ensembles of nested dichotomies for multi-class problems");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Twenty-first International Conference on Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return technicalInformation;
    }

    public void setHashtable(Hashtable hashtable) {
        this.m_hashtablegiven = true;
        this.m_classifiers = hashtable;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(1);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        if (!this.m_hashtablegiven) {
            this.m_classifiers = new Hashtable();
        }
        int[] nArray = new int[instances.numClasses()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = nArray.length - 1; n2 > 0; --n2) {
            n = nArray[n2];
            int n3 = random.nextInt(n2 + 1);
            nArray[n2] = nArray[n3];
            nArray[n3] = n;
        }
        this.m_ndtree = new NDTree();
        this.m_ndtree.insertClassIndexAtNode(nArray[0]);
        for (n2 = 1; n2 < nArray.length; ++n2) {
            n = random.nextInt(2 * n2 - 1);
            NDTree nDTree = this.m_ndtree.locateNode(n, new int[1]);
            nDTree.insertClassIndex(nArray[n2]);
        }
        this.m_ndtree.unifyTree();
        this.buildClassifierForNode(this.m_ndtree, instances);
    }

    public void buildClassifierForNode(NDTree nDTree, Instances instances) throws Exception {
        if (nDTree.m_left != null) {
            Instances instances2;
            RemoveWithValues removeWithValues;
            MakeIndicator makeIndicator = new MakeIndicator();
            makeIndicator.setAttributeIndex("" + (instances.classIndex() + 1));
            makeIndicator.setValueIndices(nDTree.m_right.getString());
            makeIndicator.setNumeric(false);
            makeIndicator.setInputFormat(instances);
            FilteredClassifier filteredClassifier = new FilteredClassifier();
            if (instances.numInstances() > 0) {
                filteredClassifier.setClassifier(Classifier.makeCopies(this.m_Classifier, 1)[0]);
            } else {
                filteredClassifier.setClassifier(new ZeroR());
            }
            filteredClassifier.setFilter(makeIndicator);
            if (!this.m_classifiers.containsKey(nDTree.m_left.getString() + "|" + nDTree.m_right.getString())) {
                filteredClassifier.buildClassifier(instances);
                this.m_classifiers.put(nDTree.m_left.getString() + "|" + nDTree.m_right.getString(), filteredClassifier);
            } else {
                filteredClassifier = (FilteredClassifier)this.m_classifiers.get(nDTree.m_left.getString() + "|" + nDTree.m_right.getString());
            }
            if (nDTree.m_left.m_left != null) {
                removeWithValues = new RemoveWithValues();
                removeWithValues.setInvertSelection(true);
                removeWithValues.setNominalIndices(nDTree.m_left.getString());
                removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
                removeWithValues.setInputFormat(instances);
                instances2 = Filter.useFilter(instances, removeWithValues);
                this.buildClassifierForNode(nDTree.m_left, instances2);
            }
            if (nDTree.m_right.m_left != null) {
                removeWithValues = new RemoveWithValues();
                removeWithValues.setInvertSelection(true);
                removeWithValues.setNominalIndices(nDTree.m_right.getString());
                removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
                removeWithValues.setInputFormat(instances);
                instances2 = Filter.useFilter(instances, removeWithValues);
                this.buildClassifierForNode(nDTree.m_right, instances2);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.distributionForInstance(instance, this.m_ndtree);
    }

    protected double[] distributionForInstance(Instance instance, NDTree nDTree) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        if (nDTree.m_left == null) {
            dArray[nDTree.getIndices()[0]] = 1.0;
            return dArray;
        }
        Classifier classifier = (Classifier)this.m_classifiers.get(nDTree.m_left.getString() + "|" + nDTree.m_right.getString());
        double[] dArray2 = this.distributionForInstance(instance, nDTree.m_left);
        double[] dArray3 = this.distributionForInstance(instance, nDTree.m_right);
        double[] dArray4 = classifier.distributionForInstance(instance);
        for (int i = 0; i < instance.numClasses(); ++i) {
            dArray[i] = nDTree.m_right.contains(i) ? dArray4[1] * dArray3[i] : dArray4[0] * dArray2[i];
        }
        return dArray;
    }

    public String toString() {
        if (this.m_classifiers == null) {
            return "ND: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ND\n\n");
        this.m_ndtree.toString(stringBuffer, new int[1], 0);
        return stringBuffer.toString();
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building a random tree structure.\n\nFor more info, check\n\n" + this.getTechnicalInformation().toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }

    public static void main(String[] stringArray) {
        ND.runClassifier(new ND(), stringArray);
    }

    protected class NDTree
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 4284655952754474880L;
        protected FastVector m_indices = new FastVector(1);
        protected NDTree m_parent = null;
        protected NDTree m_left = null;
        protected NDTree m_right = null;

        protected NDTree() {
            this.m_indices.addElement(new Integer(Integer.MAX_VALUE));
        }

        protected NDTree locateNode(int n, int[] nArray) {
            if (n == nArray[0]) {
                return this;
            }
            if (this.m_left == null) {
                return null;
            }
            nArray[0] = nArray[0] + 1;
            NDTree nDTree = this.m_left.locateNode(n, nArray);
            if (nDTree != null) {
                return nDTree;
            }
            nArray[0] = nArray[0] + 1;
            return this.m_right.locateNode(n, nArray);
        }

        protected void insertClassIndex(int n) {
            NDTree nDTree = new NDTree();
            if (this.m_left != null) {
                this.m_right.m_parent = nDTree;
                this.m_left.m_parent = nDTree;
                nDTree.m_right = this.m_right;
                nDTree.m_left = this.m_left;
            }
            this.m_right = nDTree;
            this.m_right.m_indices = (FastVector)this.m_indices.copy();
            this.m_right.m_parent = this;
            this.m_left = new NDTree();
            this.m_left.insertClassIndexAtNode(n);
            this.m_left.m_parent = this;
            this.propagateClassIndex(n);
        }

        protected void propagateClassIndex(int n) {
            this.insertClassIndexAtNode(n);
            if (this.m_parent != null) {
                this.m_parent.propagateClassIndex(n);
            }
        }

        protected void insertClassIndexAtNode(int n) {
            int n2 = 0;
            while (n > (Integer)this.m_indices.elementAt(n2)) {
                ++n2;
            }
            this.m_indices.insertElementAt(new Integer(n), n2);
        }

        protected int[] getIndices() {
            int[] nArray = new int[this.m_indices.size() - 1];
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                nArray[i] = (Integer)this.m_indices.elementAt(i);
            }
            return nArray;
        }

        protected boolean contains(int n) {
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                if (n != (Integer)this.m_indices.elementAt(i)) continue;
                return true;
            }
            return false;
        }

        protected String getString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Integer)this.m_indices.elementAt(i) + 1);
            }
            return stringBuffer.toString();
        }

        protected void unifyTree() {
            if (this.m_left != null) {
                if ((Integer)this.m_left.m_indices.elementAt(0) > (Integer)this.m_right.m_indices.elementAt(0)) {
                    NDTree nDTree = this.m_left;
                    this.m_left = this.m_right;
                    this.m_right = nDTree;
                }
                this.m_left.unifyTree();
                this.m_right.unifyTree();
            }
        }

        protected void toString(StringBuffer stringBuffer, int[] nArray, int n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("   | ");
            }
            stringBuffer.append(nArray[0] + ": " + this.getString() + "\n");
            if (this.m_left != null) {
                nArray[0] = nArray[0] + 1;
                this.m_left.toString(stringBuffer, nArray, n + 1);
                nArray[0] = nArray[0] + 1;
                this.m_right.toString(stringBuffer, nArray, n + 1);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.9 $");
        }
    }
}

