/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import weka.core.ClassDiscovery;
import weka.core.Trie;
import weka.core.Utils;

public class SimpleCLIPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7377739469759943231L;
    protected static String FILENAME = "SimpleCLI.props";
    protected static String PROPERTY_FILE = "weka/gui/" + FILENAME;
    protected static Properties PROPERTIES;
    protected JTextArea m_OutputArea = new JTextArea();
    protected JTextField m_Input = new JTextField();
    protected Vector m_CommandHistory = new Vector();
    protected int m_HistoryPos = 0;
    protected PipedOutputStream m_POO = new PipedOutputStream();
    protected PipedOutputStream m_POE = new PipedOutputStream();
    protected Thread m_OutRedirector;
    protected Thread m_ErrRedirector;
    protected Thread m_RunThread;
    protected CommandlineCompletion m_Completion;

    public SimpleCLIPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_OutputArea), "Center");
        this.add((Component)this.m_Input, "South");
        this.m_Input.setFont(new Font("Monospaced", 0, 12));
        this.m_Input.addActionListener(this);
        this.m_Input.setFocusTraversalKeysEnabled(false);
        this.m_Input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SimpleCLIPanel.this.doHistory(keyEvent);
                SimpleCLIPanel.this.doCommandlineCompletion(keyEvent);
            }
        });
        this.m_OutputArea.setEditable(false);
        this.m_OutputArea.setFont(new Font("Monospaced", 0, 12));
        PipedInputStream pipedInputStream = new PipedInputStream(this.m_POO);
        System.setOut(new PrintStream(this.m_POO));
        InputStreamReader inputStreamReader = new InputStreamReader(pipedInputStream);
        this.m_OutRedirector = new ReaderToTextArea(inputStreamReader, this.m_OutputArea);
        this.m_OutRedirector.start();
        PipedInputStream pipedInputStream2 = new PipedInputStream(this.m_POE);
        System.setErr(new PrintStream(this.m_POE));
        inputStreamReader = new InputStreamReader(pipedInputStream2);
        this.m_ErrRedirector = new ReaderToTextArea(inputStreamReader, this.m_OutputArea);
        this.m_ErrRedirector.start();
        this.m_Completion = new CommandlineCompletion();
        System.out.println("\nWelcome to the WEKA SimpleCLI\n\nEnter commands in the textfield at the bottom of \nthe window. Use the up and down arrows to move \nthrough previous commands.\nCommand completion for classnames and files is \ninitiated with <Tab>. In order to distinguish \nbetween files and classnames, file names must \nbe either absolute or start with '." + File.separator + "' or '~/'\n" + "(the latter is a shortcut for the home directory).\n" + "<Alt+BackSpace> is used for deleting the text\n" + "in the commandline in chunks.\n");
        this.runCommand("help");
        this.loadHistory();
    }

    public void runCommand(String string) throws Exception {
        System.out.println("> " + string + '\n');
        System.out.flush();
        String[] stringArray = Utils.splitOptions(string);
        if (stringArray.length == 0) {
            return;
        }
        if (stringArray[0].equals("java")) {
            stringArray[0] = "";
            try {
                if (stringArray.length == 1) {
                    throw new Exception("No class name given");
                }
                String string2 = stringArray[1];
                stringArray[1] = "";
                if (this.m_RunThread != null) {
                    throw new Exception("An object is already running, use \"break\" to interrupt it.");
                }
                Class<?> clazz = Class.forName(string2);
                Vector<String> vector = new Vector<String>();
                for (int i = 2; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
                this.m_RunThread = new ClassRunner(clazz, vector.toArray(new String[vector.size()]));
                this.m_RunThread.setPriority(1);
                this.m_RunThread.start();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else if (stringArray[0].equals("cls")) {
            this.m_OutputArea.setText("");
        } else if (stringArray[0].equals("history")) {
            System.out.println("Command history:");
            for (int i = 0; i < this.m_CommandHistory.size(); ++i) {
                System.out.println(this.m_CommandHistory.get(i));
            }
            System.out.println();
        } else if (stringArray[0].equals("break")) {
            if (this.m_RunThread == null) {
                System.err.println("Nothing is currently running.");
            } else {
                System.out.println("[Interrupt...]");
                this.m_RunThread.interrupt();
            }
        } else if (stringArray[0].equals("kill")) {
            if (this.m_RunThread == null) {
                System.err.println("Nothing is currently running.");
            } else {
                System.out.println("[Kill...]");
                this.m_RunThread.stop();
                this.m_RunThread = null;
            }
        } else if (stringArray[0].equals("exit")) {
            Container container = this.getParent();
            Container container2 = null;
            boolean bl = false;
            while (!bl) {
                if (container instanceof JFrame || container instanceof Frame || container instanceof JInternalFrame) {
                    container2 = container;
                    bl = true;
                }
                if (bl) continue;
                bl = (container = container.getParent()) == null;
            }
            if (container2 != null) {
                if (container2 instanceof JInternalFrame) {
                    ((JInternalFrame)container2).doDefaultCloseAction();
                } else {
                    ((Window)container2).dispatchEvent(new WindowEvent((Window)container2, 201));
                }
            }
        } else {
            boolean bl;
            boolean bl2 = bl = stringArray.length > 1 && stringArray[0].equals("help");
            if (bl && stringArray[1].equals("java")) {
                System.err.println("java <classname> <args>\n\nStarts the main method of <classname> with the supplied command line arguments (if any).\nThe command is started in a separate thread, and may be interrupted with the \"break\"\ncommand (friendly), or killed with the \"kill\" command (unfriendly).\nRedirecting can be done with '>' followed by the file to write to, e.g.:\n  java some.Class > ." + File.separator + "some.txt");
            } else if (bl && stringArray[1].equals("break")) {
                System.err.println("break\n\nAttempts to nicely interrupt the running job, if any. If this doesn't respond in an\nacceptable time, use \"kill\".\n");
            } else if (bl && stringArray[1].equals("kill")) {
                System.err.println("kill\n\nKills the running job, if any. You should only use this if the job doesn't respond to\n\"break\".\n");
            } else if (bl && stringArray[1].equals("cls")) {
                System.err.println("cls\n\nClears the output area.\n");
            } else if (bl && stringArray[1].equals("history")) {
                System.err.println("history\n\nPrints all issued commands.\n");
            } else if (bl && stringArray[1].equals("exit")) {
                System.err.println("exit\n\nExits the SimpleCLI program.\n");
            } else {
                System.err.println("Command must be one of:\n\tjava <classname> <args> [ > file]\n\tbreak\n\tkill\n\tcls\n\thistory\n\texit\n\thelp <command>\n");
            }
        }
    }

    public void doHistory(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_Input) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (this.m_HistoryPos <= 0) break;
                    --this.m_HistoryPos;
                    String string = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    this.m_Input.setText(string);
                    break;
                }
                case 40: {
                    if (this.m_HistoryPos >= this.m_CommandHistory.size()) break;
                    ++this.m_HistoryPos;
                    String string = "";
                    if (this.m_HistoryPos < this.m_CommandHistory.size()) {
                        string = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    }
                    this.m_Input.setText(string);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommandlineCompletion(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_Input) {
            switch (keyEvent.getKeyCode()) {
                case 9: {
                    if (keyEvent.getModifiers() != 0) break;
                    this.m_Input.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_OutputArea.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String string = this.m_Input.getText();
                        if (string.trim().startsWith("java ")) {
                            int n = this.m_Input.getCaretPosition();
                            int n2 = -1;
                            for (int i = n - 1; i >= 0; --i) {
                                if (string.charAt(i) != '\"' && string.charAt(i) != ' ') continue;
                                n2 = i;
                                break;
                            }
                            if (n2 > -1) {
                                String string2 = string.substring(n2 + 1, n);
                                Vector<String> vector = this.m_Completion.getMatches(string2);
                                String string3 = this.m_Completion.getCommonPrefix(vector);
                                if ((string2.toLowerCase() + File.separator).equals(string3.toLowerCase())) {
                                    string3 = string2;
                                }
                                if (string3.length() > string2.length()) {
                                    try {
                                        this.m_Input.getDocument().remove(n2 + 1, string2.length());
                                        this.m_Input.getDocument().insertString(n2 + 1, string3, null);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                } else if (vector.size() > 1) {
                                    System.out.println("\nPossible matches:");
                                    for (int i = 0; i < vector.size(); ++i) {
                                        System.out.println("  " + vector.get(i));
                                    }
                                }
                            }
                        }
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        this.m_Input.setCursor(null);
                        this.m_OutputArea.setCursor(null);
                        throw throwable;
                    }
                    this.m_Input.setCursor(null);
                    this.m_OutputArea.setCursor(null);
                    break;
                }
                case 8: {
                    int n;
                    if (keyEvent.getModifiers() != 8) break;
                    String string = this.m_Input.getText();
                    int n3 = n = this.m_Input.getCaretPosition();
                    --n3;
                    while (n3 >= 0 && (string.charAt(n3) == '.' || string.charAt(n3) == ' ' || string.charAt(n3) == '\\' || string.charAt(n3) == '/')) {
                        --n3;
                    }
                    int n4 = -1;
                    for (int i = n3; i >= 0; --i) {
                        if (string.charAt(i) != '.' && string.charAt(i) != ' ' && string.charAt(i) != '\\' && string.charAt(i) != '/') continue;
                        n4 = i;
                        break;
                    }
                    try {
                        this.m_Input.getDocument().remove(n4 + 1, n - n4 - 1);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.m_Input) {
                String string = this.m_Input.getText();
                int n = this.m_CommandHistory.size() - 1;
                if (n < 0 || !string.equals((String)this.m_CommandHistory.elementAt(n))) {
                    this.m_CommandHistory.addElement(string);
                    this.saveHistory();
                }
                this.m_HistoryPos = this.m_CommandHistory.size();
                this.runCommand(string);
                this.m_Input.setText("");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    protected void loadHistory() {
        String string;
        int n = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        this.m_CommandHistory.clear();
        for (int i = 0; i < n && (string = PROPERTIES.getProperty("Command" + i, "")).length() != 0; ++i) {
            this.m_CommandHistory.add(string);
        }
        this.m_HistoryPos = this.m_CommandHistory.size();
    }

    protected void saveHistory() {
        int n = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        int n2 = this.m_CommandHistory.size() - n;
        if (n2 < 0) {
            n2 = 0;
        }
        PROPERTIES.setProperty("HistorySize", "" + n);
        for (int i = n2; i < this.m_CommandHistory.size(); ++i) {
            PROPERTIES.setProperty("Command" + (i - n2), (String)this.m_CommandHistory.get(i));
        }
        try {
            String string = System.getProperties().getProperty("user.home") + File.separatorChar + FILENAME;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            PROPERTIES.store(bufferedOutputStream, "SimpleCLI");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleCLIPanel simpleCLIPanel = new SimpleCLIPanel();
        JFrame jFrame = new JFrame();
        jFrame.setTitle("SimpleCLI");
        jFrame.getContentPane().add(simpleCLIPanel);
        jFrame.setDefaultCloseOperation(2);
        jFrame.pack();
        jFrame.setSize(600, 500);
        jFrame.setVisible(true);
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> enumeration = PROPERTIES.propertyNames();
            if (!enumeration.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the SimpleCLI");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the SimpleCLI.\nAn example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "SimpleCLI", 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandlineCompletion {
        protected static Vector<String> m_Packages;
        protected static Trie m_Trie;
        protected boolean m_Debug = false;

        public CommandlineCompletion() {
            if (m_Packages == null) {
                Vector vector = ClassDiscovery.findPackages();
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray = ((String)vector.get(i)).split("\\.");
                    for (int j = 1; j < stringArray.length; ++j) {
                        String string = "";
                        for (int k = 0; k <= j; ++k) {
                            if (k > 0) {
                                string = string + ".";
                            }
                            string = string + stringArray[k];
                        }
                        hashSet.add(string);
                    }
                }
                m_Packages = new Vector();
                m_Packages.addAll(hashSet);
                Collections.sort(m_Packages);
                m_Trie = new Trie();
                m_Trie.addAll((Collection<? extends String>)m_Packages);
            }
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setDebug(boolean bl) {
            this.m_Debug = bl;
        }

        public boolean isClassname(String string) {
            return string.replaceAll("[a-zA-Z0-9\\-\\.]*", "").length() == 0;
        }

        public String getPackage(String string) {
            String string2 = "";
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl && c >= 'A' && c <= 'Z') break;
                if (c == '.') {
                    bl = true;
                    string2 = string2 + "" + c;
                    continue;
                }
                bl = false;
                string2 = string2 + "" + c;
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }

        public String getClassname(String string) {
            String string2 = this.getPackage(string);
            String string3 = string2.length() + 1 < string.length() ? string.substring(string2.length() + 1) : "";
            return string3;
        }

        public Vector<String> getFileMatches(String string) {
            int n;
            boolean bl;
            Vector<String> vector = new Vector<String>();
            boolean bl2 = bl = File.separatorChar != '\\';
            if (this.m_Debug) {
                System.out.println("case-sensitive=" + bl);
            }
            if (string.startsWith("~")) {
                string = System.getProperty("user.home") + string.substring(1);
            }
            File file = new File(string);
            File file2 = null;
            String string2 = null;
            if (file.exists()) {
                if (file.isDirectory()) {
                    file2 = file;
                    string2 = null;
                } else {
                    file2 = file.getParentFile();
                    string2 = file.getName();
                }
            } else {
                file2 = file.getParentFile();
                string2 = file.getName();
            }
            if (this.m_Debug) {
                System.out.println("search in dir=" + file2 + ", prefix=" + string2);
            }
            if (file2 != null) {
                File[] fileArray = file2.listFiles();
                if (fileArray != null) {
                    for (n = 0; n < fileArray.length; ++n) {
                        String string3 = fileArray[n].getName();
                        boolean bl3 = string2 != null && bl ? string3.startsWith(string2) : (string2 != null && !bl ? string3.toLowerCase().startsWith(string2.toLowerCase()) : true);
                        if (!bl3) continue;
                        if (string2 != null) {
                            vector.add(string.substring(0, string.length() - string2.length()) + string3);
                            continue;
                        }
                        if (string.endsWith("\\") || string.endsWith("/")) {
                            vector.add(string + string3);
                            continue;
                        }
                        vector.add(string + File.separator + string3);
                    }
                } else {
                    System.err.println("Invalid path: " + string);
                }
            }
            if (vector.size() > 1) {
                Collections.sort(vector);
            }
            if (this.m_Debug) {
                System.out.println("file matches:");
                for (n = 0; n < vector.size(); ++n) {
                    System.out.println(vector.get(n));
                }
            }
            return vector;
        }

        public Vector<String> getClassMatches(String string) {
            int n;
            Vector<String> vector;
            String string2 = this.getPackage(string);
            String string3 = this.getClassname(string);
            if (this.getDebug()) {
                System.out.println("\nsearch for: '" + string + "' => package=" + string2 + ", class=" + string3);
            }
            Vector<String> vector2 = new Vector<String>();
            if (string3.length() == 0) {
                vector = m_Trie.getWithPrefix(string2);
                HashSet<String> hashSet = new HashSet<String>();
                for (n = 0; n < vector.size(); ++n) {
                    String string4 = vector.get(n);
                    if (string4.length() < string.length() || string4.equals(string)) continue;
                    int n2 = string4.indexOf(46, string.length() + 1);
                    if (n2 > -1) {
                        hashSet.add(string4.substring(0, n2));
                        continue;
                    }
                    hashSet.add(string4);
                }
                vector2.addAll(hashSet);
                if (vector2.size() > 1) {
                    Collections.sort(vector2);
                }
            }
            vector = ClassDiscovery.find(Object.class, string2);
            Trie trie = new Trie();
            trie.addAll((Collection<? extends String>)vector);
            vector = trie.getWithPrefix(string);
            vector2.addAll(vector);
            if (vector2.size() > 1) {
                Collections.sort(vector2);
            }
            if (this.m_Debug) {
                System.out.println("class/package matches:");
                for (n = 0; n < vector2.size(); ++n) {
                    System.out.println(vector2.get(n));
                }
            }
            return vector2;
        }

        public Vector<String> getMatches(String string) {
            if (this.isClassname(string)) {
                return this.getClassMatches(string);
            }
            return this.getFileMatches(string);
        }

        public String getCommonPrefix(Vector<String> vector) {
            Trie trie = new Trie();
            trie.addAll((Collection<? extends String>)vector);
            String string = trie.getCommonPrefix();
            if (this.m_Debug) {
                System.out.println(vector + "\n  --> common prefix: '" + string + "'");
            }
            return string;
        }
    }

    class ClassRunner
    extends Thread {
        protected Method m_MainMethod;
        String[] m_CommandArgs;

        public ClassRunner(Class clazz, String[] stringArray) throws Exception {
            this.setDaemon(true);
            Class[] classArray = new Class[]{String[].class};
            this.m_CommandArgs = stringArray;
            this.m_MainMethod = clazz.getMethod("main", classArray);
            if ((this.m_MainMethod.getModifiers() & 8) == 0 || (this.m_MainMethod.getModifiers() & 1) == 0) {
                throw new NoSuchMethodException("main(String[]) method of " + clazz.getName() + " is not public and static.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] objectArray;
            PrintStream printStream = null;
            PrintStream printStream2 = null;
            String string = null;
            if (this.m_CommandArgs.length > 2 && (objectArray = this.m_CommandArgs[this.m_CommandArgs.length - 2]).equals(">")) {
                printStream = System.out;
                try {
                    string = this.m_CommandArgs[this.m_CommandArgs.length - 1];
                    printStream2 = new PrintStream(new File(string));
                    System.setOut(printStream2);
                    this.m_CommandArgs[this.m_CommandArgs.length - 2] = "";
                    this.m_CommandArgs[this.m_CommandArgs.length - 1] = "";
                }
                catch (Exception exception) {
                    System.setOut(printStream);
                    printStream = null;
                }
            }
            try {
                block10: {
                    try {
                        objectArray = new Object[]{this.m_CommandArgs};
                        this.m_MainMethod.invoke(null, objectArray);
                        if (!this.isInterrupted()) break block10;
                        System.err.println("[...Interrupted]");
                    }
                    catch (Exception exception) {
                        if (exception.getMessage() == null) {
                            System.err.println("[...Killed]");
                        } else {
                            System.err.println("[Run exception] " + exception.getMessage());
                        }
                        Object var7_8 = null;
                        SimpleCLIPanel.this.m_RunThread = null;
                    }
                }
                Object var7_7 = null;
                SimpleCLIPanel.this.m_RunThread = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                SimpleCLIPanel.this.m_RunThread = null;
                throw throwable;
            }
            if (printStream != null) {
                printStream2.flush();
                printStream2.close();
                System.setOut(printStream);
                System.out.println("Finished redirecting output to '" + string + "'.");
            }
        }
    }

    class ReaderToTextArea
    extends Thread {
        protected LineNumberReader m_Input;
        protected JTextArea m_Output;

        public ReaderToTextArea(Reader reader, JTextArea jTextArea) {
            this.setDaemon(true);
            this.m_Input = new LineNumberReader(reader);
            this.m_Output = jTextArea;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.m_Output.append(this.m_Input.readLine() + '\n');
                        this.m_Output.setCaretPosition(this.m_Output.getDocument().getLength());
                    }
                }
                catch (Exception exception) {
                    try {
                        ReaderToTextArea.sleep(100L);
                    }
                    catch (Exception exception2) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

