/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Check;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TestInstances;
import weka.core.Utils;

public abstract class CheckScheme
extends Check {
    protected int m_NumInstances = 20;
    protected int m_NumNominal = 2;
    protected int m_NumNumeric = 1;
    protected int m_NumString = 1;
    protected int m_NumDate = 1;
    protected int m_NumRelational = 1;
    protected int m_NumInstancesRelational = 10;
    protected String[] m_Words = TestInstances.DEFAULT_WORDS;
    protected String m_WordSeparators = " ";
    protected PostProcessor m_PostProcessor = null;
    protected boolean m_ClasspathProblems = false;

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe number of instances in the datasets (default 20).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tThe number of nominal attributes (default 2).", "nominal", 1, "-nominal <num>"));
        vector.addElement(new Option("\tThe number of values for nominal attributes (default 1).", "nominal-values", 1, "-nominal-values <num>"));
        vector.addElement(new Option("\tThe number of numeric attributes (default 1).", "numeric", 1, "-numeric <num>"));
        vector.addElement(new Option("\tThe number of string attributes (default 1).", "string", 1, "-string <num>"));
        vector.addElement(new Option("\tThe number of date attributes (default 1).", "date", 1, "-date <num>"));
        vector.addElement(new Option("\tThe number of relational attributes (default 1).", "relational", 1, "-relational <num>"));
        vector.addElement(new Option("\tThe number of instances in relational/bag attributes (default 10).", "num-instances-relational", 1, "-num-instances-relational <num>"));
        vector.addElement(new Option("\tThe words to use in string attributes.", "words", 1, "-words <comma-separated-list>"));
        vector.addElement(new Option("\tThe word separators to use in string attributes.", "word-separators", 1, "-word-separators <chars>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else {
            this.setNumInstances(20);
        }
        string = Utils.getOption("nominal", stringArray);
        if (string.length() != 0) {
            this.setNumNominal(Integer.parseInt(string));
        } else {
            this.setNumNominal(2);
        }
        string = Utils.getOption("numeric", stringArray);
        if (string.length() != 0) {
            this.setNumNumeric(Integer.parseInt(string));
        } else {
            this.setNumNumeric(1);
        }
        string = Utils.getOption("string", stringArray);
        if (string.length() != 0) {
            this.setNumString(Integer.parseInt(string));
        } else {
            this.setNumString(1);
        }
        string = Utils.getOption("date", stringArray);
        if (string.length() != 0) {
            this.setNumDate(Integer.parseInt(string));
        } else {
            this.setNumDate(1);
        }
        string = Utils.getOption("relational", stringArray);
        if (string.length() != 0) {
            this.setNumRelational(Integer.parseInt(string));
        } else {
            this.setNumRelational(1);
        }
        string = Utils.getOption("num-instances-relational", stringArray);
        if (string.length() != 0) {
            this.setNumInstancesRelational(Integer.parseInt(string));
        } else {
            this.setNumInstancesRelational(10);
        }
        string = Utils.getOption("words", stringArray);
        if (string.length() != 0) {
            this.setWords(string);
        } else {
            this.setWords(new TestInstances().getWords());
        }
        if (Utils.getOptionPos("word-separators", stringArray) > -1) {
            string = Utils.getOption("word-separators", stringArray);
            this.setWordSeparators(string);
        } else {
            this.setWordSeparators(" ");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-N");
        vector.add("" + this.getNumInstances());
        vector.add("-nominal");
        vector.add("" + this.getNumNominal());
        vector.add("-numeric");
        vector.add("" + this.getNumNumeric());
        vector.add("-string");
        vector.add("" + this.getNumString());
        vector.add("-date");
        vector.add("" + this.getNumDate());
        vector.add("-relational");
        vector.add("" + this.getNumRelational());
        vector.add("-words");
        vector.add("" + this.getWords());
        vector.add("-word-separators");
        vector.add("" + this.getWordSeparators());
        return vector.toArray(new String[vector.size()]);
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.m_PostProcessor = postProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public boolean hasClasspathProblems() {
        return this.m_ClasspathProblems;
    }

    public abstract void doTests();

    public void setNumInstances(int n) {
        this.m_NumInstances = n;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setNumNominal(int n) {
        this.m_NumNominal = n;
    }

    public int getNumNominal() {
        return this.m_NumNominal;
    }

    public void setNumNumeric(int n) {
        this.m_NumNumeric = n;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumString(int n) {
        this.m_NumString = n;
    }

    public int getNumString() {
        return this.m_NumString;
    }

    public void setNumDate(int n) {
        this.m_NumDate = n;
    }

    public int getNumDate() {
        return this.m_NumDate;
    }

    public void setNumRelational(int n) {
        this.m_NumRelational = n;
    }

    public int getNumRelational() {
        return this.m_NumRelational;
    }

    public void setNumInstancesRelational(int n) {
        this.m_NumInstancesRelational = n;
    }

    public int getNumInstancesRelational() {
        return this.m_NumInstancesRelational;
    }

    protected static String[] listToArray(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected static String arrayToList(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    public static String attributeTypeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "numeric";
                break;
            }
            case 1: {
                string = "nominal";
                break;
            }
            case 2: {
                string = "string";
                break;
            }
            case 3: {
                string = "date";
                break;
            }
            case 4: {
                string = "relational";
                break;
            }
            default: {
                string = "???";
            }
        }
        return string;
    }

    public void setWords(String string) {
        if (CheckScheme.listToArray(string).length < 2) {
            throw new IllegalArgumentException("At least 2 words must be provided!");
        }
        this.m_Words = CheckScheme.listToArray(string);
    }

    public String getWords() {
        return CheckScheme.arrayToList(this.m_Words);
    }

    public void setWordSeparators(String string) {
        this.m_WordSeparators = string;
    }

    public String getWordSeparators() {
        return this.m_WordSeparators;
    }

    protected void compareDatasets(Instances instances, Instances instances2) throws Exception {
        if (!instances2.equalHeaders(instances)) {
            throw new Exception("header has been modified");
        }
        if (instances2.numInstances() != instances.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Instance instance2 = instances2.instance(i);
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j) ? !instance2.isMissing(j) : instance.value(j) != instance2.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (instance.weight() == instance2.weight()) continue;
                throw new Exception("instance weights have changed");
            }
        }
    }

    protected void addMissing(Instances instances, int n, boolean bl, boolean bl2) {
        int n2 = instances.classIndex();
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if ((j != n2 || !bl2) && (j == n2 || !bl) || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances process(Instances instances) {
        if (this.getPostProcessor() == null) {
            return instances;
        }
        return this.getPostProcessor().process(instances);
    }

    public static class PostProcessor
    implements RevisionHandler {
        public Instances process(Instances instances) {
            return instances;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }
}

