/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class DiscreteDistribution
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 1954630934425689828L;
    private static final double TOLERANCE = Utils.SMALL;
    private double[] m_dd;

    public DiscreteDistribution(DiscreteEstimator discreteEstimator) {
        this.m_dd = new double[discreteEstimator.getNumSymbols()];
        for (int i = 0; i < this.m_dd.length; ++i) {
            this.m_dd[i] = discreteEstimator.getProbability(i);
        }
    }

    public DiscreteDistribution(CumulativeDiscreteDistribution cumulativeDiscreteDistribution) {
        this.m_dd = new double[cumulativeDiscreteDistribution.getNumSymbols()];
        if (this.m_dd.length != 0) {
            this.m_dd[0] = cumulativeDiscreteDistribution.getCumulativeProbability(0);
        }
        for (int i = 1; i < this.m_dd.length; ++i) {
            this.m_dd[i] = cumulativeDiscreteDistribution.getCumulativeProbability(i) - cumulativeDiscreteDistribution.getCumulativeProbability(i - 1);
        }
    }

    public DiscreteDistribution(double[] dArray) throws IllegalArgumentException {
        if (!DiscreteDistribution.validDiscreteDistribution(dArray)) {
            throw new IllegalArgumentException("Not a valid discrete distribution");
        }
        this.m_dd = new double[dArray.length];
        System.arraycopy(dArray, 0, this.m_dd, 0, dArray.length);
    }

    public int getNumSymbols() {
        return this.m_dd != null ? this.m_dd.length : 0;
    }

    public double getProbability(int n) {
        return this.m_dd[n];
    }

    public double mean() {
        double d = 0.0;
        for (int i = 1; i < this.m_dd.length; ++i) {
            d += (double)i * this.m_dd[i];
        }
        return d;
    }

    public double median() {
        double d = this.m_dd[this.m_dd.length - 1];
        int n = 0;
        for (double d2 = this.m_dd[0]; d2 < 0.5; d2 += this.m_dd[++n]) {
        }
        int n2 = this.m_dd.length - 1;
        while (d < 0.5) {
            d += this.m_dd[--n2];
        }
        return n == n2 ? (double)n : (double)(n + n2) / 2.0;
    }

    public int[] modes() {
        int[] nArray = new int[this.m_dd.length];
        double d = this.m_dd[0];
        int n = 1;
        for (int i = 1; i < this.m_dd.length; ++i) {
            if (this.m_dd[i] > d + TOLERANCE) {
                d = this.m_dd[i];
                nArray[0] = i;
                n = 1;
                continue;
            }
            if (!(Math.abs(this.m_dd[i] - d) < TOLERANCE)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public double[] toArray() {
        double[] dArray = new double[this.m_dd.length];
        System.arraycopy(this.m_dd, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public String toString() {
        String string = "[" + this.getNumSymbols() + "]:";
        for (int i = 0; i < this.getNumSymbols(); ++i) {
            string = string + " " + this.getProbability(i);
        }
        return string;
    }

    public boolean stochasticDominatedBy(DiscreteDistribution discreteDistribution) throws IllegalArgumentException {
        return new CumulativeDiscreteDistribution(this).stochasticDominatedBy(new CumulativeDiscreteDistribution(discreteDistribution));
    }

    private static boolean validDiscreteDistribution(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return false;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < 0.0) {
                return false;
            }
            d += dArray[i];
        }
        return !(Math.abs(d - 1.0) > TOLERANCE);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

