/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class LBR
extends Classifier
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5648559277738985156L;
    protected int[][][] m_Counts;
    protected int[][][] m_tCounts;
    protected int[] m_Priors;
    protected int[] m_tPriors;
    protected int m_numAtts;
    protected int m_numClasses;
    protected int m_numInsts;
    protected Instances m_Instances = null;
    protected int m_Errors;
    protected boolean[] m_ErrorFlags;
    protected ArrayList leftHand = new ArrayList();
    protected static final double SIGNLOWER = 0.05;
    protected boolean[] m_subOldErrorFlags;
    protected int m_RemainderErrors = 0;
    protected int m_Number = 0;
    protected int m_NumberOfInstances = 0;
    protected boolean m_NCV = false;
    protected Indexes m_subInstances;
    protected Indexes tempSubInstances;
    protected double[] posteriorsArray;
    protected int bestCnt;
    protected int tempCnt;
    protected int forCnt;
    protected int whileCnt;

    public String globalInfo() {
        return "Lazy Bayesian Rules Classifier. The naive Bayesian classifier provides a simple and effective approach to classifier learning, but its attribute independence assumption is often violated in the real world. Lazy Bayesian Rules selectively relaxes the independence assumption, achieving lower error rates over a range of learning tasks. LBR defers processing to classification time, making it a highly efficient and accurate classification algorithm when small numbers of objects are to be classified.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Zijian Zheng and G. Webb");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Lazy Learning of Bayesian Rules");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "4");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "1");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "53-84");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Copyable copyable;
        int n;
        this.bestCnt = 0;
        this.tempCnt = 0;
        this.forCnt = 0;
        this.whileCnt = 0;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_numAtts = instances.numAttributes();
        this.m_numClasses = instances.numClasses();
        this.m_numInsts = instances.numInstances();
        this.m_Counts = new int[this.m_numClasses][this.m_numAtts][0];
        this.m_Priors = new int[this.m_numClasses];
        this.m_tCounts = new int[this.m_numClasses][this.m_numAtts][0];
        this.m_tPriors = new int[this.m_numClasses];
        this.m_subOldErrorFlags = new boolean[this.m_numInsts + 1];
        this.m_Instances = instances;
        this.m_subInstances = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        this.tempSubInstances = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        this.posteriorsArray = new double[this.m_numClasses];
        for (n = 0; n < this.m_numAtts; ++n) {
            copyable = instances.attribute(n);
            for (int i = 0; i < this.m_numClasses; ++i) {
                this.m_Counts[i][n] = new int[((Attribute)copyable).numValues()];
                this.m_tCounts[i][n] = new int[((Attribute)copyable).numValues()];
            }
        }
        for (int i = 0; i < this.m_numInsts; ++i) {
            copyable = instances.instance(i);
            int n2 = (int)((Instance)copyable).classValue();
            int[][] nArray = this.m_tCounts[n2];
            for (n = 0; n < this.m_numAtts; ++n) {
                int[] nArray2 = nArray[n];
                int n3 = (int)((Instance)copyable).value(n);
                nArray2[n3] = nArray2[n3] + 1;
            }
            int n4 = n2;
            this.m_tPriors[n4] = this.m_tPriors[n4] + 1;
        }
        this.m_ErrorFlags = new boolean[this.m_numInsts];
        this.m_Errors = this.leaveOneOut(this.m_subInstances, this.m_tCounts, this.m_tPriors, this.m_ErrorFlags);
        if (this.m_Number == 0) {
            this.m_NumberOfInstances = this.m_Instances.numInstances();
        } else {
            System.out.println(" ");
            System.out.println("N-Fold Cross Validation: ");
            this.m_NCV = true;
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean[] blArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        Indexes indexes = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        boolean[] blArray2 = new boolean[indexes.getNumInstances() + 1];
        int n6 = this.m_Errors;
        boolean[] blArray3 = (boolean[])this.m_ErrorFlags.clone();
        int n7 = 0;
        int n8 = 0;
        this.leftHand.clear();
        while (n6 >= 5) {
            int n9 = -1;
            ++this.whileCnt;
            n5 = indexes.getNumInstancesSet() + 1;
            indexes.setSequentialDataset(true);
            for (int i = 0; i < indexes.m_NumSeqAttsSet; ++i) {
                int n10;
                ++this.forCnt;
                n = indexes.m_SequentialAttIndexes[i];
                this.m_RemainderErrors = 0;
                for (n10 = 0; n10 < this.m_numInsts; ++n10) {
                    this.m_subOldErrorFlags[n10] = true;
                }
                this.tempSubInstances.resetDatasetBasedOn(indexes);
                for (int j = 0; j < indexes.m_NumSeqInstsSet; ++j) {
                    n2 = indexes.m_SequentialInstIndexes[j];
                    if (this.m_Instances.instance(n2).value(n) == instance.value(n)) {
                        this.tempSubInstances.setInstanceIndex(n2, true);
                        if (blArray3[n2]) continue;
                        this.m_subOldErrorFlags[n2] = false;
                        continue;
                    }
                    if (blArray3[n2]) continue;
                    ++this.m_RemainderErrors;
                }
                if (this.tempSubInstances.m_NumInstsSet >= indexes.m_NumInstsSet) continue;
                this.tempSubInstances.setAttIndex(n, false);
                this.localNaiveBayes(this.tempSubInstances);
                n4 = this.leaveOneOut(this.tempSubInstances, this.m_Counts, this.m_Priors, blArray2);
                n7 = 0;
                n8 = 0;
                this.tempSubInstances.setSequentialDataset(true);
                for (n10 = 0; n10 < this.tempSubInstances.m_NumSeqInstsSet; ++n10) {
                    n3 = this.tempSubInstances.m_SequentialInstIndexes[n10];
                    if (!blArray2[n3]) {
                        if (!this.m_subOldErrorFlags[n3]) continue;
                        ++n7;
                        continue;
                    }
                    if (this.m_subOldErrorFlags[n3]) continue;
                    ++n8;
                }
                n10 = n4 + this.m_RemainderErrors;
                if (n10 >= n5 || !(this.binomP(n7, n7 + n8, 0.5) < 0.05)) continue;
                ++this.tempCnt;
                this.tempSubInstances.setSequentialDataset(true);
                nArray = (int[])this.tempSubInstances.m_SequentialInstIndexes.clone();
                nArray2 = (int[])this.tempSubInstances.m_SequentialAttIndexes.clone();
                n5 = n10;
                blArray = (boolean[])blArray2.clone();
                n9 = n;
            }
            if (n9 == -1) break;
            ++this.bestCnt;
            this.leftHand.add(instance.attribute(n9));
            indexes.setInsts(nArray, true);
            indexes.setAtts(nArray2, true);
            indexes.setAttIndex(n9, false);
            n6 = n5;
            blArray3 = blArray;
        }
        this.localNaiveBayes(indexes);
        return this.localDistributionForInstance(instance, indexes);
    }

    public String toString() {
        if (this.m_Instances == null) {
            return "Lazy Bayesian Rule: No model built yet.";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("=== LBR Run information ===\n\n");
            stringBuffer.append("Scheme:       weka.classifiers.LBR\n");
            stringBuffer.append("Relation:     " + this.m_Instances.attribute(this.m_Instances.classIndex()).name() + "\n");
            stringBuffer.append("Instances:    " + this.m_Instances.numInstances() + "\n");
            stringBuffer.append("Attributes:   " + this.m_Instances.numAttributes() + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Can't Print Lazy Bayes Rule Classifier!";
        }
    }

    public int leaveOneOut(Indexes indexes, int[][][] nArray, int[] nArray2, boolean[] blArray) throws Exception {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        indexes.setSequentialDataset(true);
        int[] nArray3 = new int[indexes.m_NumSeqAttsSet + 1];
        for (int i = 0; i < indexes.m_NumSeqInstsSet; ++i) {
            int n3;
            int n4;
            int n5 = indexes.m_SequentialInstIndexes[i];
            Instance instance = this.m_Instances.instance(n5);
            if (instance.classIsMissing()) continue;
            int n6 = (int)instance.classValue();
            int[][] nArray4 = nArray[n6];
            for (n4 = 0; n4 < indexes.m_NumSeqAttsSet; ++n4) {
                n3 = indexes.m_SequentialAttIndexes[n4];
                nArray3[n4] = (int)instance.value(n3);
                int[] nArray5 = nArray4[n3];
                int n7 = nArray3[n4];
                nArray5[n7] = nArray5[n7] - 1;
            }
            int n8 = n6;
            nArray2[n8] = nArray2[n8] - 1;
            d = 0.0;
            n = 0;
            double d2 = Utils.sum(nArray2);
            for (int j = 0; j < this.m_numClasses; ++j) {
                double d3 = 0.0;
                d3 = (double)(nArray2[j] + 1) / (d2 + (double)this.m_numClasses);
                nArray4 = nArray[j];
                for (n4 = 0; n4 < indexes.m_NumSeqAttsSet; ++n4) {
                    n3 = indexes.m_SequentialAttIndexes[n4];
                    if (instance.isMissing(n3)) continue;
                    double d4 = Utils.sum(nArray4[n3]);
                    d3 *= (double)(nArray4[n3][nArray3[n4]] + 1) / (d4 + (double)instance.attribute(n3).numValues());
                }
                if (!(d3 > d)) continue;
                n = j;
                d = d3;
            }
            int n9 = d > 0.0 ? n : (int)Instance.missingValue();
            if (n9 == n6) {
                blArray[n5] = true;
            } else {
                blArray[n5] = false;
                ++n2;
            }
            nArray4 = nArray[n6];
            for (n4 = 0; n4 < indexes.m_NumSeqAttsSet; ++n4) {
                n3 = indexes.m_SequentialAttIndexes[n4];
                int[] nArray6 = nArray[n6][n3];
                int n10 = nArray3[n4];
                nArray6[n10] = nArray6[n10] + 1;
            }
            int n11 = n6;
            nArray2[n11] = nArray2[n11] + 1;
        }
        return n2;
    }

    public void localNaiveBayes(Indexes indexes) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        indexes.setSequentialDataset(true);
        for (n3 = 0; n3 < this.m_numClasses; ++n3) {
            int[][] nArray = this.m_Counts[n3];
            for (n = 0; n < this.m_numAtts; ++n) {
                Attribute attribute = this.m_Instances.attribute(n);
                int[] nArray2 = nArray[n];
                for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                    nArray2[n2] = 0;
                }
            }
            this.m_Priors[n3] = 0;
        }
        for (int i = 0; i < indexes.m_NumSeqInstsSet; ++i) {
            Instance instance = this.m_Instances.instance(indexes.m_SequentialInstIndexes[i]);
            for (n = 0; n < indexes.m_NumSeqAttsSet; ++n) {
                int n4 = indexes.m_SequentialAttIndexes[n];
                int[] nArray = this.m_Counts[(int)instance.classValue()][n4];
                int n5 = (int)instance.value(n4);
                nArray[n5] = nArray[n5] + 1;
            }
            int n6 = (int)instance.classValue();
            this.m_Priors[n6] = this.m_Priors[n6] + 1;
        }
    }

    public double[] localDistributionForInstance(Instance instance, Indexes indexes) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        int n = instance.numClasses();
        d = 0.0;
        d2 = 0.0;
        indexes.setSequentialDataset(true);
        d = Utils.sum(this.m_Priors) + n;
        for (int i = 0; i < n; ++i) {
            int[][] nArray = this.m_Counts[i];
            this.posteriorsArray[i] = (double)(this.m_Priors[i] + 1) / d;
            for (int j = 0; j < indexes.m_NumSeqAttsSet; ++j) {
                int n2 = indexes.m_SequentialAttIndexes[j];
                d2 = Utils.sum(nArray[n2]);
                if (instance.isMissing(n2)) continue;
                int n3 = i;
                this.posteriorsArray[n3] = this.posteriorsArray[n3] * ((double)(nArray[n2][(int)instance.value(n2)] + 1) / (d2 + (double)instance.attribute(n2).numValues()));
            }
        }
        Utils.normalize(this.posteriorsArray);
        return this.posteriorsArray;
    }

    public double binomP(double d, double d2, double d3) throws Exception {
        if (d2 == d) {
            return 1.0;
        }
        return Statistics.incompleteBeta(d2 - d, d + 1.0, 1.0 - d3);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.12 $");
    }

    public static void main(String[] stringArray) {
        LBR.runClassifier(new LBR(), stringArray);
    }

    public class Indexes
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -2771490019751421307L;
        public boolean[] m_InstIndexes;
        public boolean[] m_AttIndexes;
        private int m_NumInstances;
        private int m_NumAtts;
        public int[] m_SequentialInstIndexes;
        public int[] m_SequentialAttIndexes;
        private boolean m_SequentialInstanceIndex_valid = false;
        private boolean m_SequentialAttIndex_valid = false;
        public int m_NumInstsSet;
        public int m_NumAttsSet;
        public int m_NumSeqInstsSet;
        public int m_NumSeqAttsSet;
        public int m_ClassIndex;

        public Indexes(int n, int n2, boolean bl, int n3) {
            int n4;
            this.m_NumInstsSet = this.m_NumInstances = n;
            this.m_NumAttsSet = this.m_NumAtts = n2;
            this.m_InstIndexes = new boolean[n];
            for (n4 = 0; n4 < n; ++n4) {
                this.m_InstIndexes[n4] = bl;
            }
            this.m_AttIndexes = new boolean[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                this.m_AttIndexes[n4] = true;
            }
            if (!bl) {
                this.m_NumInstsSet = 0;
            }
            this.m_SequentialInstanceIndex_valid = false;
            this.m_SequentialAttIndex_valid = false;
            if (n3 != -1) {
                this.setAttIndex(n3, false);
            }
            this.m_ClassIndex = n3;
        }

        public Indexes(Indexes indexes) {
            this.m_NumInstances = indexes.getNumInstances();
            this.m_NumInstsSet = indexes.m_NumInstsSet;
            this.m_NumAtts = indexes.m_NumAtts;
            this.m_NumAttsSet = indexes.m_NumAttsSet;
            this.m_InstIndexes = new boolean[this.m_NumInstances];
            System.arraycopy(indexes.m_InstIndexes, 0, this.m_InstIndexes, 0, this.m_NumInstances);
            this.m_AttIndexes = new boolean[this.m_NumAtts];
            System.arraycopy(indexes.m_AttIndexes, 0, this.m_AttIndexes, 0, this.m_NumAtts);
            this.m_ClassIndex = indexes.m_ClassIndex;
            this.m_SequentialInstanceIndex_valid = false;
            this.m_SequentialAttIndex_valid = false;
        }

        public void setInstanceIndex(int n, boolean bl) {
            if (n < 0 || n >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid Instance Index value");
            }
            if (this.m_InstIndexes[n] != bl) {
                this.m_InstIndexes[n] = bl;
                this.m_SequentialInstanceIndex_valid = false;
                this.m_NumInstsSet = !bl ? --this.m_NumInstsSet : ++this.m_NumInstsSet;
            }
        }

        public void setAtts(int[] nArray, boolean bl) {
            int n;
            for (n = 0; n < this.m_NumAtts; ++n) {
                this.m_AttIndexes[n] = !bl;
            }
            for (n = 0; n < nArray.length; ++n) {
                this.m_AttIndexes[nArray[n]] = bl;
            }
            this.m_NumAttsSet = nArray.length;
            this.m_SequentialAttIndex_valid = false;
        }

        public void setInsts(int[] nArray, boolean bl) {
            this.resetInstanceIndex(!bl);
            for (int i = 0; i < nArray.length; ++i) {
                this.m_InstIndexes[nArray[i]] = bl;
            }
            this.m_NumInstsSet = nArray.length;
            this.m_SequentialInstanceIndex_valid = false;
        }

        public void setAttIndex(int n, boolean bl) {
            if (n < 0 || n >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid Attribute Index value");
            }
            if (this.m_AttIndexes[n] != bl) {
                this.m_AttIndexes[n] = bl;
                this.m_SequentialAttIndex_valid = false;
                this.m_NumAttsSet = !bl ? --this.m_NumAttsSet : ++this.m_NumAttsSet;
            }
        }

        public boolean getInstanceIndex(int n) {
            if (n < 0 || n >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_InstIndexes[n];
        }

        public int getSequentialInstanceIndex(int n) {
            if (n < 0 || n >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_SequentialInstIndexes[n];
        }

        public void resetInstanceIndex(boolean bl) {
            this.m_NumInstsSet = this.m_NumInstances;
            for (int i = 0; i < this.m_NumInstances; ++i) {
                this.m_InstIndexes[i] = bl;
            }
            if (!bl) {
                this.m_NumInstsSet = 0;
            }
            this.m_SequentialInstanceIndex_valid = false;
        }

        public void resetDatasetBasedOn(Indexes indexes) {
            this.resetInstanceIndex(false);
            this.resetAttIndexTo(indexes);
        }

        public void resetAttIndex(boolean bl) {
            this.m_NumAttsSet = this.m_NumAtts;
            for (int i = 0; i < this.m_NumAtts; ++i) {
                this.m_AttIndexes[i] = bl;
            }
            if (this.m_ClassIndex != -1) {
                this.setAttIndex(this.m_ClassIndex, false);
            }
            if (!bl) {
                this.m_NumAttsSet = 0;
            }
            this.m_SequentialAttIndex_valid = false;
        }

        public void resetAttIndexTo(Indexes indexes) {
            System.arraycopy(indexes.m_AttIndexes, 0, this.m_AttIndexes, 0, this.m_NumAtts);
            this.m_NumAttsSet = indexes.getNumAttributesSet();
            this.m_ClassIndex = indexes.m_ClassIndex;
            this.m_SequentialAttIndex_valid = false;
        }

        public boolean getAttIndex(int n) {
            if (n < 0 || n >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_AttIndexes[n];
        }

        public int getSequentialAttIndex(int n) {
            if (n < 0 || n >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_SequentialAttIndexes[n];
        }

        public int getNumInstancesSet() {
            return this.m_NumInstsSet;
        }

        public int getNumInstances() {
            return this.m_NumInstances;
        }

        public int getSequentialNumInstances() {
            return this.m_NumSeqInstsSet;
        }

        public int getNumAttributes() {
            return this.m_NumAtts;
        }

        public int getNumAttributesSet() {
            return this.m_NumAttsSet;
        }

        public int getSequentialNumAttributes() {
            return this.m_NumSeqAttsSet;
        }

        public boolean isSequentialInstanceIndexValid() {
            return this.m_SequentialInstanceIndex_valid;
        }

        public boolean isSequentialAttIndexValid() {
            return this.m_SequentialAttIndex_valid;
        }

        public void setSequentialDataset(boolean bl) {
            this.setSequentialInstanceIndex(bl);
            this.setSequentialAttIndex(bl);
        }

        public void setSequentialInstanceIndex(boolean bl) {
            if (this.m_SequentialInstanceIndex_valid) {
                return;
            }
            int n = this.m_NumInstsSet;
            this.m_SequentialInstIndexes = new int[n];
            int n2 = 0;
            for (int i = 0; i < this.m_NumInstances; ++i) {
                if (this.m_InstIndexes[i] != bl) continue;
                this.m_SequentialInstIndexes[n2] = i;
                ++n2;
            }
            this.m_SequentialInstanceIndex_valid = true;
            this.m_NumSeqInstsSet = n2;
        }

        public void setSequentialAttIndex(boolean bl) {
            if (this.m_SequentialAttIndex_valid) {
                return;
            }
            int n = this.m_NumAttsSet;
            this.m_SequentialAttIndexes = new int[n];
            int n2 = 0;
            for (int i = 0; i < this.m_NumAtts; ++i) {
                if (this.m_AttIndexes[i] != bl) continue;
                this.m_SequentialAttIndexes[n2] = i;
                ++n2;
            }
            this.m_SequentialAttIndex_valid = true;
            this.m_NumSeqAttsSet = n2;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.12 $");
        }
    }
}

