/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.CheckScheme;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClassifier
extends CheckScheme {
    protected Classifier m_Classifier = new ZeroR();

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull name of the classifier analysed.\n\teg: weka.classifiers.bayes.NaiveBayes\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration2 = this.m_Classifier.listOptions();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = ZeroR.class.getName();
        }
        this.setClassifier((Classifier)this.forName("weka.classifiers", Classifier.class, string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getClassifier() != null) {
            vector.add("-W");
            vector.add(this.getClassifier().getClass().getName());
        }
        if ((stringArray = this.m_Classifier != null && this.m_Classifier instanceof OptionHandler ? this.m_Classifier.getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void doTests() {
        if (this.getClassifier() == null) {
            this.println("\n=== No classifier set ===");
            return;
        }
        this.println("\n=== Check on Classifier: " + this.getClassifier().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean bl = this.updateableClassifier()[0];
        boolean bl2 = this.weightedInstancesHandler()[0];
        boolean bl3 = this.multiInstanceHandler()[0];
        this.println("--> Classifier tests");
        this.declaresSerialVersionUID();
        this.testToString();
        this.testsPerClassType(1, bl, bl2, bl3);
        this.testsPerClassType(0, bl, bl2, bl3);
        this.testsPerClassType(3, bl, bl2, bl3);
        this.testsPerClassType(2, bl, bl2, bl3);
        this.testsPerClassType(4, bl, bl2, bl3);
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected void testsPerClassType(int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.canPredict(true, false, false, false, false, bl3, n)[0];
        boolean bl5 = this.canPredict(false, true, false, false, false, bl3, n)[0];
        boolean bl6 = this.canPredict(false, false, true, false, false, bl3, n)[0];
        boolean bl7 = this.canPredict(false, false, false, true, false, bl3, n)[0];
        boolean bl8 = !bl3 ? this.canPredict(false, false, false, false, true, bl3, n)[0] : false;
        if (bl4 || bl5 || bl6 || bl7 || bl8) {
            boolean bl9;
            if (bl2) {
                this.instanceWeights(bl4, bl5, bl6, bl7, bl8, bl3, n);
            }
            this.canHandleOnlyClass(bl4, bl5, bl6, bl7, bl8, n);
            if (n == 1) {
                this.canHandleNClasses(bl4, bl5, bl6, bl7, bl8, bl3, 4);
            }
            if (!bl3) {
                this.canHandleClassAsNthAttribute(bl4, bl5, bl6, bl7, bl8, bl3, n, 0);
                this.canHandleClassAsNthAttribute(bl4, bl5, bl6, bl7, bl8, bl3, n, 1);
            }
            this.canHandleZeroTraining(bl4, bl5, bl6, bl7, bl8, bl3, n);
            boolean bl10 = this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl3, n, true, false, 20)[0];
            if (bl10) {
                this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl3, n, true, false, 100);
            }
            if (bl9 = this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl3, n, false, true, 20)[0]) {
                this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl3, n, false, true, 100);
            }
            this.correctBuildInitialisation(bl4, bl5, bl6, bl7, bl8, bl3, n);
            this.datasetIntegrity(bl4, bl5, bl6, bl7, bl8, bl3, n, bl10, bl9);
            this.doesntUseTestClassVal(bl4, bl5, bl6, bl7, bl8, bl3, n);
            if (bl) {
                this.updatingEquality(bl4, bl5, bl6, bl7, bl8, bl3, n);
            }
        }
    }

    protected boolean[] testToString() {
        boolean[] blArray;
        block2: {
            blArray = new boolean[2];
            this.print("toString...");
            try {
                Classifier classifier = (Classifier)this.m_Classifier.getClass().newInstance();
                classifier.toString();
                blArray[0] = true;
                this.println("yes");
            }
            catch (Exception exception) {
                blArray[0] = false;
                this.println("no");
                if (!this.m_Debug) break block2;
                this.println("\n=== Full report ===");
                exception.printStackTrace();
                this.println("\n");
            }
        }
        return blArray;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] blArray = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = blArray[0] = !SerializationHelper.needsUID(this.m_Classifier.getClass());
        if (blArray[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return blArray;
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Classifier instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = this.m_Classifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] updateableClassifier() {
        boolean[] blArray = new boolean[2];
        this.print("updateable classifier...");
        if (this.m_Classifier instanceof UpdateableClassifier) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances classifier...");
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] blArray = new boolean[2];
        this.print("multi-instance classifier...");
        if (this.m_Classifier instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] canPredict(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("unary");
        fastVector.addElement("binary");
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("date");
        fastVector.addElement("relational");
        fastVector.addElement("multi-instance");
        fastVector.addElement("not in classpath");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n5, bl7, bl8, n2, n3, n4, fastVector);
    }

    protected boolean[] canHandleOnlyClass(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        this.print("only class in data");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, false, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("class");
        fastVector.addElement("zeror");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        return this.runBasicTest(false, false, false, false, false, false, n, n4, bl6, bl7, n2, n3, 2, fastVector);
    }

    protected boolean[] canHandleNClasses(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("more than two class problems");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, 1);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("number");
        fastVector.addElement("class");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, 1, n4, bl7, bl8, n2, n3, n, fastVector);
    }

    protected boolean[] canHandleClassAsNthAttribute(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2) {
        if (n2 == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (n2 + 1) + ". attribute");
        }
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        int n3 = this.getNumInstances();
        int n4 = this.getNumInstances();
        int n5 = 2;
        int n6 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n2, n6, bl7, bl8, n3, n4, n5, fastVector);
    }

    protected boolean[] canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n2 = 0;
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n5, bl7, bl8, n2, n3, n4, fastVector);
    }

    protected boolean[] correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        boolean[] blArray;
        block20: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildClassifier");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            Instances instances = null;
            Instances instances2 = null;
            Instances instances3 = null;
            Instances instances4 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            Evaluation evaluation2 = null;
            Evaluation evaluation3 = null;
            boolean bl9 = false;
            int n6 = 0;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances3 = this.makeTestDataset(84, n2, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances2 = this.makeTestDataset(24, n3, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances4 = this.makeTestDataset(48, n3, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl7, bl8);
                    this.addMissing(instances2, Math.min(n5, 50), bl7, bl8);
                    this.addMissing(instances3, n5, bl7, bl8);
                    this.addMissing(instances4, Math.min(n5, 50), bl7, bl8);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
                evaluation2 = new Evaluation(instances);
                evaluation3 = new Evaluation(instances3);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n6 = 0;
                classifier.buildClassifier(instances);
                bl9 = true;
                if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n6 = 1;
                bl9 = false;
                classifier.buildClassifier(instances3);
                bl9 = true;
                if (!this.testWRTZeroR(classifier, evaluation3, instances3, instances4)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n6 = 2;
                bl9 = false;
                classifier.buildClassifier(instances);
                bl9 = true;
                if (!this.testWRTZeroR(classifier, evaluation2, instances, instances2)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n6 = 3;
                if (!evaluation.equals(evaluation2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n" + evaluation.toSummaryString("\nFirst buildClassifier()", true) + "\n\n");
                        this.println(evaluation2.toSummaryString("\nSecond buildClassifier()", true) + "\n\n");
                    }
                    throw new Exception("Results differ between buildClassifier calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                String string = exception.getMessage().toLowerCase();
                if (string.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    blArray[0] = n6 < 1;
                    blArray[1] = n6 < 1;
                } else {
                    this.println("no");
                    blArray[0] = false;
                }
                if (!this.m_Debug) break block20;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl9) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (n6) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + instances3.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + instances4.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        if (n2 == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl7) {
            this.print(" predictor");
            if (bl8) {
                this.print(" and");
            }
        }
        if (bl8) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n3 = this.getNumInstances();
        int n4 = this.getNumInstances();
        int n5 = 2;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n2, bl7, bl8, n3, n4, n5, fastVector);
    }

    protected boolean[] updatingEquality(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean[] blArray = new boolean[2];
        Instances instances = null;
        Instances instances2 = null;
        Classifier[] classifierArray = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        boolean bl9 = false;
        try {
            instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
            instances2 = this.makeTestDataset(24, n3, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
            if (n5 > 0) {
                this.addMissing(instances, n5, bl7, bl8);
                this.addMissing(instances2, Math.min(n5, 50), bl7, bl8);
            }
            classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            classifierArray[0].buildClassifier(instances);
            this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            classifierArray[1].buildClassifier(new Instances(instances, 0));
            for (int i = 0; i < instances.numInstances(); ++i) {
                ((UpdateableClassifier)((Object)classifierArray[1])).updateClassifier(instances.instance(i));
            }
            bl9 = true;
            this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
            if (!evaluation.equals(evaluation2)) {
                this.println("no");
                blArray[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    this.println("Here are the results:\n");
                    this.println(evaluation.toSummaryString("\nbatch built results\n", true));
                    this.println(evaluation2.toSummaryString("\nincrementally built results\n", true));
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                }
            } else {
                this.println("yes");
                blArray[0] = true;
            }
        }
        catch (Exception exception) {
            blArray[0] = false;
            this.print("Problem during");
            if (bl9) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + exception.getMessage() + "\n");
        }
        return blArray;
    }

    protected boolean[] doesntUseTestClassVal(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        boolean[] blArray;
        block11: {
            this.print("classifier ignores test instance class vals");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = 2 * this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier[] classifierArray = null;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances2 = this.makeTestDataset(24, n3, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl7, bl8);
                    this.addMissing(instances2, Math.min(n5, 50), bl7, bl8);
                }
                classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
                classifierArray[0].buildClassifier(instances);
                classifierArray[1].buildClassifier(instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances2.numInstances(); ++i) {
                    Instance instance = instances2.instance(i);
                    Instance instance2 = (Instance)instance.copy();
                    instance2.setDataset(instances2);
                    instance2.setClassMissing();
                    double[] dArray = classifierArray[0].distributionForInstance(instance);
                    double[] dArray2 = classifierArray[1].distributionForInstance(instance2);
                    for (int j = 0; j < dArray.length; ++j) {
                        if (Double.isNaN(dArray[j]) && Double.isNaN(dArray2[j])) {
                            if (!this.getDebug()) continue;
                            System.out.println("Both predictions are NaN!");
                            continue;
                        }
                        if (dArray[j] == dArray2[j]) continue;
                        throw new Exception("Prediction different for instance " + (i + 1));
                    }
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (bl9) {
                    this.println("Results differ between non-missing and missing test class values.");
                } else {
                    this.print("Problem during testing");
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] instanceWeights(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        boolean[] blArray;
        block13: {
            this.print("classifier uses instance weights");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = 2 * this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier[] classifierArray = null;
            Evaluation evaluation = null;
            Evaluation evaluation2 = null;
            boolean bl9 = false;
            boolean bl10 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances2 = this.makeTestDataset(24, n3, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl7, bl8);
                    this.addMissing(instances2, Math.min(n5, 50), bl7, bl8);
                }
                classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
                evaluation = new Evaluation(instances);
                evaluation2 = new Evaluation(instances);
                classifierArray[0].buildClassifier(instances);
                this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n6 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n7 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n6).setWeight(n7);
                }
                classifierArray[1].buildClassifier(instances);
                bl9 = true;
                this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
                if (evaluation.equals(evaluation2)) {
                    bl10 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                if (bl10) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(evaluation.toSummaryString("\nboth methods\n", true));
                } else {
                    this.print("Problem during");
                    if (bl9) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        boolean[] blArray;
        block7: {
            this.print("classifier doesn't alter original datasets");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 20;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                instances2 = this.makeTestDataset(24, n3, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n4, n, bl6);
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl7, bl8);
                    this.addMissing(instances2, Math.min(n5, 50), bl7, bl8);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances3 = new Instances(instances);
                Instances instances4 = new Instances(instances2);
                classifier.buildClassifier(instances3);
                this.compareDatasets(instances, instances3);
                bl9 = true;
                this.testWRTZeroR(classifier, evaluation, instances3, instances4);
                this.compareDatasets(instances2, instances4);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block7;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl9) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, boolean bl7, boolean bl8, int n3, int n4, int n5, FastVector fastVector) {
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, -1, n2, bl7, bl8, n3, n4, n5, fastVector);
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, int n3, boolean bl7, boolean bl8, int n4, int n5, int n6, FastVector fastVector) {
        boolean[] blArray;
        block15: {
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n4, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n6, n, n2, bl6);
                instances2 = this.makeTestDataset(24, n5, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n6, n, n2, bl6);
                if (n3 > 0) {
                    this.addMissing(instances, n3, bl7, bl8);
                    this.addMissing(instances2, Math.min(n3, 50), bl7, bl8);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                classifier.buildClassifier(instances);
                bl9 = true;
                if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)[0]) {
                    blArray[0] = true;
                    blArray[1] = true;
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n7;
                boolean bl10 = false;
                String string = exception.getMessage() == null ? "" : exception.getMessage().toLowerCase();
                if (string.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                if (string.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    blArray[0] = true;
                    blArray[1] = true;
                } else {
                    for (n7 = 0; n7 < fastVector.size(); ++n7) {
                        if (string.indexOf((String)fastVector.elementAt(n7)) < 0) continue;
                        bl10 = true;
                    }
                    this.println("no" + (bl10 ? " (OK error message)" : ""));
                    blArray[1] = bl10;
                }
                if (!this.m_Debug) break block15;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl9) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                if (bl10) break block15;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n7 = 0; n7 < fastVector.size(); ++n7) {
                        if (n7 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n7) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] testWRTZeroR(Classifier classifier, Evaluation evaluation, Instances instances, Instances instances2) throws Exception {
        boolean[] blArray = new boolean[2];
        evaluation.evaluateModel(classifier, instances2, new Object[0]);
        try {
            ZeroR zeroR = new ZeroR();
            ((Classifier)zeroR).buildClassifier(instances);
            Evaluation evaluation2 = new Evaluation(instances);
            evaluation2.evaluateModel(zeroR, instances2, new Object[0]);
            blArray[0] = Utils.grOrEq(evaluation2.errorRate(), evaluation.errorRate());
        }
        catch (Exception exception) {
            throw new Error("Problem determining ZeroR performance: " + exception.getMessage());
        }
        return blArray;
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) throws Exception {
        return this.makeTestDataset(n, n2, n3, n4, n5, n6, n7, n8, n9, -1, bl);
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) throws Exception {
        TestInstances testInstances = new TestInstances();
        testInstances.setSeed(n);
        testInstances.setNumInstances(n2);
        testInstances.setNumNominal(n3);
        testInstances.setNumNumeric(n4);
        testInstances.setNumString(n5);
        testInstances.setNumDate(n6);
        testInstances.setNumRelational(n7);
        testInstances.setNumClasses(n8);
        testInstances.setClassType(n9);
        testInstances.setClassIndex(n10);
        testInstances.setNumClasses(n8);
        testInstances.setMultiInstance(bl);
        testInstances.setWords(this.getWords());
        testInstances.setWordSeparators(this.getWordSeparators());
        return this.process(testInstances.generate());
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        String string = "";
        if (bl2) {
            string = string + " numeric";
        }
        if (bl) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " nominal";
        }
        if (bl3) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " string";
        }
        if (bl4) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " date";
        }
        if (bl5) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " relational";
        }
        string = string + " predictors)";
        switch (n) {
            case 0: {
                string = " (numeric class," + string;
                break;
            }
            case 1: {
                string = " (nominal class," + string;
                break;
            }
            case 2: {
                string = " (string class," + string;
                break;
            }
            case 3: {
                string = " (date class," + string;
                break;
            }
            case 4: {
                string = " (relational class," + string;
            }
        }
        this.print(string);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.33 $");
    }

    public static void main(String[] stringArray) {
        CheckClassifier.runCheck(new CheckClassifier(), stringArray);
    }
}

