/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataVisualizer;

public class AttributeSummarizer
extends DataVisualizer {
    private static final long serialVersionUID = -294354961169372758L;
    protected int m_gridWidth = 4;
    protected int m_maxPlots = 100;
    protected int m_coloringIndex = -1;

    public AttributeSummarizer() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!graphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    public String globalInfo() {
        return "Plot summary bar charts for incoming data/training/test sets.";
    }

    public void setColoringIndex(int n) {
        this.m_coloringIndex = n;
    }

    public int getColoringIndex() {
        return this.m_coloringIndex;
    }

    public void setGridWidth(int n) {
        if (n > 0) {
            this.m_bcSupport.firePropertyChange("gridWidth", new Integer(this.m_gridWidth), new Integer(n));
            this.m_gridWidth = n;
        }
    }

    public int getGridWidth() {
        return this.m_gridWidth;
    }

    public void setMaxPlots(int n) {
        if (n > 0) {
            this.m_bcSupport.firePropertyChange("maxPlots", new Integer(this.m_maxPlots), new Integer(n));
            this.m_maxPlots = n;
        }
    }

    public int getMaxPlots() {
        return this.m_maxPlots;
    }

    public void setDesign(boolean bl) {
        this.m_design = true;
        this.appearanceDesign();
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.m_visual = new BeanVisual("AttributeSummarizer", "weka/gui/beans/icons/AttributeSummarizer.gif", "weka/gui/beans/icons/AttributeSummarizer_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
    }

    protected void setUpFinal() {
        this.removeAll();
        JScrollPane jScrollPane = this.makePanel();
        this.add((Component)jScrollPane, "Center");
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            vector.addElement("Show summaries");
        }
        return vector.elements();
    }

    private JScrollPane makePanel() {
        JComponent jComponent;
        String string = this.getFont().getFamily();
        Font font = new Font(string, 0, 10);
        JPanel jPanel = new JPanel();
        jPanel.setFont(font);
        int n = Math.min(this.m_visualizeDataSet.numAttributes(), this.m_maxPlots);
        int n2 = n / this.m_gridWidth;
        if (n % this.m_gridWidth != 0) {
            ++n2;
        }
        jPanel.setLayout(new GridLayout(n2, 4));
        for (int i = 0; i < n; ++i) {
            jComponent = new JPanel();
            jComponent.setLayout(new BorderLayout());
            jComponent.setBorder(BorderFactory.createTitledBorder(this.m_visualizeDataSet.attribute(i).name()));
            AttributeVisualizationPanel attributeVisualizationPanel = new AttributeVisualizationPanel();
            attributeVisualizationPanel.setInstances(this.m_visualizeDataSet);
            attributeVisualizationPanel.setColoringIndex(this.m_coloringIndex);
            jComponent.add((Component)attributeVisualizationPanel, "Center");
            attributeVisualizationPanel.setAttribute(i);
            jPanel.add(jComponent);
        }
        Dimension dimension = new Dimension(830, n2 * 100);
        jPanel.setMinimumSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setPreferredSize(dimension);
        jComponent = new JScrollPane(jPanel);
        return jComponent;
    }

    public void setInstances(Instances instances) throws Exception {
        if (this.m_design) {
            throw new Exception("This method is not to be used during design time. It is meant to be used if this bean is being used programatically as as stand alone component.");
        }
        this.m_visualizeDataSet = instances;
        this.setUpFinal();
    }

    public void performRequest(String string) {
        block6: {
            if (!this.m_design) {
                this.setUpFinal();
                return;
            }
            if (string.compareTo("Show summaries") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        JScrollPane jScrollPane = this.makePanel();
                        final JFrame jFrame = new JFrame("Visualize");
                        jFrame.setSize(800, 600);
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)jScrollPane, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jFrame.dispose();
                                AttributeSummarizer.this.m_framePoppedUp = false;
                            }
                        });
                        jFrame.setVisible(true);
                        this.m_popupFrame = jFrame;
                        break block6;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(string + " not supported (AttributeSummarizer)");
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println("Usage: AttributeSummarizer <dataset>");
                System.exit(1);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            AttributeSummarizer attributeSummarizer = new AttributeSummarizer();
            attributeSummarizer.setInstances(instances);
            jFrame.getContentPane().add((Component)attributeSummarizer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(830, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

