/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class PolyKernel
extends CachedKernel {
    static final long serialVersionUID = -321831645846363201L;
    protected boolean m_lowerOrder = false;
    protected double m_exponent = 1.0;

    public PolyKernel() {
    }

    public PolyKernel(Instances instances, int n, double d, boolean bl) throws Exception {
        this.setCacheSize(n);
        this.setExponent(d);
        this.setUseLowerOrder(bl);
        this.buildKernel(instances);
    }

    public String globalInfo() {
        return "The polynomial kernel : K(x, y) = <x, y>^p or K(x, y) = (<x, y>+1)^p";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe Exponent to use.\n\t(default: 1.0)", "E", 1, "-E <num>"));
        vector.addElement(new Option("\tUse lower-order terms.\n\t(default: no)", "L", 0, "-L"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExponent(Double.parseDouble(string));
        } else {
            this.setExponent(1.0);
        }
        this.setUseLowerOrder(Utils.getFlag('L', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-E");
        vector.add("" + this.getExponent());
        if (this.getUseLowerOrder()) {
            vector.add("-L");
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        double d = n == n2 ? this.dotProd(instance, instance) : this.dotProd(instance, this.m_data.instance(n2));
        if (this.m_lowerOrder) {
            d += 1.0;
        }
        if (this.m_exponent != 1.0) {
            d = Math.pow(d, this.m_exponent);
        }
        return d;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void setExponent(double d) {
        this.m_exponent = d;
    }

    public double getExponent() {
        return this.m_exponent;
    }

    public String exponentTipText() {
        return "The exponent value.";
    }

    public void setUseLowerOrder(boolean bl) {
        this.m_lowerOrder = bl;
    }

    public boolean getUseLowerOrder() {
        return this.m_lowerOrder;
    }

    public String useLowerOrderTipText() {
        return "Whether to use lower-order terms.";
    }

    public String toString() {
        String string = this.getExponent() == 1.0 ? "Linear Kernel: K(x,y) = <x,y>" : (this.getUseLowerOrder() ? "Poly Kernel with lower order: K(x,y) = (<x,y> + 1)^" + this.getExponent() : "Poly Kernel: K(x,y) = <x,y>^" + this.getExponent());
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }
}

