/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import java.util.zip.GZIPInputStream;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public class ArffLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
URLSourcedLoader {
    static final long serialVersionUID = 2726929550544048587L;
    public static String FILE_EXTENSION = ".arff";
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected transient ArffReader m_ArffReader = null;

    public String globalInfo() {
        return "Reads a source that is in arff (attribute relation file format) format. ";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    public String getFileDescription() {
        return "Arff data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (this.m_File != null && new File(this.m_File).isFile()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null & !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL uRL) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(uRL.openStream());
        this.m_URL = uRL.toString();
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getAbsolutePath();
        this.setSource(file);
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setURL(String string) throws IOException {
        this.m_URL = string;
        this.setSource(new URL(string));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream inputStream) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_ArffReader = new ArffReader(this.m_sourceReader, 1);
                this.m_structure = this.m_ArffReader.getStructure();
            }
            catch (Exception exception) {
                throw new IOException("Unable to determine structure as arff (Reason: " + exception.toString() + ").");
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        Instance instance;
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        while ((instance = this.m_ArffReader.readInstance(this.m_structure)) != null) {
            this.m_structure.add(instance);
        }
        Instances instances = new Instances(this.m_structure);
        return instances;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        this.m_structure = instances;
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        Instance instance = this.m_ArffReader.readInstance(this.m_structure);
        if (instance == null) {
            try {
                this.reset();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        ArffLoader.runFileLoader(new ArffLoader(), stringArray);
    }

    public static class ArffReader {
        protected StreamTokenizer m_Tokenizer;
        protected double[] m_ValueBuffer;
        protected int[] m_IndicesBuffer;
        protected Instances m_Data;
        protected int m_Lines;

        public ArffReader(Reader reader) throws IOException {
            Instance instance;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(1000);
            this.initBuffers();
            while ((instance = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(instance);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, int n) throws IOException {
            if (n < 0) {
                throw new IllegalArgumentException("Capacity has to be positive!");
            }
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(n);
            this.initBuffers();
        }

        public ArffReader(Reader reader, Instances instances, int n) throws IOException {
            this(reader, instances, n, 100);
            Instance instance;
            while ((instance = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(instance);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, Instances instances, int n, int n2) throws IOException {
            this.m_Lines = n;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.m_Data = new Instances(instances, n2);
            this.initBuffers();
        }

        protected void initBuffers() {
            this.m_ValueBuffer = new double[this.m_Data.numAttributes()];
            this.m_IndicesBuffer = new int[this.m_Data.numAttributes()];
        }

        protected void compactify() {
            if (this.m_Data != null) {
                this.m_Data.compactify();
            }
        }

        protected void errorMessage(String string) throws IOException {
            String string2 = string + ", read " + this.m_Tokenizer.toString();
            if (this.m_Lines > 0) {
                int n = Integer.parseInt(string2.replaceAll(".* line ", ""));
                string2 = string2.replaceAll(" line .*", " line " + (this.m_Lines + n - 1));
            }
            throw new IOException(string2);
        }

        public int getLineNo() {
            return this.m_Lines + this.m_Tokenizer.lineno();
        }

        protected void getFirstToken() throws IOException {
            while (this.m_Tokenizer.nextToken() == 10) {
            }
            if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void getIndex() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
        }

        protected void getLastToken(boolean bl) throws IOException {
            if (!(this.m_Tokenizer.nextToken() == 10 || this.m_Tokenizer.ttype == -1 && bl)) {
                this.errorMessage("end of line expected");
            }
        }

        protected void getNextToken() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            } else if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void initTokenizer() {
            this.m_Tokenizer.resetSyntax();
            this.m_Tokenizer.whitespaceChars(0, 32);
            this.m_Tokenizer.wordChars(33, 255);
            this.m_Tokenizer.whitespaceChars(44, 44);
            this.m_Tokenizer.commentChar(37);
            this.m_Tokenizer.quoteChar(34);
            this.m_Tokenizer.quoteChar(39);
            this.m_Tokenizer.ordinaryChar(123);
            this.m_Tokenizer.ordinaryChar(125);
            this.m_Tokenizer.eolIsSignificant(true);
        }

        public Instance readInstance(Instances instances) throws IOException {
            return this.readInstance(instances, true);
        }

        public Instance readInstance(Instances instances, boolean bl) throws IOException {
            return this.getInstance(instances, bl);
        }

        protected Instance getInstance(Instances instances, boolean bl) throws IOException {
            this.m_Data = instances;
            if (this.m_Data.numAttributes() == 0) {
                this.errorMessage("no header information available");
            }
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                return null;
            }
            if (this.m_Tokenizer.ttype == 123) {
                return this.getInstanceSparse(bl);
            }
            return this.getInstanceFull(bl);
        }

        protected Instance getInstanceSparse(boolean bl) throws IOException {
            Object object;
            Object object2;
            int n = 0;
            int n2 = -1;
            while (true) {
                this.getIndex();
                if (this.m_Tokenizer.ttype == 125) break;
                try {
                    this.m_IndicesBuffer[n] = Integer.valueOf(this.m_Tokenizer.sval);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage("index number expected");
                }
                if (this.m_IndicesBuffer[n] <= n2) {
                    this.errorMessage("indices have to be ordered");
                }
                if (this.m_IndicesBuffer[n] < 0 || this.m_IndicesBuffer[n] >= this.m_Data.numAttributes()) {
                    this.errorMessage("index out of bounds");
                }
                n2 = this.m_IndicesBuffer[n];
                this.getNextToken();
                if (this.m_Tokenizer.ttype == 63) {
                    this.m_ValueBuffer[n] = Instance.missingValue();
                } else {
                    if (this.m_Tokenizer.ttype != -3) {
                        this.errorMessage("not a valid value");
                    }
                    switch (this.m_Data.attribute(this.m_IndicesBuffer[n]).type()) {
                        case 1: {
                            int n3 = this.m_Data.attribute(this.m_IndicesBuffer[n]).indexOfValue(this.m_Tokenizer.sval);
                            if (n3 == -1) {
                                this.errorMessage("nominal value not declared in header");
                            }
                            this.m_ValueBuffer[n] = n3;
                            break;
                        }
                        case 0: {
                            try {
                                this.m_ValueBuffer[n] = Double.valueOf(this.m_Tokenizer.sval);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.errorMessage("number expected");
                            }
                            break;
                        }
                        case 2: {
                            this.m_ValueBuffer[n] = this.m_Data.attribute(this.m_IndicesBuffer[n]).addStringValue(this.m_Tokenizer.sval);
                            break;
                        }
                        case 3: {
                            try {
                                this.m_ValueBuffer[n] = this.m_Data.attribute(this.m_IndicesBuffer[n]).parseDate(this.m_Tokenizer.sval);
                            }
                            catch (ParseException parseException) {
                                this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                            }
                            break;
                        }
                        case 4: {
                            try {
                                object2 = new ArffReader(new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(this.m_IndicesBuffer[n]).relation(), 0);
                                object = ((ArffReader)object2).getData();
                                this.m_ValueBuffer[n] = this.m_Data.attribute(this.m_IndicesBuffer[n]).addRelation((Instances)object);
                                break;
                            }
                            catch (Exception exception) {
                                throw new IOException(exception.toString() + " of line " + this.getLineNo());
                            }
                        }
                        default: {
                            this.errorMessage("unknown attribute type in column " + this.m_IndicesBuffer[n]);
                        }
                    }
                }
                ++n;
            }
            if (bl) {
                this.getLastToken(true);
            }
            object2 = new double[n];
            object = new int[n];
            System.arraycopy(this.m_ValueBuffer, 0, object2, 0, n);
            System.arraycopy(this.m_IndicesBuffer, 0, object, 0, n);
            SparseInstance sparseInstance = new SparseInstance(1.0, (double[])object2, (int[])object, this.m_Data.numAttributes());
            sparseInstance.setDataset(this.m_Data);
            return sparseInstance;
        }

        protected Instance getInstanceFull(boolean bl) throws IOException {
            double[] dArray = new double[this.m_Data.numAttributes()];
            block13: for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
                if (i > 0) {
                    this.getNextToken();
                }
                if (this.m_Tokenizer.ttype == 63) {
                    dArray[i] = Instance.missingValue();
                    continue;
                }
                if (this.m_Tokenizer.ttype != -3) {
                    this.errorMessage("not a valid value");
                }
                switch (this.m_Data.attribute(i).type()) {
                    case 1: {
                        int n = this.m_Data.attribute(i).indexOfValue(this.m_Tokenizer.sval);
                        if (n == -1) {
                            this.errorMessage("nominal value not declared in header");
                        }
                        dArray[i] = n;
                        continue block13;
                    }
                    case 0: {
                        try {
                            dArray[i] = Double.valueOf(this.m_Tokenizer.sval);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorMessage("number expected");
                        }
                        continue block13;
                    }
                    case 2: {
                        dArray[i] = this.m_Data.attribute(i).addStringValue(this.m_Tokenizer.sval);
                        continue block13;
                    }
                    case 3: {
                        try {
                            dArray[i] = this.m_Data.attribute(i).parseDate(this.m_Tokenizer.sval);
                        }
                        catch (ParseException parseException) {
                            this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                        }
                        continue block13;
                    }
                    case 4: {
                        try {
                            ArffReader arffReader = new ArffReader(new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(i).relation(), 0);
                            Instances instances = arffReader.getData();
                            dArray[i] = this.m_Data.attribute(i).addRelation(instances);
                            continue block13;
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.toString() + " of line " + this.getLineNo());
                        }
                    }
                    default: {
                        this.errorMessage("unknown attribute type in column " + i);
                    }
                }
            }
            if (bl) {
                this.getLastToken(true);
            }
            Instance instance = new Instance(1.0, dArray);
            instance.setDataset(this.m_Data);
            return instance;
        }

        protected void readHeader(int n) throws IOException {
            this.m_Lines = 0;
            String string = "";
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            if ("@relation".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.getNextToken();
                string = this.m_Tokenizer.sval;
                this.getLastToken(false);
            } else {
                this.errorMessage("keyword @relation expected");
            }
            FastVector fastVector = new FastVector();
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            while ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                fastVector = this.parseAttribute(fastVector);
            }
            if (!"@data".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.errorMessage("keyword @data expected");
            }
            if (fastVector.size() == 0) {
                this.errorMessage("no attributes declared");
            }
            this.m_Data = new Instances(string, fastVector, n);
        }

        protected FastVector parseAttribute(FastVector fastVector) throws IOException {
            this.getNextToken();
            String string = this.m_Tokenizer.sval;
            this.getNextToken();
            if (this.m_Tokenizer.ttype == -3) {
                if (this.m_Tokenizer.sval.equalsIgnoreCase("real") || this.m_Tokenizer.sval.equalsIgnoreCase("integer") || this.m_Tokenizer.sval.equalsIgnoreCase("numeric")) {
                    fastVector.addElement(new Attribute(string, fastVector.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("string")) {
                    fastVector.addElement(new Attribute(string, (FastVector)null, fastVector.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("date")) {
                    String string2 = null;
                    if (this.m_Tokenizer.nextToken() != 10) {
                        if (this.m_Tokenizer.ttype != -3 && this.m_Tokenizer.ttype != 39 && this.m_Tokenizer.ttype != 34) {
                            this.errorMessage("not a valid date format");
                        }
                        string2 = this.m_Tokenizer.sval;
                        this.readTillEOL();
                    } else {
                        this.m_Tokenizer.pushBack();
                    }
                    fastVector.addElement(new Attribute(string, string2, fastVector.size()));
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("relational")) {
                    this.readTillEOL();
                    FastVector fastVector2 = fastVector;
                    fastVector = new FastVector();
                    this.getFirstToken();
                    if (this.m_Tokenizer.ttype == -1) {
                        this.errorMessage("premature end of file");
                    }
                    while (true) {
                        if ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            fastVector = this.parseAttribute(fastVector);
                            continue;
                        }
                        if ("@end".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            this.getNextToken();
                            if (string.equalsIgnoreCase(this.m_Tokenizer.sval)) break;
                            this.errorMessage("declaration of subrelation " + string + " must be terminated by " + "@end " + string);
                            break;
                        }
                        this.errorMessage("declaration of subrelation " + string + " must be terminated by " + "@end " + string);
                    }
                    Instances instances = new Instances(string, fastVector, 0);
                    fastVector = fastVector2;
                    fastVector.addElement(new Attribute(string, instances, fastVector.size()));
                } else {
                    this.errorMessage("no valid attribute type or invalid enumeration");
                }
            } else {
                FastVector fastVector3 = new FastVector();
                this.m_Tokenizer.pushBack();
                if (this.m_Tokenizer.nextToken() != 123) {
                    this.errorMessage("{ expected at beginning of enumeration");
                }
                while (this.m_Tokenizer.nextToken() != 125) {
                    if (this.m_Tokenizer.ttype == 10) {
                        this.errorMessage("} expected at end of enumeration");
                        continue;
                    }
                    fastVector3.addElement(this.m_Tokenizer.sval);
                }
                fastVector.addElement(new Attribute(string, fastVector3, fastVector.size()));
            }
            this.getLastToken(false);
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            return fastVector;
        }

        protected void readTillEOL() throws IOException {
            while (this.m_Tokenizer.nextToken() != 10) {
            }
            this.m_Tokenizer.pushBack();
        }

        public Instances getStructure() {
            return new Instances(this.m_Data, 0);
        }

        public Instances getData() {
            return this.m_Data;
        }
    }
}

