/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;

public class LFSMethods {
    private static final int MAX_SUBSET_SIZE = 200;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private int m_evalsTotal;
    private int m_evalsCached;
    private BitSet[] m_bestGroupOfSize = new BitSet[200];

    public BitSet getBestGroup() {
        return this.m_bestGroup;
    }

    public double getBestMerit() {
        return this.m_bestMerit;
    }

    public BitSet getBestGroupOfSize(int n) {
        return this.m_bestGroupOfSize[n];
    }

    public int getNumEvalsCached() {
        return this.m_evalsCached;
    }

    public int getNumEvalsTotal() {
        return this.m_evalsTotal;
    }

    public int[] rankAttributes(Instances instances, SubsetEvaluator subsetEvaluator, boolean bl) throws Exception {
        if (bl) {
            System.out.println("Ranking attributes with " + subsetEvaluator.getClass().getName());
        }
        double[] dArray = new double[instances.numAttributes()];
        BitSet bitSet = new BitSet(instances.numAttributes());
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i != instances.classIndex()) {
                bitSet.set(i);
                int n = i;
                dArray[n] = dArray[n] - subsetEvaluator.evaluateSubset(bitSet);
                ++this.m_evalsTotal;
                bitSet.clear(i);
            } else {
                dArray[i] = Double.MAX_VALUE;
            }
            if (!bl) continue;
            System.out.println(i + ": " + dArray[i]);
        }
        int[] nArray = Utils.sort(dArray);
        if (bl) {
            System.out.print("Ranking [ ");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(nArray[i] + " ");
            }
            System.out.println("]\n");
        }
        return nArray;
    }

    public BitSet forwardSearch(int n, BitSet bitSet, int[] nArray, int n2, boolean bl, int n3, int n4, Instances instances, SubsetEvaluator subsetEvaluator, boolean bl2) throws Exception {
        if (n4 > 0 && n3 > 1) {
            throw new Exception("Forcing result size only works for maxStale=1");
        }
        if (bl2) {
            System.out.println("Starting forward selection");
        }
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        LinkedList2 linkedList2 = new LinkedList2(n3);
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>(n * instances.numAttributes());
        int n7 = 0;
        int n8 = 0;
        int n9 = n2;
        int n10 = 0;
        int n11 = 0;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        String string = bitSet2.toString();
        double d2 = subsetEvaluator.evaluateSubset(bitSet2);
        if (bl2) {
            System.out.print("Group: ");
            LFSMethods.printGroup(bitSet2, instances.numAttributes());
            System.out.println("Merit: " + d);
            System.out.println("----------");
        }
        hashtable.put(string, new Double(d2));
        ++n7;
        n5 = bitSet2.cardinality();
        if (n3 > 1) {
            Object[] objectArray = new Object[]{bitSet2.clone()};
            linkedList2.addToList(objectArray, d2);
        }
        while (n8 < n3) {
            BitSet bitSet3;
            boolean bl3 = false;
            if (n3 > 1) {
                if (linkedList2.size() == 0) {
                    n8 = n3;
                    break;
                }
                Link2 link2 = linkedList2.getLinkAt(0);
                bitSet3 = (BitSet)link2.getData()[0];
                bitSet3 = (BitSet)bitSet3.clone();
                linkedList2.removeLinkAt(0);
                n6 = 0;
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (!bitSet3.get(i)) continue;
                    ++n6;
                }
            } else {
                bitSet3 = (BitSet)bitSet2.clone();
                n6 = n5;
            }
            n9 = bl ? Math.min(Math.max(n9, n2 + n6), instances.numAttributes()) : n2;
            for (int i = 0; i < n9; ++i) {
                if (nArray[i] == instances.classIndex() || bitSet3.get(nArray[i])) continue;
                bitSet3.set(nArray[i]);
                ++n6;
                string = bitSet3.toString();
                if (!hashtable.containsKey(string)) {
                    ++n10;
                    d = subsetEvaluator.evaluateSubset(bitSet3);
                    if (n7 > n * instances.numAttributes()) {
                        hashtable = new Hashtable(n * instances.numAttributes());
                        n7 = 0;
                    }
                    hashtable.put(string, new Double(d));
                    ++n7;
                } else {
                    ++n11;
                    d = (Double)hashtable.get(string);
                }
                if (bl2) {
                    System.out.print("Group: ");
                    LFSMethods.printGroup(bitSet3, instances.numAttributes());
                    System.out.println("Merit: " + d);
                }
                if (d - d2 > 1.0E-5 || n4 >= n6 && n6 > n5) {
                    bl3 = true;
                    n8 = 0;
                    d2 = d;
                    n5 = n6;
                    bitSet2 = (BitSet)bitSet3.clone();
                    this.m_bestGroupOfSize[n5] = (BitSet)bitSet3.clone();
                }
                if (n3 > 1) {
                    Object[] objectArray = new Object[]{bitSet3.clone()};
                    linkedList2.addToList(objectArray, d);
                }
                bitSet3.clear(nArray[i]);
                --n6;
            }
            if (bl2) {
                System.out.println("----------");
            }
            if (!bl3 || n4 == n5) {
                ++n8;
            }
            if (n4 <= 0 || n5 != n4) continue;
        }
        if (bl2) {
            System.out.println("Best Group: ");
            LFSMethods.printGroup(bitSet2, instances.numAttributes());
            System.out.println();
        }
        this.m_bestGroup = bitSet2;
        this.m_bestMerit = d2;
        this.m_evalsTotal += n10;
        this.m_evalsCached += n11;
        return bitSet2;
    }

    public BitSet floatingForwardSearch(int n, BitSet bitSet, int[] nArray, int n2, boolean bl, int n3, Instances instances, SubsetEvaluator subsetEvaluator, boolean bl2) throws Exception {
        if (bl2) {
            System.out.println("Starting floating forward selection");
        }
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        LinkedList2 linkedList2 = new LinkedList2(n3);
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>(n * instances.numAttributes());
        int n6 = 0;
        int n7 = 0;
        int n8 = n2;
        int n9 = 0;
        int n10 = 0;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        String string = bitSet2.toString();
        double d2 = subsetEvaluator.evaluateSubset(bitSet2);
        if (bl2) {
            System.out.print("Group: ");
            LFSMethods.printGroup(bitSet2, instances.numAttributes());
            System.out.println("Merit: " + d);
            System.out.println("----------");
        }
        hashtable.put(string, new Double(d2));
        ++n6;
        n4 = bitSet2.cardinality();
        if (n3 > 1) {
            Object[] objectArray = new Object[]{bitSet2.clone()};
            linkedList2.addToList(objectArray, d2);
        }
        boolean bl3 = true;
        boolean bl4 = true;
        while (true) {
            BitSet bitSet3;
            if (bl4) {
                if (!bl3) {
                    bl4 = false;
                }
            } else {
                if (!bl3 && n7 >= n3) break;
                bl4 = true;
            }
            bl3 = false;
            if (n3 > 1) {
                if (linkedList2.size() == 0) {
                    n7 = n3;
                    break;
                }
                Link2 link2 = linkedList2.getLinkAt(0);
                bitSet3 = (BitSet)link2.getData()[0];
                bitSet3 = (BitSet)bitSet3.clone();
                linkedList2.removeLinkAt(0);
                n5 = 0;
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (!bitSet3.get(i)) continue;
                    ++n5;
                }
            } else {
                bitSet3 = (BitSet)bitSet2.clone();
                n5 = n4;
            }
            if (bl4 && n5 <= 2) {
                bl4 = false;
            }
            n8 = bl ? Math.max(n8, Math.min(Math.max(n8, n2 + n5), instances.numAttributes())) : n2;
            for (int i = 0; i < n8; ++i) {
                if (nArray[i] == instances.classIndex()) continue;
                if (bl4) {
                    if (!bitSet3.get(nArray[i])) continue;
                    bitSet3.clear(nArray[i]);
                    --n5;
                } else {
                    if (nArray[i] == instances.classIndex() || bitSet3.get(nArray[i])) continue;
                    bitSet3.set(nArray[i]);
                    ++n5;
                }
                string = bitSet3.toString();
                if (!hashtable.containsKey(string)) {
                    ++n9;
                    d = subsetEvaluator.evaluateSubset(bitSet3);
                    if (n6 > n * instances.numAttributes()) {
                        hashtable = new Hashtable(n * instances.numAttributes());
                        n6 = 0;
                    }
                    hashtable.put(string, new Double(d));
                    ++n6;
                } else {
                    ++n10;
                    d = (Double)hashtable.get(string);
                }
                if (bl2) {
                    System.out.print("Group: ");
                    LFSMethods.printGroup(bitSet3, instances.numAttributes());
                    System.out.println("Merit: " + d);
                }
                if (d - d2 > 1.0E-5) {
                    bl3 = true;
                    n7 = 0;
                    d2 = d;
                    n4 = n5;
                    bitSet2 = (BitSet)bitSet3.clone();
                }
                if (n3 > 1) {
                    Object[] objectArray = new Object[]{bitSet3.clone()};
                    linkedList2.addToList(objectArray, d);
                }
                if (bl4) {
                    bitSet3.set(nArray[i]);
                    ++n5;
                    continue;
                }
                bitSet3.clear(nArray[i]);
                --n5;
            }
            if (bl2) {
                System.out.println("----------");
            }
            if (n3 > 1 && bl4 && !bl3) {
                Object[] objectArray = new Object[]{bitSet3.clone()};
                linkedList2.addToList(objectArray, Double.MAX_VALUE);
            }
            if (bl4 || bl3) continue;
            ++n7;
        }
        if (bl2) {
            System.out.println("Best Group: ");
            LFSMethods.printGroup(bitSet2, instances.numAttributes());
            System.out.println();
        }
        this.m_bestGroup = bitSet2;
        this.m_bestMerit = d2;
        this.m_evalsTotal += n9;
        this.m_evalsCached += n10;
        return bitSet2;
    }

    protected static void printGroup(BitSet bitSet, int n) {
        System.out.print("{ ");
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            System.out.print(i + 1 + " ");
        }
        System.out.println("}");
    }

    public class LinkedList2
    extends FastVector {
        int m_MaxSize;

        public LinkedList2(int n) {
            this.m_MaxSize = n;
        }

        public void removeLinkAt(int n) throws Exception {
            if (n < 0 || n >= this.size()) {
                throw new Exception("index out of range (removeLinkAt)");
            }
            this.removeElementAt(n);
        }

        public Link2 getLinkAt(int n) throws Exception {
            if (this.size() == 0) {
                throw new Exception("List is empty (getLinkAt)");
            }
            if (n >= 0 && n < this.size()) {
                return (Link2)this.elementAt(n);
            }
            throw new Exception("index out of range (getLinkAt)");
        }

        public void addToList(Object[] objectArray, double d) throws Exception {
            Link2 link2 = new Link2(objectArray, d);
            if (this.size() == 0) {
                this.addElement(link2);
            } else if (d > ((Link2)this.firstElement()).m_merit) {
                if (this.size() == this.m_MaxSize) {
                    this.removeLinkAt(this.m_MaxSize - 1);
                }
                this.insertElementAt(link2, 0);
            } else {
                int n = 0;
                int n2 = this.size();
                boolean bl = false;
                if (n2 != this.m_MaxSize || !(d <= ((Link2)this.lastElement()).m_merit)) {
                    while (!bl && n < n2) {
                        if (d > ((Link2)this.elementAt((int)n)).m_merit) {
                            if (n2 == this.m_MaxSize) {
                                this.removeLinkAt(this.m_MaxSize - 1);
                            }
                            this.insertElementAt(link2, n);
                            bl = true;
                            continue;
                        }
                        if (n == n2 - 1) {
                            this.addElement(link2);
                            bl = true;
                            continue;
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public class Link2
    implements Serializable {
        Object[] m_data;
        double m_merit;

        public Link2(Object[] objectArray, double d) {
            this.m_data = objectArray;
            this.m_merit = d;
        }

        public Object[] getData() {
            return this.m_data;
        }

        public String toString() {
            return "Node: " + this.m_data.toString() + "  " + this.m_merit;
        }
    }
}

