/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import weka.classifiers.CostMatrix;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.TwoClassStats;
import weka.core.FastVector;
import weka.core.Matrix;
import weka.core.Utils;

public class ConfusionMatrix
extends Matrix {
    protected String[] m_ClassNames;

    public ConfusionMatrix(String[] stringArray) {
        super(stringArray.length, stringArray.length);
        this.m_ClassNames = (String[])stringArray.clone();
    }

    public ConfusionMatrix makeWeighted(CostMatrix costMatrix) throws Exception {
        if (costMatrix.size() != this.size()) {
            throw new Exception("Cost and confusion matrices must be the same size");
        }
        ConfusionMatrix confusionMatrix = new ConfusionMatrix(this.m_ClassNames);
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                confusionMatrix.setElement(i, j, this.getElement(i, j) * costMatrix.getElement(i, j));
            }
        }
        return confusionMatrix;
    }

    public Object clone() {
        ConfusionMatrix confusionMatrix = (ConfusionMatrix)super.clone();
        confusionMatrix.m_ClassNames = (String[])this.m_ClassNames.clone();
        return confusionMatrix;
    }

    public int size() {
        return this.m_ClassNames.length;
    }

    public String className(int n) {
        return this.m_ClassNames[n];
    }

    public void addPrediction(NominalPrediction nominalPrediction) throws Exception {
        if (nominalPrediction.predicted() == Prediction.MISSING_VALUE) {
            throw new Exception("No predicted value given.");
        }
        if (nominalPrediction.actual() == Prediction.MISSING_VALUE) {
            throw new Exception("No actual value given.");
        }
        this.addElement((int)nominalPrediction.actual(), (int)nominalPrediction.predicted(), nominalPrediction.weight());
    }

    public void addPredictions(FastVector fastVector) throws Exception {
        for (int i = 0; i < fastVector.size(); ++i) {
            this.addPrediction((NominalPrediction)fastVector.elementAt(i));
        }
    }

    public TwoClassStats getTwoClassStats(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                if (i == n) {
                    if (j == n) {
                        d2 += this.getElement(i, j);
                        continue;
                    }
                    d3 += this.getElement(i, j);
                    continue;
                }
                if (j == n) {
                    d += this.getElement(i, j);
                    continue;
                }
                d4 += this.getElement(i, j);
            }
        }
        return new TwoClassStats(d2, d, d4, d3);
    }

    public double correct() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += this.getElement(i, i);
        }
        return d;
    }

    public double incorrect() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                if (i == j) continue;
                d += this.getElement(i, j);
            }
        }
        return d;
    }

    public double total() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                d += this.getElement(i, j);
            }
        }
        return d;
    }

    public double errorRate() {
        return this.incorrect() / this.total();
    }

    public String toString() {
        return this.toString("=== Confusion Matrix ===\n");
    }

    public String toString(String string) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean bl = false;
        double d = 0.0;
        for (n2 = 0; n2 < this.size(); ++n2) {
            for (n = 0; n < this.size(); ++n) {
                double d2 = this.getElement(n2, n);
                if (d2 < 0.0) {
                    d2 *= -10.0;
                }
                if (d2 > d) {
                    d = d2;
                }
                double d3 = d2 - Math.rint(d2);
                if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                bl = true;
            }
        }
        int n3 = 1 + Math.max((int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 3 : 0)), (int)(Math.log(this.size()) / Math.log(cArray.length)));
        stringBuffer.append(string).append("\n");
        for (n2 = 0; n2 < this.size(); ++n2) {
            if (bl) {
                stringBuffer.append(" ").append(ConfusionMatrix.num2ShortID(n2, cArray, n3 - 3)).append("   ");
                continue;
            }
            stringBuffer.append(" ").append(ConfusionMatrix.num2ShortID(n2, cArray, n3));
        }
        stringBuffer.append("     actual class\n");
        for (n2 = 0; n2 < this.size(); ++n2) {
            for (n = 0; n < this.size(); ++n) {
                stringBuffer.append(" ").append(Utils.doubleToString(this.getElement(n2, n), n3, bl ? 2 : 0));
            }
            stringBuffer.append(" | ").append(ConfusionMatrix.num2ShortID(n2, cArray, n3)).append(" = ").append(this.m_ClassNames[n2]).append("\n");
        }
        return stringBuffer.toString();
    }

    private static String num2ShortID(int n, char[] cArray, int n2) {
        int n3;
        char[] cArray2 = new char[n2];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            cArray2[n3] = cArray[n % cArray.length];
            if ((n = n / cArray.length - 1) < 0) break;
        }
        --n3;
        while (n3 >= 0) {
            cArray2[n3] = 32;
            --n3;
        }
        return new String(cArray2);
    }
}

