/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.local.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class LAGDHillClimber
extends HillClimber {
    int m_nNrOfLookAheadSteps = 2;
    int m_nNrOfGoodOperations = 5;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        int n = this.m_nNrOfLookAheadSteps;
        int n2 = this.m_nNrOfGoodOperations;
        this.lookAheadInGoodDirectionsSearch(bayesNet, instances, n, n2);
    }

    protected void lookAheadInGoodDirectionsSearch(BayesNet bayesNet, Instances instances, int n, int n2) throws Exception {
        System.out.println("Initializing Cache");
        this.initCache(bayesNet, instances);
        while (n > 1) {
            int n3;
            System.out.println("Look Ahead Depth: " + n);
            boolean bl = true;
            double d = 0.0;
            HillClimber.Operation[] operationArray = new HillClimber.Operation[n];
            operationArray = this.getOptimalOperations(bayesNet, instances, n, n2);
            for (n3 = 0; n3 < n; ++n3) {
                if (operationArray[n3] == null) {
                    bl = false;
                    continue;
                }
                d += operationArray[n3].m_fDeltaScore;
            }
            while (bl && d > 0.0) {
                System.out.println("Next Iteration..........................");
                for (n3 = 0; n3 < n; ++n3) {
                    this.performOperation(bayesNet, instances, operationArray[n3]);
                }
                operationArray = this.getOptimalOperations(bayesNet, instances, n, n2);
                d = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    if (operationArray[n3] != null) {
                        System.out.println(operationArray[n3].m_nOperation + " " + operationArray[n3].m_nHead + " " + operationArray[n3].m_nTail);
                        d += operationArray[n3].m_fDeltaScore;
                    } else {
                        bl = false;
                    }
                    System.out.println("DeltaScore: " + d);
                }
            }
            --n;
        }
        HillClimber.Operation operation = this.getOptimalOperation(bayesNet, instances);
        while (operation != null && operation.m_fDeltaScore > 0.0) {
            this.performOperation(bayesNet, instances, operation);
            System.out.println("Performing last greedy steps");
            operation = this.getOptimalOperation(bayesNet, instances);
        }
        this.m_Cache = null;
    }

    protected HillClimber.Operation getAntiOperation(HillClimber.Operation operation) throws Exception {
        if (operation.m_nOperation == 0) {
            return new HillClimber.Operation(operation.m_nTail, operation.m_nHead, 1);
        }
        if (operation.m_nOperation == 1) {
            return new HillClimber.Operation(operation.m_nTail, operation.m_nHead, 0);
        }
        return new HillClimber.Operation(operation.m_nHead, operation.m_nTail, 2);
    }

    protected HillClimber.Operation[] getGoodOperations(BayesNet bayesNet, Instances instances, int n) throws Exception {
        int n2;
        HillClimber.Operation[] operationArray = new HillClimber.Operation[n];
        for (n2 = 0; n2 < n; ++n2) {
            operationArray[n2] = this.getOptimalOperation(bayesNet, instances);
            if (operationArray[n2] != null) {
                this.m_Cache.put(operationArray[n2], -1.0E100);
                continue;
            }
            n2 = n;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (operationArray[n2] != null) {
                if (operationArray[n2].m_nOperation != 2) {
                    this.m_Cache.put(operationArray[n2], operationArray[n2].m_fDeltaScore);
                    continue;
                }
                this.m_Cache.put(operationArray[n2], operationArray[n2].m_fDeltaScore - this.m_Cache.m_fDeltaScoreAdd[operationArray[n2].m_nHead][operationArray[n2].m_nTail]);
                continue;
            }
            n2 = n;
        }
        return operationArray;
    }

    protected HillClimber.Operation[] getOptimalOperations(BayesNet bayesNet, Instances instances, int n, int n2) throws Exception {
        if (n == 1) {
            HillClimber.Operation[] operationArray = new HillClimber.Operation[]{this.getOptimalOperation(bayesNet, instances)};
            return operationArray;
        }
        double d = 0.0;
        double d2 = 0.0;
        HillClimber.Operation[] operationArray = new HillClimber.Operation[n];
        HillClimber.Operation[] operationArray2 = new HillClimber.Operation[n2];
        HillClimber.Operation[] operationArray3 = new HillClimber.Operation[n - 1];
        operationArray2 = this.getGoodOperations(bayesNet, instances, n2);
        for (int i = 0; i < n2; ++i) {
            if (operationArray2[i] != null) {
                int n3;
                this.performOperation(bayesNet, instances, operationArray2[i]);
                operationArray3 = this.getOptimalOperations(bayesNet, instances, n - 1, n2);
                d2 = operationArray2[i].m_fDeltaScore;
                for (n3 = 0; n3 < n - 1; ++n3) {
                    if (operationArray3[n3] == null) continue;
                    d2 += operationArray3[n3].m_fDeltaScore;
                }
                this.performOperation(bayesNet, instances, this.getAntiOperation(operationArray2[i]));
                if (!(d2 > d)) continue;
                d = d2;
                operationArray[0] = operationArray2[i];
                for (n3 = 1; n3 < n; ++n3) {
                    operationArray[n3] = operationArray3[n3 - 1];
                }
                continue;
            }
            i = n2;
        }
        return operationArray;
    }

    public void setMaxNrOfParents(int n) {
        this.m_nMaxNrOfParents = n;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public void setNrOfLookAheadSteps(int n) {
        this.m_nNrOfLookAheadSteps = n;
    }

    public int getNrOfLookAheadSteps() {
        return this.m_nNrOfLookAheadSteps;
    }

    public void setNrOfGoodOperations(int n) {
        this.m_nNrOfGoodOperations = n;
    }

    public int getNrOfGoodOperations() {
        return this.m_nNrOfGoodOperations;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tLook Ahead Depth\n)", "L", 2, "-L <nr of look ahead steps>"));
        vector.addElement(new Option("\tNr of Good Operations\n)", "G", 5, "-G <nr of good operations>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setNrOfLookAheadSteps(Integer.parseInt(string));
        } else {
            this.setNrOfLookAheadSteps(2);
        }
        String string2 = Utils.getOption('G', stringArray);
        if (string2.length() != 0) {
            this.setNrOfGoodOperations(Integer.parseInt(string2));
        } else {
            this.setNrOfGoodOperations(5);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[9 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.m_nNrOfLookAheadSteps;
        stringArray2[n++] = "-G";
        stringArray2[n++] = "" + this.m_nNrOfGoodOperations;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a Look Ahead Hill Climbing algorithm called LAGD Hill Climbing. Unlike Greedy Hill Climbing it doesn't calculate a best greedy operation (adding, deleting or reversing an arc) but a sequence of nrOfLookAheadSteps operations, which leads to a network structure whose score is most likely higher in comparison to the network obtained by performing a sequence of nrOfLookAheadSteps greedy operations. The search is not restricted by an order on the variables (unlike K2). The difference with B and B2 is that this hill climber also considers arrows part of the naive Bayes structure for deletion.";
    }

    public String nrOfLookAheadStepsTipText() {
        return "Sets the Number of Look Ahead Steps. 'nrOfLookAheadSteps = 2' means that all network structures in a distance of 2 (from the current network structure) are taken into account for the decision which arcs to add, remove or reverse. 'nrOfLookAheadSteps = 1' results in Greedy Hill Climbing.";
    }

    public String nrOfGoodOperationsTipText() {
        return "Sets the Number of Good Operations per Look Ahead Step. 'nrOfGoodOperations = 5' means that for the next Look Ahead Step only the 5 best Operations (adding, deleting or reversing an arc) are taken into account for the calculation of the best sequence consisting of nrOfLookAheadSteps operations.";
    }
}

