/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarWrapper;
import weka.core.Instance;
import weka.core.Instances;

public class KStarNumericAttribute
implements KStarConstants {
    protected Instances m_TrainSet;
    protected Instance m_Test;
    protected Instance m_Train;
    protected int m_AttrIndex;
    protected double m_Scale = 1.0;
    protected double m_MissingProb = 1.0;
    protected double m_AverageProb = 1.0;
    protected double m_SmallestProb = 1.0;
    protected double[] m_Distances;
    protected int[][] m_RandClassCols;
    protected int m_ActualCount = 0;
    protected KStarCache m_Cache;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_BlendFactor = 20;

    public KStarNumericAttribute(Instance instance, Instance instance2, int n, Instances instances, int[][] nArray, KStarCache kStarCache) {
        this.m_Test = instance;
        this.m_Train = instance2;
        this.m_AttrIndex = n;
        this.m_TrainSet = instances;
        this.m_RandClassCols = nArray;
        this.m_Cache = kStarCache;
        this.init();
    }

    private void init() {
        try {
            this.m_NumInstances = this.m_TrainSet.numInstances();
            this.m_NumClasses = this.m_TrainSet.numClasses();
            this.m_NumAttributes = this.m_TrainSet.numAttributes();
            this.m_ClassType = this.m_TrainSet.classAttribute().type();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double transProb() {
        double d;
        String string = "(KStarNumericAttribute.transProb) ";
        if (this.m_Cache.containsKey(this.m_Test.value(this.m_AttrIndex))) {
            KStarCache.TableEntry tableEntry = this.m_Cache.getCacheValues(this.m_Test.value(this.m_AttrIndex));
            this.m_Scale = tableEntry.value;
            this.m_MissingProb = tableEntry.pmiss;
        } else {
            this.m_Scale = this.m_BlendMethod == 2 ? this.scaleFactorUsingEntropy() : this.scaleFactorUsingBlend();
            this.m_Cache.store(this.m_Test.value(this.m_AttrIndex), this.m_Scale, this.m_MissingProb);
        }
        if (this.m_Train.isMissing(this.m_AttrIndex)) {
            d = this.m_MissingProb;
        } else {
            double d2 = Math.abs(this.m_Test.value(this.m_AttrIndex) - this.m_Train.value(this.m_AttrIndex));
            d = this.PStar(d2, this.m_Scale);
        }
        return d;
    }

    private double scaleFactorUsingBlend() {
        double d;
        double d2;
        double d3;
        double d4;
        block22: {
            String string = "(KStarNumericAttribute.scaleFactorUsingBlend)";
            int n = 0;
            boolean bl = false;
            double d5 = -1.0;
            double d6 = -1.0;
            double d7 = 9.0E300;
            d4 = 1.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            KStarWrapper kStarWrapper = new KStarWrapper();
            KStarWrapper kStarWrapper2 = new KStarWrapper();
            KStarWrapper kStarWrapper3 = new KStarWrapper();
            this.m_Distances = new double[this.m_NumInstances];
            for (int i = 0; i < this.m_NumInstances; ++i) {
                if (this.m_TrainSet.instance(i).isMissing(this.m_AttrIndex)) {
                    this.m_Distances[i] = -1.0;
                    continue;
                }
                this.m_Distances[i] = Math.abs(this.m_TrainSet.instance(i).value(this.m_AttrIndex) - this.m_Test.value(this.m_AttrIndex));
                if (this.m_Distances[i] + 1.0E-5 < d6 || d6 == -1.0) {
                    if (this.m_Distances[i] + 1.0E-5 < d5 || d5 == -1.0) {
                        d6 = d5;
                        d5 = this.m_Distances[i];
                        n = 1;
                    } else if (Math.abs(this.m_Distances[i] - d5) < 1.0E-5) {
                        ++n;
                    } else {
                        d6 = this.m_Distances[i];
                    }
                }
                ++this.m_ActualCount;
            }
            if (d6 == -1.0 || d5 == -1.0) {
                d4 = 1.0;
                this.m_AverageProb = 1.0;
                this.m_SmallestProb = 1.0;
                return d4;
            }
            double d8 = 1.0 / (d6 - d5);
            int n2 = 0;
            double d9 = (double)(this.m_ActualCount - n) * (double)this.m_BlendFactor / 100.0 + (double)n;
            if (this.m_BlendFactor == 0) {
                d9 += 1.0;
            }
            double d10 = 0.005;
            double d11 = d8 * 16.0;
            this.calculateSphereSize(d10, kStarWrapper);
            kStarWrapper.sphere -= d9;
            this.calculateSphereSize(d11, kStarWrapper2);
            kStarWrapper2.sphere -= d9;
            if (kStarWrapper.sphere < 0.0) {
                d = d10;
                d3 = kStarWrapper.avgProb;
                d2 = kStarWrapper.minProb;
            } else if (kStarWrapper2.sphere > 0.0) {
                d = d11;
                d3 = kStarWrapper2.avgProb;
                d2 = kStarWrapper2.minProb;
            } else {
                do {
                    double d12;
                    this.calculateSphereSize(d8, kStarWrapper3);
                    kStarWrapper3.sphere -= d9;
                    if (Math.abs(kStarWrapper3.sphere) < d7) {
                        d7 = Math.abs(kStarWrapper3.sphere);
                        d = d8;
                        d3 = kStarWrapper3.avgProb;
                        d2 = kStarWrapper3.minProb;
                    }
                    if (Math.abs(kStarWrapper3.sphere) <= 0.01) break block22;
                    if (kStarWrapper3.sphere > 0.0) {
                        d12 = (d8 + d11) / 2.0;
                        d10 = d8;
                        d8 = d12;
                        continue;
                    }
                    d12 = (d8 + d10) / 2.0;
                    d11 = d8;
                    d8 = d12;
                } while (++n2 <= 40);
                d8 = d;
            }
        }
        this.m_SmallestProb = d2;
        this.m_AverageProb = d3;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        d4 = d;
        return d4;
    }

    private void calculateSphereSize(double d, KStarWrapper kStarWrapper) {
        double d2;
        String string = "(KStarNumericAttribute.calculateSphereSize)";
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.m_NumInstances; ++i) {
            if (this.m_Distances[i] < 0.0) continue;
            double d6 = this.PStar(this.m_Distances[i], d);
            if (d3 > d6) {
                d3 = d6;
            }
            double d7 = d6 / (double)this.m_ActualCount;
            d4 += d7;
            d5 += d7 * d7;
        }
        kStarWrapper.sphere = d2 = d5 == 0.0 ? 0.0 : d4 * d4 / d5;
        kStarWrapper.avgProb = d4;
        kStarWrapper.minProb = d3;
    }

    private double scaleFactorUsingEntropy() {
        String string = "(KStarNumericAttribute.scaleFactorUsingEntropy)";
        if (this.m_ClassType != 1) {
            System.err.println("Error: " + string + " attribute class must be nominal!");
            System.exit(1);
        }
        int n = 0;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 1.0;
        KStarWrapper kStarWrapper = new KStarWrapper();
        KStarWrapper kStarWrapper2 = new KStarWrapper();
        KStarWrapper kStarWrapper3 = new KStarWrapper();
        this.m_Distances = new double[this.m_NumInstances];
        for (int i = 0; i < this.m_NumInstances; ++i) {
            if (this.m_TrainSet.instance(i).isMissing(this.m_AttrIndex)) {
                this.m_Distances[i] = -1.0;
                continue;
            }
            this.m_Distances[i] = Math.abs(this.m_TrainSet.instance(i).value(this.m_AttrIndex) - this.m_Test.value(this.m_AttrIndex));
            if (this.m_Distances[i] + 1.0E-5 < d2 || d2 == -1.0) {
                if (this.m_Distances[i] + 1.0E-5 < d || d == -1.0) {
                    d2 = d;
                    d = this.m_Distances[i];
                    n = 1;
                } else if (Math.abs(this.m_Distances[i] - d) < 1.0E-5) {
                    ++n;
                } else {
                    d2 = this.m_Distances[i];
                }
            }
            ++this.m_ActualCount;
        }
        if (d2 == -1.0 || d == -1.0) {
            d9 = 1.0;
            this.m_AverageProb = 1.0;
            this.m_SmallestProb = 1.0;
            return d9;
        }
        double d10 = 1.0 / (d2 - d);
        double d11 = 0.005;
        double d12 = d10 * 8.0;
        this.calculateEntropy(d12, kStarWrapper2);
        this.calculateEntropy(d11, kStarWrapper);
        double d13 = kStarWrapper.actEntropy - kStarWrapper2.actEntropy;
        double d14 = kStarWrapper.randEntropy - kStarWrapper2.randEntropy;
        double d15 = d10 = d11;
        double d16 = 0.1;
        double d17 = 0.1;
        double d18 = kStarWrapper.avgProb;
        double d19 = kStarWrapper.minProb;
        double d20 = (d12 - d11) / 20.0;
        int n2 = 0;
        do {
            double d21;
            ++n2;
            double d22 = d16;
            if ((d10 += Math.log(d10 + 1.0) * d20) <= d11) {
                d10 = d11;
                d16 = 0.0;
                d21 = -1.0;
            } else if (d10 >= d12) {
                d10 = d12;
                d16 = 0.0;
                d21 = -1.0;
            } else {
                this.calculateEntropy(d10, kStarWrapper3);
                kStarWrapper3.randEntropy = (kStarWrapper3.randEntropy - kStarWrapper2.randEntropy) / d14;
                kStarWrapper3.actEntropy = (kStarWrapper3.actEntropy - kStarWrapper2.actEntropy) / d14;
                d16 = kStarWrapper3.randEntropy - kStarWrapper3.actEntropy;
                if (d16 < 0.1) {
                    d16 = 0.1;
                    if (d20 < 0.0) {
                        d17 = d16;
                        d15 = d11;
                        d18 = kStarWrapper.avgProb;
                        d19 = kStarWrapper.minProb;
                        break;
                    }
                }
                d21 = d16 - d22;
            }
            if (d16 > d17) {
                d17 = d16;
                d15 = d10;
                d19 = kStarWrapper3.minProb;
                d18 = kStarWrapper3.avgProb;
            }
            if (!(d21 < 0.0)) continue;
            if (Math.abs(d20) < 0.01) break;
            d20 /= -4.0;
        } while (n2 <= 40);
        this.m_SmallestProb = d19;
        this.m_AverageProb = d18;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        d9 = d15;
        return d9;
    }

    private void calculateEntropy(double d, KStarWrapper kStarWrapper) {
        int n;
        int n2;
        int n3;
        String string = "(KStarNumericAttribute.calculateEntropy)";
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double[][] dArray = new double[6][this.m_NumClasses];
        for (n3 = 0; n3 <= 5; ++n3) {
            for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                dArray[n3][n2] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.m_NumInstances; ++n2) {
            if (this.m_Distances[n2] < 0.0) continue;
            double d6 = this.PStar(this.m_Distances[n2], d);
            double d7 = d6 / (double)this.m_ActualCount;
            d4 += d7;
            if (d6 < d5) {
                d5 = d6;
            }
            for (n = 0; n <= 5; ++n) {
                double[] dArray2 = dArray[n];
                int n4 = this.m_RandClassCols[n][n2];
                dArray2[n4] = dArray2[n4] + d7;
            }
        }
        for (n3 = this.m_NumClasses - 1; n3 >= 0; --n3) {
            double d8 = dArray[5][n3] / d4;
            if (!(d8 > 0.0)) continue;
            d2 -= d8 * Math.log(d8) / 0.693147181;
        }
        for (n = 0; n < 5; ++n) {
            for (n2 = this.m_NumClasses - 1; n2 >= 0; --n2) {
                double d9 = dArray[n][n2] / d4;
                if (!(d9 > 0.0)) continue;
                d3 -= d9 * Math.log(d9) / 0.693147181;
            }
        }
        kStarWrapper.actEntropy = d2;
        kStarWrapper.randEntropy = d3 /= 5.0;
        kStarWrapper.avgProb = d4;
        kStarWrapper.minProb = d5;
    }

    private double PStar(double d, double d2) {
        return d2 * Math.exp(-2.0 * d * d2);
    }

    public void setOptions(int n, int n2, int n3) {
        this.m_MissingMode = n;
        this.m_BlendMethod = n2;
        this.m_BlendFactor = n3;
    }

    public void setMissingMode(int n) {
        this.m_MissingMode = n;
    }

    public void setBlendMethod(int n) {
        this.m_BlendMethod = n;
    }

    public void setBlendFactor(int n) {
        this.m_BlendFactor = n;
    }
}

