/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataVisualizer;
import weka.gui.visualize.MatrixPanel;

public class ScatterPlotMatrix
extends DataVisualizer {
    protected MatrixPanel m_matrixPanel;

    public ScatterPlotMatrix() {
        this.appearanceFinal();
    }

    public String globalInfo() {
        return "Visualize incoming data/training/test sets in a scatter plot matrix.";
    }

    protected void appearanceDesign() {
        this.m_matrixPanel = null;
        this.removeAll();
        this.m_visual = new BeanVisual("ScatterPlotMatrix", "weka/gui/beans/icons/ScatterPlotMatrix.gif", "weka/gui/beans/icons/ScatterPlotMatrix_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        if (this.m_matrixPanel == null) {
            this.m_matrixPanel = new MatrixPanel();
        }
        this.add((Component)this.m_matrixPanel, "Center");
    }

    public void setInstances(Instances instances) throws Exception {
        if (this.m_design) {
            throw new Exception("This method is not to be used during design time. It is meant to be used if this bean is being used programatically as as stand alone component.");
        }
        this.m_visualizeDataSet = instances;
        this.m_matrixPanel.setInstances(this.m_visualizeDataSet);
    }

    public void performRequest(String string) {
        block5: {
            if (string.compareTo("Show plot") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        MatrixPanel matrixPanel = new MatrixPanel();
                        matrixPanel.setInstances(this.m_visualizeDataSet);
                        final JFrame jFrame = new JFrame("Visualize");
                        jFrame.setSize(800, 600);
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)matrixPanel, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jFrame.dispose();
                                ScatterPlotMatrix.this.m_framePoppedUp = false;
                            }
                        });
                        jFrame.setVisible(true);
                        this.m_popupFrame = jFrame;
                        break block5;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(string + " not supported (ScatterPlotMatrix)");
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println("Usage: ScatterPlotMatrix <dataset>");
                System.exit(1);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            ScatterPlotMatrix scatterPlotMatrix = new ScatterPlotMatrix();
            scatterPlotMatrix.setInstances(instances);
            jFrame.getContentPane().add((Component)scatterPlotMatrix, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

