/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;

public class MIWrapper
extends SingleClassifierEnhancer
implements MultiInstanceCapabilitiesHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -7707766152904315910L;
    protected int m_NumClasses;
    public static final int TESTMETHOD_ARITHMETIC = 1;
    public static final int TESTMETHOD_GEOMETRIC = 2;
    public static final int TESTMETHOD_MAXPROB = 3;
    public static final Tag[] TAGS_TESTMETHOD = new Tag[]{new Tag(1, "arithmetic average"), new Tag(2, "geometric average"), new Tag(3, "max probability of positive bag")};
    protected int m_Method = 2;
    protected MultiInstanceToPropositional m_ConvertToProp = new MultiInstanceToPropositional();
    protected int m_WeightMethod = 3;

    public String globalInfo() {
        return "A simple Wrapper method for applying standard propositional learners to multi-instance data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "E. T. Frank and X. Xu");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Applying propositional learning algorithms to multi-instance data");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "06");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "University of Waikato");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Department of Computer Science, University of Waikato, Hamilton, NZ");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe method used in testing:\n\t1.arithmetic average\n\t2.geometric average\n\t3.max probability of positive bag.\n\t(default: 1)", "P", 1, "-P [1|2|3]"));
        vector.addElement(new Option("\tThe type of weight setting for each single-instance:\n\t0.keep the weight to be the same as the original value;\n\t1.weight = 1.0\n\t2.weight = 1.0/Total number of single-instance in the\n\t\tcorresponding bag\n\t3. weight = Total number of single-instance / (Total\n\t\tnumber of bags * Total number of single-instance \n\t\tin the corresponding bag).\n\t(default: 3)", "A", 1, "-A [0|1|2|3]"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setMethod(new SelectedTag(Integer.parseInt(string), TAGS_TESTMETHOD));
        } else {
            this.setMethod(new SelectedTag(1, TAGS_TESTMETHOD));
        }
        String string2 = Utils.getOption('A', stringArray);
        if (string2.length() != 0) {
            this.setWeightMethod(new SelectedTag(Integer.parseInt(string2), MultiInstanceToPropositional.TAGS_WEIGHTMETHOD));
        } else {
            this.setWeightMethod(new SelectedTag(3, MultiInstanceToPropositional.TAGS_WEIGHTMETHOD));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getDebug()) {
            vector.add("-D");
        }
        vector.add("-P");
        vector.add("" + this.m_Method);
        vector.add("-A");
        vector.add("" + this.m_WeightMethod);
        return vector.toArray(new String[vector.size()]);
    }

    public String weightMethodTipText() {
        return "The method used for weighting the instances.";
    }

    public void setWeightMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == MultiInstanceToPropositional.TAGS_WEIGHTMETHOD) {
            this.m_WeightMethod = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getWeightMethod() {
        return new SelectedTag(this.m_WeightMethod, MultiInstanceToPropositional.TAGS_WEIGHTMETHOD);
    }

    public String methodTipText() {
        return "The method used for testing.";
    }

    public void setMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TESTMETHOD) {
            this.m_Method = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getMethod() {
        return new SelectedTag(this.m_Method, TAGS_TESTMETHOD);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        if (super.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        }
        if (super.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        }
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (this.getDebug()) {
            System.out.println("Start training ...");
        }
        this.m_NumClasses = instances2.numClasses();
        this.m_ConvertToProp.setWeightMethod(this.getWeightMethod());
        this.m_ConvertToProp.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_ConvertToProp);
        instances2.deleteAttributeAt(0);
        this.m_Classifier.buildClassifier(instances2);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        Instances instances = new Instances(instance.dataset(), 0);
        instances.add(instance);
        this.m_ConvertToProp.setWeightMethod(new SelectedTag(0, MultiInstanceToPropositional.TAGS_WEIGHTMETHOD));
        instances = Filter.useFilter(instances, this.m_ConvertToProp);
        instances.deleteAttributeAt(0);
        double[] dArray = new double[this.m_NumClasses];
        double d = instances.numInstances();
        double[] dArray2 = new double[this.m_NumClasses];
        int n = 0;
        while ((double)n < d) {
            double[] dArray3 = this.m_Classifier.distributionForInstance(instances.instance(n));
            block6: for (int i = 0; i < this.m_NumClasses; ++i) {
                switch (this.m_Method) {
                    case 1: {
                        int n2 = i;
                        dArray[n2] = dArray[n2] + dArray3[i] / d;
                        continue block6;
                    }
                    case 2: {
                        if (dArray3[i] < 0.001) {
                            dArray3[i] = 0.001;
                        } else if (dArray3[i] > 0.999) {
                            dArray3[i] = 0.999;
                        }
                        int n3 = i;
                        dArray[n3] = dArray[n3] + Math.log(dArray3[i]) / d;
                        continue block6;
                    }
                    case 3: {
                        if (!(dArray3[i] > dArray2[i])) continue block6;
                        dArray2[i] = dArray3[i];
                    }
                }
            }
            ++n;
        }
        if (this.m_Method == 2) {
            for (n = 0; n < this.m_NumClasses; ++n) {
                dArray[n] = Math.exp(dArray[n]);
            }
        }
        if (this.m_Method == 3) {
            dArray[1] = dArray2[1];
            dArray[0] = 1.0 - dArray[1];
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = 1.0 / (double)dArray.length;
            }
        } else {
            Utils.normalize(dArray);
        }
        return dArray;
    }

    public String toString() {
        return "MIWrapper with base classifier: \n" + this.m_Classifier.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new MIWrapper(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

