% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.test.R
\name{test_returnValue_vector_elementbyelement}
\alias{test_returnValue_vector_elementbyelement}
\title{Tests a Standard R 'vector' Element-By-Element ('RTestTest_vector_elementbyelement')}
\usage{
test_returnValue_vector_elementbyelement(result, reference, xmlTestSpec,
  add.desc = NULL)
}
\arguments{
\item{result}{(\code{vector}) The result vector to be tested}

\item{reference}{(\code{vector}) The reference vector}

\item{xmlTestSpec}{(\code{XMLNode}) The XML definition of type
'RTestTest_vector_elementbyelement'}

\item{add.desc}{(\code{character}) Additional description added to the XML
definition.}
}
\description{
Tests a Standard R 'vector' Element-By-Element ('RTestTest_vector_elementbyelement')
}
\examples{

# Cleaning up

tryCatch(unloadNamespace("RTest"))
tryCatch(unloadNamespace("testthat"))
library(RTest)

data <- '<test_variable desc="Compare a value" diff-type="absolute" compare-type="equal"
        tolerance="1E-3"/>'
xmlTestSpec <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))

test_returnValue_vector_elementbyelement(c(5,5),c(5,5),xmlTestSpec)
test_returnValue_vector_elementbyelement(c(5,5),c(5,5.000001),xmlTestSpec)

data <- '<test_variable desc="Compare a value" diff-type="relative" compare-type="equal"
        tolerance="1E-6"/>'
xmlTestSpec <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))

tryCatch(unloadNamespace("RTest"))
tryCatch(unloadNamespace("testthat"))
library(RTest)

tryCatch(
    test_returnValue_vector_elementbyelement(c(5,5),c(5,5.0001),xmlTestSpec),
    error=function(e){
      stopifnot(grepl("5 not equal to 5.0001.",e))
     })

}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
