% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\docType{methods}
\name{getRTMInfos}
\alias{getRTMInfos}
\alias{getRTMInfos,RTestCase-method}
\title{Create RTM from executed test cases}
\usage{
\S4method{getRTMInfos}{RTestCase}(object, test.for = NULL,
  cols = c("Version", "Type", "sDesc"))
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCase-class}} object.}

\item{test.for}{(\code{character}) Vector with package names that should be tested or
NULL to get all packages available from the test case.}

\item{cols}{(\code{character}) Defines which information columns are shown for
the TCs in the RTM. The ordering in the vector is also the ordering
in the output ('Version','Type','Label','sDesc','lDesc').}
}
\value{
(\code{list}) Listing of test case details (ID, Version, Type, sDesc) and 
          assigned specification IDs (SpecIDs) and risk IDs (RiskIDs).
}
\description{
Creates the requirement traceability matrix for this test case.
}
\seealso{
\code{\link{RTestCase-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
