% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\docType{class}
\name{RTestCase-class}
\alias{RTestCase-class}
\title{The 'RTestCase' Class}
\description{
Objects of the \code{RTestCase} class specify and implement the general behavoir of the  
XML-based test cases (TC).
}
\details{
On basis of Based on a XML definition file (see \code{'RTestCase.xsd'}), test cases are defined
for the individual packages / projects to be tested. Thereby, this class definition provides
the general outline of the individual test case classes (i.e. test case adapters), which have
to implement the project- and package-specific requirements and test logic.

The slot '\code{tests}' represents the execution environment for a test case and stores all
information about the execution including test case metainformation, test result (success or 
failed), the testthat reporter and the test cache. It has the following format:\cr
\code{XML:                     tests:}\cr
\code{tests}\cr
\code{ |- Pkg_1               [Pkg_1][1]}\cr
\code{ |    - funct_01        [Pkg_1][1][funct_01][1] = list( ... )}\cr 
\code{ |- Pkg_1               [Pkg_1][2]}\cr
\code{ |   |- funct_01        [Pkg_1][2][funct_01][1] = list( ... )}\cr
\code{ |   |- funct_01        [Pkg_1][2][funct_01][2] = list( ... )}\cr
\code{ |    - funct_02        [Pkg_1][2][funct_02][1] = list( ... )}\cr 
\code{  - Pkg_2               [Pkg_2][1]}\cr
\code{      - funct_01        [Pkg_2][1][funct_01][1] = list( ... )}\cr
}
\section{Slots}{

\describe{
\item{\code{ID}}{(\code{character}) ID of the TC.}

\item{\code{tc.type}}{(\code{character}) Type of the TC (i.e. the class name).}

\item{\code{synopsis}}{(\code{list}) Synopsis information of the TC (as defined in the XSD
ComplexType 'RTestSynopis').}

\item{\code{xml.fPath}}{(\code{character}) Path to XML definition file of the TC.}

\item{\code{xml.root}}{(\code{XMLNode}) The imported TC definition as \code{XMLNode}-class 
object.}

\item{\code{input.data}}{(\code{list}) The input data of the test case, which will be filled
using the method \code{\link{readXMLInputData}}.}

\item{\code{tests}}{(\code{list}) A list with the test results or NULL, if the test case 
has not been executed (see 'Details').}

\item{\code{test.for}}{(\code{character}) Names of the packages, which were tested in the last
execution of the test case. NULL, if the test case has not been 
executed.}

\item{\code{test.result}}{(\code{character}) Result of the last test case execution ('SUCCESS' or 
'FAILURE'). NULL, if the test case has not been executed.}
}}

\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
