% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npv.R
\name{npv}
\alias{npv}
\title{NPV}
\usage{
npv(
  init.cost = -375,
  C = 50,
  cf.freq = 0.25,
  TV = 250,
  T2M = 2,
  disc.factors = us.df,
  BreakEven = FALSE,
  BE.yield = 0.01
)
}
\arguments{
\item{init.cost}{Initial investment cost}

\item{C}{Periodic cash flow}

\item{cf.freq}{Cash flow frequency in year fraction e.g. quarterly = 0.25}

\item{TV}{Terminal Value}

\item{T2M}{Time to Maturity in years}

\item{disc.factors}{Data frame of discount factors using ir.df.us() function.}

\item{BreakEven}{TRUE when using a flat discount rate assumption.}

\item{BE.yield}{Set the flat IR rate when BreakEven = TRUE.}
}
\value{
List of NPV and NPV Data frame
}
\description{
Computes NPV with discount factor interpolation.
This function is used for teaching NPV and NPV at Risk and needs to be customized.
}
\examples{
npv(
  init.cost = -375, C = 50, cf.freq = .5, TV = 250, T2M = 2,
  disc.factors = RTL::usSwapCurves, BreakEven = FALSE, BE.yield = .0399
)$npv
npv(
  init.cost = -375, C = 50, cf.freq = .5, TV = 250, T2M = 2,
  disc.factors = RTL::usSwapCurves, BreakEven = FALSE, BE.yield = .0399
)$df
}
\author{
Philippe Cote
}
