% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainfun.R
\name{RTIGER}
\alias{RTIGER}
\title{Load, Fit, and plot}
\usage{
RTIGER(expDesign, rigidity=NULL, outputdir=NULL, nstates = 3,
seqlengths = NULL, eps=0.01, max.iter=50, trace = FALSE,
tiles = 4e5, all = TRUE, random = FALSE, specific = FALSE,
nsamples = 20, post.processing = TRUE, save.results = TRUE, verbose = TRUE)
}
\arguments{
\item{expDesign}{a data Frame that contains minimum a column with the files direction (name of the column files) and another with a shorter name to be used inside the function.}

\item{rigidity}{an integer number specifying the rigidity parameter to be used.}

\item{outputdir}{a character string that specifies the directory in which to save the results form the function.}

\item{nstates}{the number of states to be fitted in the model. A standard setting would use 3 states (Homozygous1, Heterozygous, and Homozygous2).}

\item{seqlengths}{a named vector with the chromosome lenghts of the organism that the user is working with.}

\item{eps}{the threshold of the difference between the parameters value between the previous and actuay iteration to stope de EM algorithm.}

\item{max.iter}{maximum number of iterations of the EM algorithm before to stop in case that eps has not been achieved.}

\item{trace}{logical value. Whether or not to keep track of the parameters for the HMM along the iterations. Deafault FALSE}

\item{tiles}{length of the tiles by which the genome will be segmented in order to compute the ratio of COs in the complete dataset.}

\item{all}{logical value. Whether to use the complete data set to fit the rHMM. default TRUE.}

\item{random}{Logical value. Choose randomly a subset of the complete dataset to fit the rHMM. Default FALSE}

\item{specific}{Logical value to specify which samples to take.}

\item{nsamples}{if random TRUE, how many samples should be taken randomly.}

\item{post.processing}{Logical value. Whether to run an extra step that fine maps the segment borthers. Default TRUE}

\item{save.results}{Logical value, whether to generate and save the plots and igv files.}

\item{verbose}{Logical, whether to print info to console.}
}
\value{
Matrix m x n. M number of samples and N chromosomes.

RTIGER object
}
\description{
Load, Fit, and plot
}
\examples{
\dontrun{
data("ATseqlengths")
sourceJulia()
path = system.file("extdata",  package = "RTIGER")
files = list.files(path, full.names = TRUE)
nam = sapply(list.files(path ), function(x) unlist(strsplit(x, split = "[.]"))[1])
expDesign = data.frame(files = files, name = nam)
names(ATseqlengths) = paste0("Chr", 1:5)
myres = RTIGER(expDesign = expDesign,
               outputdir = "/home/campos/Documents/outputjulia/",
               seqlengths = ATseqlengths,
               rigidity = 4,
               max.iter = 2,
               trace = FALSE,
               save.results = TRUE)
}

}
