% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_repo_adapter.R
\name{repo_adapter_create_base}
\alias{repo_adapter_create_base}
\title{Creates base presentation for repo adapter to use by concrete implementations.}
\usage{
repo_adapter_create_base(name)
}
\arguments{
\item{name}{name under which repository adapter will be registered in RSuite. It
cannot contain whitespaces or comma. (type: character)}
}
\value{
object of type rsuite_repo_adapter
}
\description{
Creates base presentation for repo adapter to use by concrete implementations.
}
\examples{
# create you own Repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
\concept{in extending RSuite with Repo adapter}
