% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_upload_prj_packages}
\alias{repo_upload_prj_packages}
\title{Builds and uploads project package(s) into the repository.}
\usage{
repo_upload_prj_packages(repo_manager, pkgs = NULL, prj = NULL,
  skip_rc = FALSE, pkg_type = .Platform$pkgType, with_deps = FALSE,
  skip_build_steps = NULL)
}
\arguments{
\item{repo_manager}{repo manager to use for uploading. (type: rsuite_repo_manager)}

\item{pkgs}{vector of project packages which should be uploaded into the repository
or NULL to upload all project packages (type: character, default: NULL)}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{skip_rc}{if TRUE skip detection of package revision and package tagging.
(type: logical, default: FALSE)}

\item{pkg_type}{type of packages to upload (type: character, default: platform default)}

\item{with_deps}{If TRUE will include pkgs dependencies while uploading into the
repository. Packages in repository satisfying pkgs requirements will not be
included. (type: logical, default: FALSE)}

\item{skip_build_steps}{character vector with steps to skip while building
   project packages. Can contain following entries:
\describe{
  \item{specs}{Process packages specifics}
  \item{docs}{Try build documentation with roxygen}
  \item{imps}{Perform imports validation}
  \item{tests}{Run package tests}
  \item{rcpp_attribs}{Run rppAttribs on the package}
  \item{vignettes}{Build package vignettes}
}
(type: character(N), default: NULL).}
}
\description{
Builds and uploads project package(s) into the repository.
}
\details{
If not specified to skip RC it will detect revision version and tag packages
before uploading. In that case, a check for changes in the project sources is
performed for consistency and project packages will be rebuilt with version
altered: revision will be added as the least number to package version.

Logs all messages onto the rsuite logger. Use \code{logging::setLevel} to
control logs verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start src project
  src_prj <- prj_start("my_project_src", skip_rc = TRUE, path = prj_base)

  # create project package
  prj_start_package("mypackage", prj = src_prj, skip_rc = TRUE)

  # build project environment
  prj_install_deps(prj = src_prj)

  # start dest project
  dst_prj <- prj_start("my_project_dst", skip_rc = TRUE, path = prj_base)

  # set dest to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = dst_prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = dst_prj, ix = 1)

  # upload mypackage from src into dest's in project repository
  repo_upload_prj_packages(rmgr, prj = src_prj, skip_rc = TRUE)

  # list available packages
  repo_mng_list(rmgr)

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_bioc_package}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}}
}
