% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_api_sysreqs.R
\name{sysreqs_check}
\alias{sysreqs_check}
\title{Checks for system requirements availability.}
\usage{
sysreqs_check(prj = NULL)
}
\arguments{
\item{prj}{project object to check sys requirements for. If not passed the loaded
project will be used or the default whichever exists. Will init default project
from the working directory if no default project exists.
(type: rsuite_project, default: NULL)}
}
\description{
Collects system requirements with \code{\link{sysreqs_collect}}
and performs checks for their existence. Fill fail if some system
requirements are not satisfied.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# add dependency to XML
write("library(XML)",
      file = file.path(prj$path, "R", "master.R"),
      append = TRUE)

\donttest{
  # check if requirements or XML are satisfied
  sysreqs_check(prj)
}

}
\seealso{
Other in SYSREQS: \code{\link{sysreqs_collect}},
  \code{\link{sysreqs_install}}
}
