% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSLI.R
\name{writeSLI}
\alias{writeSLI}
\title{Write ENVI spectral libraries}
\usage{
writeSLI(x, path, wavl.units = "Micrometers", scaleF = 1,
  mode = "bin")
}
\arguments{
\item{x}{data.frame with first column containing wavelengths and all other columns containing spectra.}

\item{path}{path to spectral library file to be created.}

\item{wavl.units}{wavelength units. Defaults to Micrometers. Nanometers is another typical option.}

\item{scaleF}{optional reflectance scaling factor. Defaults to 1.}

\item{mode}{character string specifying output file type. Must be one of \code{"bin"} for binary .sli files or \code{"ASCII"} for ASCII ENVI plot files.}
}
\description{
Writes binary ENVI spectral library files (sli) with accompanying header (.sli.hdr) files OR ASCII spectral library files in ENVI format.
}
\details{
ENVI spectral libraries with ending .sli are binary arrays with spectra saved in rows.
}
\examples{

## Example data
sliFile <- system.file("external/vegSpec.sli", package="RStoolbox")
sliTmpFile <- paste0(tempdir(),"/vegetationSpectra.sli") 

## Read spectral library
sli <- readSLI(sliFile)
head(sli)
plot(sli[,1:2], col = "orange", type = "l")
lines(sli[,c(1,3)], col = "green")
 
## Write to binary spectral library
writeSLI(sli, path = sliTmpFile)
}
\seealso{
\code{\link{readSLI}}
}
