% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encodeQA.R
\name{encodeQA}
\alias{encodeQA}
\title{Encode QA Conditions to Integers}
\usage{
encodeQA(fill = "no", droppedFrame = "no", terrainOcclusion = "no",
  water = "all", snow = "all", cirrus = "all", cloud = "all")
}
\arguments{
\item{fill}{Designated fill. Options: \code{c("yes", "no", "all")}.}

\item{droppedFrame}{Dropped frame. Options: \code{c("yes", "no", "all")}.}

\item{terrainOcclusion}{Terrain induced occlusion. Options: \code{c("yes", "no", "all")}.}

\item{water}{Water confidence. Options: \code{c("na", "low", "med", "high", "all")}.}

\item{snow}{Snow / ice confidence.  Options: \code{c("na", "low", "med", "high", "all")}.}

\item{cirrus}{Cirrus confidence.  Options: \code{c("na", "low", "med", "high", "all")}.}

\item{cloud}{Cloud confidence. Options: \code{c("na", "low", "med", "high", "all")}.}
}
\value{
Returns the Integer value for the QA values
}
\description{
Intended for use with the Landsat 8 OLI QA band. Converts pixel quality flags from human readable to integer, which can then be used to 
subset the QA image. Please be aware of the default settings which differ for different parameters.
}
\note{
Only currently populated bits are available as arguments, i.e. vegetation confidence, cloud shadow and bit nr. 3. are currently useless and hence not available.
}
\examples{
encodeQA(snow = "low", cirrus = c("med", "high"), cloud = "high")
}
\references{
\url{http://landsat.usgs.gov/L8QualityAssessmentBand.php}
}

