% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildClassificationValueSegment.R
\name{BuildClassificationValueSegment}
\alias{BuildClassificationValueSegment}
\title{Build a Classification Value Segment}
\usage{
BuildClassificationValueSegment(element, search.keywords, classification = "",
  search.type = "OR")
}
\arguments{
\item{element}{List of elements on which to base the segment}

\item{search.keywords}{List of search keyword vectors for each element 
(Use ^ to pin to start and $ to pin to end, or both to specify exact match)}

\item{classification}{(optional) Classification breakdown name for the element (defaults to the element name)}

\item{search.type}{How to combine the keywords list. This defaults to 'OR' if it is not specified.}
}
\value{
Segment definition for use with Queue* functions
}
\description{
Function to build a classification value segment for use in segmenting reports.
}
\details{
Function to build a classification value segment for use in segmenting reports.

Multiple segments can be combined in a list.
Note that search can only be applied to a breakdown classification and not an element value.
}
\examples{
\dontrun{
vistor_segment <- BuildClassificationValueSegment(element,
                                                  search.keywords,
                                                  classification,
                                                  search.type)
}
}
