% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{as.ten.state.matrix}
\alias{as.ten.state.matrix}
\title{Conversion of 0/1 matrix to 10-state matrix}
\usage{
as.ten.state.matrix(mut)
}
\arguments{
\item{mut}{A dataframe representing the mutation matrix.}
}
\value{
A data frame with the exact size as \code{mut}, in which
  0, 1 and 3 (or NAs) are replaced with "A/A", "C/C", and "./.",
  respectively.
}
\description{
It converts 0 to A/A and 1 to C/C. 3 that represents missing values are converted
to "./.".
}
\note{
Note that following function does not provide inverse of as.mutation.matrix.
It could be used to generate input for scelestial.
}
\examples{
## A small 0/1/NA mutation matrix
mut = data.frame("C1" = c(0, 0), "C2" = c(0, 3), "C3" = c(1, 0), 
        stringsAsFactors = TRUE)
## Convert it to 10-state matrix
as.ten.state.matrix(mut)
#    C1  C2  C3
# 1 A/A A/A C/C
# 2 A/A ./. A/A
}
