% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeCompare.R
\name{treeCompare}
\alias{treeCompare}
\title{Visualize the difference between phylogenetic trees}
\usage{
treeCompare(tree, tree1, plot = TRUE)
}
\arguments{
\item{tree, tree1}{a phylogenetic tree. The tree needs not to be ultrametric
and fully dichotomous. Generic name and specific epithet must be separated
by '_'.}

\item{plot}{if \code{TRUE}, the function produces an interactive plotting
device to check differences in species placement at the genus level.}
}
\value{
The function returns a data-frame indicating for each un-matching
  species its sister species/clades on both trees.
}
\description{
The function scans a pair of phylogenetic trees to find
  topological differences.
}
\examples{
\dontrun{
DataSimians$tree->tree
set.seed(22)
swapONE(tree,si=0.5)[[1]]->tree1

treeCompare(tree,tree1)

}
}
\author{
Silvia Castiglione, Carmela Serio, Antonella Esposito
}
