% Generated by roxygen2 (4.0.2): do not edit by hand
\name{EichhornHayre}
\alias{EichhornHayre}
\title{Eichhorn-Hayre model}
\usage{
EichhornHayre(z,mu,sigma,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{mu}{mean of the scramble variable \eqn{S}}

\item{sigma}{standard deviation of the scramble variable \eqn{S}}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Eichhorn-Hayre model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Eichhorn-Hayre model.
The function can also return the transformed variable.
The Eichhorn-Hayre model was proposed by Eichhorn and Hayre in 1983.
}
\details{
The randomized response given by the person labelled \eqn{i} is \eqn{z_i=y_iS} where \eqn{S} is a scramble variable whose distribution is assumed to be known.
}
\examples{
data(EichhornHayreData)
dat=with(EichhornHayreData,data.frame(z,Pi))
mu=1.111111
sigma=0.5414886
cl=0.95
#This line returns a warning showing why the variance estimation is not possible.
#See ResamplingVariance for several alternatives.
EichhornHayre(dat$z,mu,sigma,dat$Pi,"mean",cl)
}
\references{
Eichhorn, B.H., Hayre, L.S. (1983).
\emph{Scrambled randomized response methods for obtaining sensitive quantitative data.}
Journal of Statistical Planning and Inference, 7, 306-316.
}
\seealso{
\code{\link{EichhornHayreData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{EichhornHayre}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

