% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.lm.rrpp.r
\name{logLik.lm.rrpp}
\alias{logLik.lm.rrpp}
\title{Calculate the log-likelihood of a lm.rrpp fit}
\usage{
\method{logLik}{lm.rrpp}(object, tol = NULL, pc.no = NULL, Z = TRUE, gls.null = FALSE, ...)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}}

\item{tol}{A value indicating the magnitude below which 
components should be omitted, following projection.  See \code{\link{ordinate}} 
for details.}

\item{pc.no}{Optionally, a number specifying the maximal number of 
principal components, passed onto \code{\link{ordinate}}, as argument, rank.}

\item{Z}{A logical value for whether to calculate Z scores based on RRPP.}

\item{gls.null}{A logical value for if a fit has a GLS estimation, should
the null model (intercept) also have a GLS estimation, for estimating Z.  
Should be FALSE if the log-likelihood is measured to compare different GLS
estimations for a covariance matrices}

\item{...}{further arguments passed to or from other methods}
}
\description{
\code{logLik.lm.rrpp} returns the log-likelihood of
an \code{lm.rrpp} object.  Ridge regularization will be performed for 
ill-conditioned or singular residual covariance matrices, but dimension
reduction could be augmented via projection, using the arguments, tol
and pc.no.  See \code{\link{ordinate}} for details.
}
\author{
Michael Collyer
}
\keyword{utilities}
