% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRPP.support.code.r
\name{rrpp.data.frame}
\alias{rrpp.data.frame}
\title{Create a data frame for lm.rrpp analysis}
\usage{
rrpp.data.frame(...)
}
\arguments{
\item{...}{Components (objects) to combine in the data frame.}
}
\description{
Create a data frame for lm.rrpp analysis, when covariance or distance matrices are used
}
\details{
This function is not much different than \code{\link{data.frame}} but is more flexible to allow
distance matrices and covariance matrices to be included.  Essentially, this function creates a list,
much like an object of class \code{data.frame} is also a list.  However, \code{rrpp.data.frame} is
less concerned with coercing the list into a matrix and more concerned with matching the number of observations (n).
It is wise to use this function with any \code{lm.rrpp} analysis so that \code{\link{lm.rrpp}} does not have to search
the global environment for needed data.

It is assumed that multiple data sets for the same subjects are in the same order.

See \code{\link{lm.rrpp}} for examples.
}
\examples{
# Why use a rrpp.data.frame?
y <- matrix(rnorm(30), 10, 3)
x <- rnorm(10)
df <- data.frame(x = x, y = y)
df
rdf <- rrpp.data.frame(x = x, y = y)
rdf # looks more like a list

is.list(df)
is.list(rdf)

d <- dist(y) # distance matrix as data

# One can try this but it will result in an error
# df <- data.frame(df, d = d) 
rdf <- rrpp.data.frame(rdf, d = d) # works

fit <- lm.rrpp(d ~ x, data = rdf)
summary(fit)
}
\author{
Michael Collyer
}
\keyword{utilities}
