% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrt_lasso.R
\name{sqrt_lasso}
\alias{sqrt_lasso}
\title{Square-root Lasso regression}
\usage{
sqrt_lasso(x, y, lam0 = NULL, exclude = integer(0), output_all = FALSE,
  ...)
}
\arguments{
\item{x}{Input matrix of dimension nobs by nvars; each row is an observation
vector.}

\item{y}{Response variable; shoud be a numeric vector.}

\item{lam0}{Tuning parameter for the square-root / scaled Lasso. If left
blank (recommended) this is chosen using the method of Sun & Zhang (2013)
implemented in the \pkg{scalreg} package.}

\item{exclude}{Indices of variables to be excluded from the model; default is
none.}

\item{output_all}{In addition to the vector of coefficients, if \code{TRUE},
also outputs the intercept, an estimate of the noise standard deviation,
and the output of \code{\link[glmnet]{glmnet}}.}

\item{...}{Additional arguments to be passed to \code{\link[glmnet]{glmnet}}.}
}
\value{
Either an estimated vector of regression coefficients with nvars
  components or, if \code{output_all} is \code{true}, a list with components
  \describe{
    \item{\code{beta}}{the vector of regression coefficents}
    \item{\code{a0}}{an intercept term}
    \item{\code{sigma_hat}}{an estimate of
      the noise standard deviation; this is calculated as square-root of the
      average residual sums of squares}
    \item{\code{glm_obj}}{the fitted \code{glmnet} object, an S3 class ``\code{glmnet}"}
  }
}
\description{
Fits a linear model to potentially high-dimensional data using the
square-root Lasso, also known as the scaled Lasso. The Lasso path is computed
using the \pkg{glmnet} package.
}
\details{
First the Lasso path is computed using \code{glmnet} from
  \pkg{glmnet}. Next the particular point on the path corresponding to the
  square-root Lasso solution is found. As the path is only computed on a grid
  of points, the square-root solution is approximate.
}
\examples{
x <- matrix(rnorm(100*250), 100, 250)
y <- x[, 1] + x[, 2] + rnorm(100)
out <- sqrt_lasso(x, y)
}
\references{
A. Belloni, V. Chernozhukov, and L. Wang. (2011)
  \emph{Square-root lasso: pivotal recovery of sparse signals via conic
  programming. Biometrika, 98(4):791-806.}
  \url{http://biomet.oxfordjournals.org/content/98/4/791.refs} T. Sun and
  C.-H. Zhang. (2012) \emph{Scaled sparse linear regression. Biometrika,
  99(4):879-898.}
  \url{http://biomet.oxfordjournals.org/content/early/2012/09/24/biomet.ass043.short}
   T. Sun and C.-H. Zhang. (2013) \emph{Sparse matrix inversion with scaled
  lasso. The Journal of Machine Learning Research, 14(1):3385-3418.}
  \url{www.jmlr.org/papers/volume14/sun13a/sun13a.pdf}
}
\seealso{
\code{\link[glmnet]{glmnet}} and \code{\link[scalreg]{scalreg}}.
}

