\name{Manage connections}
\alias{db.connect}
\alias{db.disconnect}
\alias{db.connection.status}
\alias{db.connection.open}
\alias{db.error.message}
\alias{db.name}
\alias{db.host.name}
\alias{db.connection.options}
\alias{db.user.name}
\alias{db.password}
\alias{db.connection.port}
\alias{db.debug.tty}
\title{Open and manage database connection}
\usage{
db.connect(host=NULL, hostaddr=NULL, port=NULL, dbname=NULL, user=NULL,
 password=NULL, authtype=NULL, options=NULL, tty=NULL, verbose=T)
db.disconnect()
db.connection.status()
db.connection.open()
db.error.message()
db.name()
db.host.name()
db.connection.options()
db.user.name()
db.password()
db.connection.port()
db.debug.tty()
}
\arguments{
 \item{host}{PostgreSQL server host name}
 \item{port}{PostgreSQL server port number}
 \item{dbname}{database name}
 \item{user}{database user name}
 \item{password}{user password}
 \item{authtype}{authentication type}
 \item{options}{additional PostgreSQL options}
 \item{tty}{debugging tty}
 \item{verbose}{report some information}
}
\description{
  \code{db.connect} establishes a connection between RPgSQL and a
  PostgreSQL server.\cr
  \code{db.disconnect} terminates a database connection.\cr
  \code{db.connection.status} returns the current connection status.\cr
  \code{db.connection.open} is used to check whether a connection is
  open.\cr
  \code{db.error.message} returns the error message most recently
  generated by an operation on the connection.\cr
  \code{db.name} returns the current database name.\cr
  \code{db.host.name} returns the name of the database host.\cr
  \code{db.connection.options} returns the connection options string.\cr
  \code{db.user.name} returns the user name of the current connection.\cr
  \code{db.password} returns the current connection password.\cr
  \code{db.debug.tty} returns the debugging tty.\cr
}
\details{
  Currently, \code{db.connect} does not return a  handle, so you can
  only open a single connection at a time.
}
\notes{
  Default values for all of the arguments to \code{db.connect} can be
  set using the following environment variables:
  
  PGHOST sets the default server name. If a non-zero-length string is
  specified, TCP/IP communication is used. Without a host name, libpq will
  connect using a local Unix domain socket.

  PGPORT sets the default port or local Unix domain socket file
  extension for communicating with the PostgreSQL back end.

  PGDATABASE sets the default PostgreSQL database name.

  PGUSER sets the username used to connect to the database and for
  authentication.

  PGPASSWORD sets the password used if the back end demands password
  authentication.

  PGOPTIONS sets additional runtime options for the PostgreSQL back end.
}
\author{Timothy H. Keitt}
\keyword{database}
