% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpdtest.R
\name{rpdTest}
\alias{rpdTest}
\title{Randomized phi-divergence test}
\usage{
rpdTest(
  data,
  p = rep(1/length(data), length(data)),
  lambda = 1,
  sim.pValue = FALSE,
  ll = 5,
  simNum = 30,
  edfLen = 2500,
  n.cores = NULL
)
}
\arguments{
\item{data}{a one-dimensional vector or matrix of this shape (data.frame)
in which observation data for some multinomial distribution are stored.}

\item{p}{the probability vector in the null hypothesis. Will check the
validity of this vector.}

\item{lambda}{a control parameter of the statistic calculation,
adjusting it will significantly change the final obtained statistic.}

\item{sim.pValue}{a logical variable. It decides whether to compute p-values
in Monte Carlo simulation.}

\item{ll}{an integer specifying the number of outer loops of the
Monte Carlo simulation.}

\item{simNum}{an integer specifying the number of inner loops of the
Monte Carlo simulation.}

\item{edfLen}{an integer that adjusts the number of points used to generate
the empirical distribution function used to perform the simulation.}

\item{n.cores}{an integer used to specify the number of cores used
to perform parallel operations. The default is to use the maximum number
of cores available to the computer minus one.}
}
\value{
standard list object with class "htest".
}
\description{
The most important part of the package:
a function for performing hypothesis testing ----
An analogue of Chi-square Goodness-of-Fit Test.
Accept a vector, matrix or a \link{data.frame} as observed data.
Then obtain a specific Randomized phi-divergence statistic,
which is computed based on a uniformly distributed random vector
on the n-sphere. This random vector is uniquely generated at runtime.
No definite p-value is provided at current stage.
However, a p-values in Monte Carlo simulation is available as an option. It
executes in parallel within a nested for loop to reduce randomness.
In the current version (0.0.1), this feature is still being debugged and improved,
so this option is not enabled by default.
}
\examples{
d <- rmultinom(1, 120, c(1/4,3/4))
#following will only obtain statistic
rpdTest(d)
#following will obtain sim.p.value either. You can also specify the number of
#cores to use. For example, two:
#It usually takes 1-2 minutes to perform this calculation process
\donttest{
rpdTest(d,sim.pValue = TRUE,n.cores = 2)
}
}
